/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.mailbox.fetch;

import javax.mail.FetchProfile;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Store;
import jetbrains.mps.internationalization.runtime.LocalizationObject;
import jetbrains.youtrack.mailbox.persistence.XdMailbox;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 )2\u00020\u0001:\u0001)B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u001b\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\nH\u0002J,\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\n2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\n0\u001fH\u0002J,\u0010 \u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\n2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\n0\u001fH\u0002J,\u0010 \u001a\u00020\u001c2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001d\u001a\u00020\n2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\n0\u001fJ,\u0010#\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\n2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\n0\u001fH\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\"H\u0002J\u0018\u0010'\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\nH\u0002J\u0014\u0010(\u001a\u0004\u0018\u00010\u00182\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006*"}, d2={"Ljetbrains/youtrack/mailbox/fetch/EmailFetcher;", "", "mailbox", "Ljetbrains/youtrack/mailbox/persistence/XdMailbox;", "store", "Ljavax/mail/Store;", "fetchLimit", "", "isCanceled", "Lkotlin/Function0;", "", "(Ljetbrains/youtrack/mailbox/persistence/XdMailbox;Ljavax/mail/Store;ILkotlin/jvm/functions/Function0;)V", "getFetchLimit", "()I", "fetched", "()Lkotlin/jvm/functions/Function0;", "getMailbox", "()Ljetbrains/youtrack/mailbox/persistence/XdMailbox;", "getStore", "()Ljavax/mail/Store;", "fetchMessages", "", "Ljavax/mail/Message;", "folder", "Ljavax/mail/Folder;", "(Ljavax/mail/Folder;)[Ljavax/mail/Message;", "fetchMustBeStopped", "foreachImmediateMessage", "", "readonly", "job", "Lkotlin/Function1;", "foreachMessage", "folderName", "", "foreachSubfolderMessage", "getCantResolveFolderText", "Ljetbrains/mps/internationalization/runtime/LocalizationObject;", "visibleName", "openFolder", "resolveFolder", "Companion", "youtrack-mailbox"})
public final class EmailFetcher {
    private int fetched;
    @NotNull
    private final XdMailbox mailbox;
    @NotNull
    private final Store store;
    private final int fetchLimit;
    @NotNull
    private final Function0<Boolean> isCanceled;
    @NotNull
    public static final String DEFAULT_FOLDER_NAME = "INBOX";
    public static final Companion Companion = new Companion(null);

    public final void foreachMessage(@Nullable String folderName, boolean readonly, @NotNull Function1<? super Message, Boolean> job) {
        Intrinsics.checkParameterIsNotNull(job, (String)"job");
        Folder folder = this.resolveFolder(folderName);
        if (folder != null) {
            this.foreachMessage(folder, readonly, job);
        }
    }

    private final void foreachMessage(Folder folder, boolean readonly, Function1<? super Message, Boolean> job) {
        if (!this.fetchMustBeStopped()) {
            this.foreachImmediateMessage(folder, readonly, job);
        }
        if (!this.fetchMustBeStopped()) {
            this.foreachSubfolderMessage(folder, readonly, job);
        }
    }

    private final void foreachSubfolderMessage(Folder folder, boolean readonly, Function1<? super Message, Boolean> job) {
        block5: {
            try {
                if ((folder.getType() & 2) == 0) break block5;
                for (Folder childFolder : folder.list()) {
                    if (!this.fetchMustBeStopped()) {
                        Folder folder2 = childFolder;
                        Intrinsics.checkExpressionValueIsNotNull((Object)folder2, (String)"childFolder");
                        this.foreachMessage(folder2, readonly, job);
                        continue;
                    }
                    break;
                }
            }
            catch (MessagingException e) {
                Object[] objectArray = new Object[1];
                String string = folder.getFullName();
                if (string == null) {
                    string = "";
                }
                objectArray[0] = string;
                this.mailbox.updateStatusError(new LocalizationObject("EmailFetcher.Can_t_iterate_over_subfolders_of", objectArray), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void foreachImmediateMessage(Folder folder, boolean readonly, Function1<? super Message, Boolean> job) {
        block20: {
            v0 = folder.getFullName();
            if (v0 == null) {
                v0 = "";
            }
            folderName = v0;
            fetchedCount = 0;
            this.mailbox.updateStatus(new LocalizationObject("EmailFetcher.Processing_folder", new Object[]{folderName}), null);
            try {
                if ((folder.getType() & 1) == 0) break block20;
                this.openFolder(folder, readonly);
                for (Message message : messages = this.fetchMessages(folder)) {
                    if (this.fetchMustBeStopped() || !folder.isOpen() || !((Boolean)job.invoke((Object)message)).booleanValue()) continue;
                    ++fetchedCount;
                    var11_18 = this.fetched;
                    this.fetched = var11_18 + 1;
                }
            }
            catch (MessagingException e) {
                this.mailbox.updateStatusError(new LocalizationObject("EmailFetcher.Failed_to_process_folder", new Object[]{folderName}), (Throwable)e);
                if (folder.isOpen()) {
                    try {
                        folder.close(readonly == false);
                    }
                    catch (Exception e) {
                        EmailFetcher.Companion.getLogger().error(this.mailbox.getDebugString() + "Can't close folder");
                        EmailFetcher.Companion.getLogger().trace("", (Throwable)e);
                    }
                }
            }
            catch (Throwable e) {
                this.mailbox.updateStatusError(new LocalizationObject("EmailFetcher.Failed_to_process_mailbox_folder_{0}", new Object[]{e.getMessage()}), null);
                EmailFetcher.Companion.getLogger().error(this.mailbox.getDebugString() + "Failed to process folder " + folderName, e);
                {
                    catch (Throwable var6_12) {
                        if (folder.isOpen()) {
                            try {
                                folder.close(readonly == false);
                            }
                            catch (Exception e) {
                                EmailFetcher.Companion.getLogger().error(this.mailbox.getDebugString() + "Can't close folder");
                                EmailFetcher.Companion.getLogger().trace("", (Throwable)e);
                            }
                        }
                        throw var6_12;
                    }
                }
                if (folder.isOpen()) {
                    try {
                        folder.close(readonly == false);
                    }
                    catch (Exception e) {
                        EmailFetcher.Companion.getLogger().error(this.mailbox.getDebugString() + "Can't close folder");
                        EmailFetcher.Companion.getLogger().trace("", (Throwable)e);
                    }
                } else {
                    ** GOTO lbl62
                }
            }
        }
        if (folder.isOpen()) {
            try {
                folder.close(readonly == false);
            }
            catch (Exception e) {
                EmailFetcher.Companion.getLogger().error(this.mailbox.getDebugString() + "Can't close folder");
                EmailFetcher.Companion.getLogger().trace("", (Throwable)e);
            }
        }
        this.mailbox.updateStatus(new LocalizationObject("EmailFetcher.Processed", new Object[]{fetchedCount, folderName}), null);
    }

    private final Folder resolveFolder(String folderName) {
        String folderName2 = folderName;
        String string = folderName2;
        if (string == null) {
            string = "<default>";
        }
        String visibleName = string;
        this.mailbox.updateStatus(new LocalizationObject("EmailFetcher.Resolving_folder", new Object[]{visibleName}), null);
        Folder folder = null;
        try {
            if (folderName2 == null || folderName2.length() == 0) {
                folder = this.store.getDefaultFolder();
                if (folder == null) {
                    Companion.getLogger().error(this.mailbox.getDebugString() + "Failed to get default folder. Will try to get INBOX");
                    folderName2 = DEFAULT_FOLDER_NAME;
                    folder = this.store.getFolder(folderName2);
                }
            } else {
                folder = this.store.getFolder(folderName2);
            }
        }
        catch (MessagingException e) {
            this.mailbox.updateStatusError(this.getCantResolveFolderText(visibleName), (Throwable)e);
        }
        if (folder == null) {
            XdMailbox.updateStatusError$default(this.mailbox, this.getCantResolveFolderText(visibleName), null, 2, null);
        }
        return folder;
    }

    private final void openFolder(Folder folder, boolean readonly) throws MessagingException {
        if (readonly) {
            folder.open(1);
        } else {
            try {
                folder.open(2);
            }
            catch (MessagingException ex) {
                Companion.getLogger().error(this.mailbox.getDebugString() + "Error open on read-write access. Will try to open on readOnly", (Throwable)ex);
                folder.open(1);
            }
        }
    }

    private final Message[] fetchMessages(Folder folder) throws MessagingException {
        Message[] messages = folder.getMessages();
        FetchProfile profile = new FetchProfile();
        profile.add(FetchProfile.Item.ENVELOPE);
        profile.add("Message-ID");
        profile.add("In-Reply-To");
        profile.add("References");
        profile.add("Auto-Submitted");
        profile.add("X-Autoreply");
        profile.add("X-Autorespond");
        profile.add("X-Autogenerated");
        profile.add("X-FC-MachineGenerated");
        profile.add("X-POST-MessageClass");
        profile.add("Delivered-To");
        profile.add("Content-Type");
        profile.add("From");
        profile.add("Precedence");
        profile.add("X-Precedence");
        profile.add("Subject");
        folder.fetch(messages, profile);
        Intrinsics.checkExpressionValueIsNotNull((Object)messages, (String)"messages");
        return messages;
    }

    private final boolean fetchMustBeStopped() {
        return (Boolean)this.isCanceled.invoke() != false || this.fetched >= this.fetchLimit;
    }

    private final LocalizationObject getCantResolveFolderText(String visibleName) {
        return new LocalizationObject("EmailFetcher.Can_t_resolve_folder", new Object[]{visibleName});
    }

    @NotNull
    public final XdMailbox getMailbox() {
        return this.mailbox;
    }

    @NotNull
    public final Store getStore() {
        return this.store;
    }

    public final int getFetchLimit() {
        return this.fetchLimit;
    }

    @NotNull
    public final Function0<Boolean> isCanceled() {
        return this.isCanceled;
    }

    public EmailFetcher(@NotNull XdMailbox mailbox2, @NotNull Store store, int fetchLimit, @NotNull Function0<Boolean> isCanceled) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)mailbox2), (String)"mailbox");
        Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
        Intrinsics.checkParameterIsNotNull(isCanceled, (String)"isCanceled");
        this.mailbox = mailbox2;
        this.store = store;
        this.fetchLimit = fetchLimit;
        this.isCanceled = isCanceled;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/youtrack/mailbox/fetch/EmailFetcher$Companion;", "Lmu/KLogging;", "()V", "DEFAULT_FOLDER_NAME", "", "youtrack-mailbox"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

