/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.mailbox.fetch;

import java.util.concurrent.ConcurrentHashMap;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.api.webr.LocalScoped;
import jetbrains.youtrack.mailbox.persistence.XdMailbox;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@LocalScoped
@Component
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0005J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ljetbrains/youtrack/mailbox/fetch/MailboxLifecycle;", "", "()V", "mailboxes", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljetbrains/youtrack/mailbox/persistence/XdMailbox;", "Ljetbrains/youtrack/mailbox/fetch/MailboxLifecycle$State;", "cancel", "", "mailbox", "finish", "", "getStatus", "", "isCanceling", "isRunning", "startIfNotRunning", "State", "youtrack-mailbox"})
public final class MailboxLifecycle {
    private final ConcurrentHashMap<XdMailbox, State> mailboxes = new ConcurrentHashMap();

    public final boolean startIfNotRunning(@NotNull XdMailbox mailbox2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)mailbox2), (String)"mailbox");
        return this.mailboxes.putIfAbsent(mailbox2, State.FETCHING) == null;
    }

    public final boolean cancel(@NotNull XdMailbox mailbox2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)mailbox2), (String)"mailbox");
        return this.mailboxes.replace(mailbox2, State.FETCHING, State.CANCELING);
    }

    public final void finish(@NotNull XdMailbox mailbox2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)mailbox2), (String)"mailbox");
        this.mailboxes.remove((Object)mailbox2);
    }

    public final boolean isCanceling(@NotNull XdMailbox mailbox2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)mailbox2), (String)"mailbox");
        return this.mailboxes.get((Object)mailbox2) == State.CANCELING;
    }

    public final boolean isRunning(@NotNull XdMailbox mailbox2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)mailbox2), (String)"mailbox");
        return this.mailboxes.containsKey((Object)mailbox2);
    }

    @Nullable
    public final String getStatus(@NotNull XdMailbox mailbox2) {
        State state;
        Intrinsics.checkParameterIsNotNull((Object)((Object)mailbox2), (String)"mailbox");
        State state2 = state = this.mailboxes.get((Object)mailbox2);
        return state2 != null ? state2.getPresentation() : null;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Ljetbrains/youtrack/mailbox/fetch/MailboxLifecycle$State;", "", "localizationId", "", "(Ljava/lang/String;ILjava/lang/String;)V", "presentation", "getPresentation", "()Ljava/lang/String;", "FETCHING", "CANCELING", "youtrack-mailbox"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State FETCHING;
        public static final /* enum */ State CANCELING;
        private static final /* synthetic */ State[] $VALUES;
        private final String localizationId;

        static {
            State[] stateArray = new State[2];
            State[] stateArray2 = stateArray;
            stateArray[0] = FETCHING = new State("mailbox.fetching");
            stateArray[1] = CANCELING = new State("mailbox.canceling");
            $VALUES = stateArray;
        }

        @NotNull
        public final String getPresentation() {
            String string = BeansKt.getLocalizer().localizedMsg(this.localizationId, new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(this.localizationId)");
            return string;
        }

        private State(String localizationId) {
            this.localizationId = localizationId;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }
}

