/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.mailbox.plugin;

import jetbrains.youtrack.api.user.UserMergeHandler;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.mailbox.persistence.XdDefaultUserPolicy;
import jetbrains.youtrack.mailbox.persistence.XdMailboxRule;
import jetbrains.youtrack.mailbox.persistence.XdPredefinedUserPolicy;
import jetbrains.youtrack.persistent.XdDeletedUser;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.query.XdSearchingNode;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Ljetbrains/youtrack/mailbox/plugin/MailboxUserMergeHandler;", "Ljetbrains/youtrack/api/user/UserMergeHandler;", "()V", "priority", "", "getPriority", "()I", "reassignMailboxes", "", "from", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "to", "userDeleted", "deleted", "successor", "userMerged", "into", "youtrack-mailbox"})
public final class MailboxUserMergeHandler
implements UserMergeHandler {
    private final int priority = 10000;

    public int getPriority() {
        return this.priority;
    }

    public void userDeleted(@NotNull XdUser deleted, @NotNull XdUser successor) {
        Intrinsics.checkParameterIsNotNull((Object)deleted, (String)"deleted");
        Intrinsics.checkParameterIsNotNull((Object)successor, (String)"successor");
        this.reassignMailboxes(deleted, (XdUser)XdDeletedUser.Companion.get());
    }

    public void userMerged(@NotNull XdUser from, @NotNull XdUser into) {
        XdUser xdUser;
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)into, (String)"into");
        boolean bl = into.isGuest();
        if (bl) {
            xdUser = (XdUser)XdDeletedUser.Companion.get();
        } else if (!bl) {
            xdUser = into;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        XdUser successor = xdUser;
        this.reassignMailboxes(from, successor);
    }

    private final void reassignMailboxes(XdUser from, XdUser to) {
        XdEntity it;
        Iterable $this$forEach$iv = XdQueryKt.toList((XdQuery)XdFilteringQueryKt.filter((XdQuery)XdMailboxRule.Companion.all(), (Function2)((Function2)new Function2<FilteringContext, XdMailboxRule, XdSearchingNode>(from){
            final /* synthetic */ XdUser $from;

            @NotNull
            public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdMailboxRule it) {
                Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                return $this$filter.eq((XdEntity)it.getMaintainer(), (XdEntity)this.$from);
            }
            {
                this.$from = xdUser;
                super(2);
            }
        })));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (XdMailboxRule)((Object)element$iv);
            boolean bl = false;
            it.setMaintainer(to);
        }
        $this$forEach$iv = XdQueryKt.toList((XdQuery)XdFilteringQueryKt.filter((XdQuery)XdDefaultUserPolicy.Companion.all(), (Function2)((Function2)new Function2<FilteringContext, XdDefaultUserPolicy, XdSearchingNode>(from){
            final /* synthetic */ XdUser $from;

            @NotNull
            public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdDefaultUserPolicy it) {
                Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                return $this$filter.eq((XdEntity)it.getUser(), (XdEntity)this.$from);
            }
            {
                this.$from = xdUser;
                super(2);
            }
        })));
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (XdDefaultUserPolicy)((Object)element$iv);
            boolean bl = false;
            it.setUser(to);
        }
        $this$forEach$iv = XdQueryKt.toList((XdQuery)XdFilteringQueryKt.filter((XdQuery)XdPredefinedUserPolicy.Companion.all(), (Function2)((Function2)new Function2<FilteringContext, XdPredefinedUserPolicy, XdSearchingNode>(from){
            final /* synthetic */ XdUser $from;

            @NotNull
            public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdPredefinedUserPolicy it) {
                Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                return $this$filter.eq((XdEntity)it.getUser(), (XdEntity)this.$from);
            }
            {
                this.$from = xdUser;
                super(2);
            }
        })));
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (XdPredefinedUserPolicy)((Object)element$iv);
            boolean bl = false;
            it.setUser(to);
        }
    }
}

