/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.mailbox.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Message;
import javax.mail.internet.MimeMessage;
import jetbrains.charisma.workflow.exceptions.WorkflowException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.webr.userManagement.runtime.PrincipalManager;
import jetbrains.youtrack.api.commands.BeansKt;
import jetbrains.youtrack.api.commands.ICommandList;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.mailbox.fetch.AttachmentCollectorPartsVisitor;
import jetbrains.youtrack.mailbox.fetch.AttachmentCollectorPartsVisitorKt;
import jetbrains.youtrack.mailbox.fetch.DuplicateAttachmentsFilter;
import jetbrains.youtrack.mailbox.fetch.FetchedMessage;
import jetbrains.youtrack.mailbox.fetch.MailboxFetcher;
import jetbrains.youtrack.mailbox.persistence.XdMailboxRule;
import jetbrains.youtrack.mailbox.persistence.XdSeenMessage;
import jetbrains.youtrack.mailbox.persistence.XdSeenMessageStatus;
import jetbrains.youtrack.persistent.XdIssueAttachment;
import jetbrains.youtrack.persistent.XdIssueComment;
import jetbrains.youtrack.persistent.XdIssueExtKt;
import jetbrains.youtrack.persistent.attachment.IssueAttachementServiceKt;
import jetbrains.youtrack.persistent.tag.IssueTagServiceKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.query.XdSearchingNode;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J8\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ0\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u001d"}, d2={"Ljetbrains/youtrack/mailbox/service/MailboxContentFactory;", "", "()V", "addWatchers", "", "rule", "Ljetbrains/youtrack/mailbox/persistence/XdMailboxRule;", "message", "Ljetbrains/youtrack/mailbox/fetch/FetchedMessage;", "issue", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "applyCommand", "Ljetbrains/youtrack/api/commands/ICommandList;", "commandText", "", "createComment", "", "fetcher", "Ljetbrains/youtrack/mailbox/fetch/MailboxFetcher;", "author", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "password", "createIssue", "replaceAttachRefs", "text", "attachment", "Ljetbrains/youtrack/persistent/XdIssueAttachment;", "shouldNotifyAboutCommandFailure", "Companion", "youtrack-mailbox"})
public final class MailboxContentFactory {
    @NotNull
    public static final String FROM_VARIABLE = "${from}";
    @NotNull
    public static final String FROM_USERNAME_VARIABLE = "${from name}";
    @NotNull
    public static final String REPLY_TO_VARIABLE = "${reply-to}";
    @NotNull
    public static final String TO_VARIABLE = "${to}";
    @NotNull
    public static final String CC_VARIABLE = "${cc}";
    public static final Companion Companion = new Companion(null);

    public final boolean createIssue(@NotNull MailboxFetcher fetcher, @NotNull XdMailboxRule rule, @NotNull XdUser author, @Nullable String password2, @NotNull FetchedMessage message) {
        boolean bl;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)fetcher, (String)"fetcher");
        Intrinsics.checkParameterIsNotNull((Object)((Object)rule), (String)"rule");
        Intrinsics.checkParameterIsNotNull((Object)author, (String)"author");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        XdIssue issue = XdIssue.Companion.new$default((XdIssue.Companion)XdIssue.Companion, (XdUser)author, (XdProject)rule.getProject(), (boolean)false, null, (int)12, null);
        issue.setUsesMarkdown(false);
        if (rule.getOriginalTimestamps()) {
            long l = issue.getCreated();
            long l2 = message.getReceivedDate();
            object = issue;
            boolean bl2 = false;
            long l3 = Math.min(l, l2);
            object.setCreated(l3);
            l = issue.getCreated();
            l2 = message.getReceivedDate();
            object = issue;
            bl2 = false;
            l3 = Math.min(l, l2);
            object.setUpdated(l3);
        }
        issue.setSummary((bl = StringsKt.isBlank((CharSequence)message.getSubject())) ? jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("MailRule.Email_issue_from_{author_name}", new Object[]{author.getFullName()}) : message.getSubject());
        String string = message.getBody(rule.getPlainTextDescription());
        if (string == null) {
            string = "";
        }
        String wikiAdaptedTextBody = string;
        object = message;
        boolean bl3 = false;
        Set set = SetsKt.emptySet();
        AttachmentCollectorPartsVisitor attachmentsVisitor = ((FetchedMessage)object).getAttachments(set);
        for (XdIssueAttachment attachment2 : attachmentsVisitor.getAttachments()) {
            IssueAttachementServiceKt.addAttachment((XdIssue)issue, (XdIssueAttachment)attachment2);
            wikiAdaptedTextBody = this.replaceAttachRefs(wikiAdaptedTextBody, attachment2);
        }
        issue.setDescription(wikiAdaptedTextBody);
        XdIssue linkedIssue2 = (XdIssue)XdQueryKt.firstOrNull((XdQuery)XdQueryKt.exclude((XdQuery)XdFilteringQueryKt.filter((XdQuery)((XdQuery)rule.getProject().getIssues()), (Function2)((Function2)new Function2<FilteringContext, XdIssue, XdSearchingNode>(issue){
            final /* synthetic */ XdIssue $issue;

            @NotNull
            public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdIssue it) {
                Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return $this$filter.eq((Comparable)((Object)it.getSummary()), (Comparable)((Object)this.$issue.getSummary()));
            }
            {
                this.$issue = xdIssue;
                super(2);
            }
        })), (XdEntity)((XdEntity)issue)));
        if (linkedIssue2 != null) {
            ICommandList commandList = BeansKt.getCommandService().parse("relates to " + linkedIssue2.getIdReadable(), issue);
            if (commandList.hasErrors()) {
                Companion.getLogger().warn(rule.getDebugInfo(message) + " couldn't create link between " + issue.getIdReadable() + " and " + linkedIssue2.getIdReadable());
            } else {
                commandList.execute(false);
            }
        }
        boolean notifyAboutCommandFailure = this.shouldNotifyAboutCommandFailure(fetcher, message);
        CharSequence charSequence = rule.getNewIssueCommand();
        boolean bl4 = false;
        boolean bl5 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            ICommandList commandList;
            String string2 = rule.getNewIssueCommand();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            if ((commandList = this.applyCommand(string2, issue, message, rule)).hasErrors()) {
                LegacySupportKt.revert();
                Companion.getLogger().warn(rule.getDebugInfo(message) + " -X didn't create issue, command [" + rule.getNewIssueCommand() + "] was not applied to just created issue");
                if (notifyAboutCommandFailure) {
                    fetcher.commandFailed(message);
                    jetbrains.youtrack.mailbox.notifications.BeansKt.getMailboxNotificationService().notifyCantExecuteCommand(commandList, message, rule.getMaintainer());
                    LegacySupportKt.flush();
                }
                return false;
            }
        }
        this.addWatchers(rule, message, issue);
        fetcher.issueCreated(message, issue);
        try {
            LegacySupportKt.flush();
        }
        catch (WorkflowException e) {
            jetbrains.youtrack.mailbox.notifications.BeansKt.getMailboxNotificationService().notifyBadWorkflow(rule.getMaintainer(), (Exception)((Object)e));
            throw (Throwable)e;
        }
        Companion.getLogger().info(rule.getDebugInfo(message) + " -> created issue " + issue.getIdReadable());
        jetbrains.youtrack.mailbox.notifications.BeansKt.getMailboxNotificationService().notifyAboutIssue(issue.getEntity(), author, password2, rule.getMaintainer().getEntity(), message, wikiAdaptedTextBody);
        return true;
    }

    private final boolean shouldNotifyAboutCommandFailure(MailboxFetcher fetcher, FetchedMessage message) {
        XdSeenMessage xdSeenMessage = fetcher.findMessage(message.getId());
        return Intrinsics.areEqual((Object)((Object)(xdSeenMessage != null ? xdSeenMessage.getStatus() : null)), (Object)((Object)XdSeenMessageStatus.Companion.getCOMMAND_FAILED())) ^ true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean createComment(@NotNull MailboxFetcher fetcher, @NotNull XdMailboxRule rule, @NotNull XdUser author, @Nullable String password2, @NotNull XdIssue issue, @NotNull FetchedMessage message) {
        Collection<String> collection;
        Iterator<XdIssueAttachment> $this$mapTo$iv$iv222;
        void $this$map$iv;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)fetcher, (String)"fetcher");
        Intrinsics.checkParameterIsNotNull((Object)((Object)rule), (String)"rule");
        Intrinsics.checkParameterIsNotNull((Object)author, (String)"author");
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        StringBuilder builder = new StringBuilder();
        if (!StringsKt.isBlank((CharSequence)message.getSubject())) {
            String string2 = message.getSubject();
            String string3 = issue.getSummary();
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            if (!StringsKt.endsWith$default((String)string2, (String)string3, (boolean)false, (int)2, null)) {
                builder.append("==").append(message.getSubject()).append("==\n");
            }
        }
        if ((string = message.getStrippedTextBody(message.getFromEmails(rule.getTo()), rule.getPlainTextDescription())) == null) {
            string = "";
        }
        String wikiAdaptedTextBody = string;
        Iterable iterable = XdQueryKt.toList((XdQuery)((XdQuery)XdIssueExtKt.getAttachments((XdIssue)issue)));
        FetchedMessage fetchedMessage = message;
        boolean $i$f$map = false;
        void var12_14 = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv222.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            XdIssueAttachment xdIssueAttachment = (XdIssueAttachment)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string4 = it.getName();
            collection.add(string4);
        }
        collection = (List)destination$iv$iv;
        AttachmentCollectorPartsVisitor attachmentsVisitor = fetchedMessage.getAttachments(CollectionsKt.toSet((Iterable)collection));
        List<XdIssueAttachment> incomingAttachments = new DuplicateAttachmentsFilter(issue).filterOutDuplicates(attachmentsVisitor.getAttachments());
        for (XdIssueAttachment attach : incomingAttachments) {
            wikiAdaptedTextBody = this.replaceAttachRefs(wikiAdaptedTextBody, attach);
        }
        builder.append(wikiAdaptedTextBody);
        CharSequence attach = builder;
        boolean $this$mapTo$iv$iv222 = false;
        if (attach.length() > 0) {
            String string5 = builder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"builder.toString()");
            XdIssueComment comment = XdIssueComment.Companion.new$default((XdIssueComment.Companion)XdIssueComment.Companion, (String)string5, (XdIssue)issue, (XdUser)author, null, (int)8, null);
            comment.setUsesMarkdown(false);
            if (rule.getOriginalTimestamps()) {
                long $this$mapTo$iv$iv222 = message.getReceivedDate();
                long l = comment.getCreated();
                fetchedMessage = comment;
                boolean bl = false;
                long l2 = Math.min($this$mapTo$iv$iv222, l);
                fetchedMessage.setCreated(l2);
            }
            for (XdIssueAttachment attachment2 : incomingAttachments) {
                comment.addAttachment(attachment2);
            }
            boolean notifyAboutCommandFailure = this.shouldNotifyAboutCommandFailure(fetcher, message);
            destination$iv$iv = rule.getNewCommentCommand();
            boolean bl = false;
            boolean bl2 = false;
            if (!(destination$iv$iv == null || destination$iv$iv.length() == 0)) {
                ICommandList commandList;
                String string6 = rule.getNewCommentCommand();
                if (string6 == null) {
                    Intrinsics.throwNpe();
                }
                if ((commandList = this.applyCommand(string6, issue, message, rule)).hasErrors()) {
                    LegacySupportKt.revert();
                    Companion.getLogger().warn(rule.getDebugInfo(message) + " -X didn't create comment, command [" + rule.getNewCommentCommand() + "] was not applied to issue " + issue.getIdReadable());
                    if (notifyAboutCommandFailure) {
                        fetcher.commandFailed(message);
                        jetbrains.youtrack.mailbox.notifications.BeansKt.getMailboxNotificationService().notifyCantExecuteCommand(commandList, message, rule.getMaintainer());
                        LegacySupportKt.flush();
                    }
                    return false;
                }
            }
            this.addWatchers(rule, message, issue);
            fetcher.commentCreated(message, comment);
            try {
                LegacySupportKt.flush();
            }
            catch (WorkflowException e) {
                jetbrains.youtrack.mailbox.notifications.BeansKt.getMailboxNotificationService().notifyBadWorkflow(rule.getMaintainer(), (Exception)((Object)e));
                throw (Throwable)e;
            }
            Companion.getLogger().info(rule.getDebugInfo(message) + " -> created comment in issue " + issue.getIdReadable());
            if (rule.getOriginalTimestamps()) {
                issue.setUpdated(message.getReceivedDate());
                LegacySupportKt.flush();
            }
            jetbrains.youtrack.mailbox.notifications.BeansKt.getMailboxNotificationService().notifyAboutComment(comment.getEntity(), author, password2, rule.getMaintainer().getEntity(), message, wikiAdaptedTextBody);
            return true;
        }
        LegacySupportKt.revert();
        rule.invalidEmailFormat(fetcher, message, null);
        return false;
    }

    private final String replaceAttachRefs(String text, XdIssueAttachment attachment2) {
        String result = text;
        String fileName = attachment2.getName();
        if (StringsKt.indexOf$default((CharSequence)fileName, (String)"\\E", (int)0, (boolean)false, (int)6, null) < 0 && attachment2.isImage()) {
            Pattern pattern = null;
            Matcher matcher = null;
            String contentId = AttachmentCollectorPartsVisitorKt.getContentId(attachment2);
            if (contentId != null) {
                CharSequence charSequence = contentId;
                boolean bl = false;
                if (charSequence.length() > 0) {
                    Pattern pattern2 = Pattern.compile("\\[?cid:\\Q" + contentId + "\\E\\]?", 2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)pattern2, (String)"Pattern.compile(\"\\\\[?cid\u2026Pattern.CASE_INSENSITIVE)");
                    pattern = pattern2;
                    Matcher matcher2 = pattern.matcher(result);
                    Intrinsics.checkExpressionValueIsNotNull((Object)matcher2, (String)"pattern.matcher(result)");
                    matcher = matcher2;
                    String string = Matcher.quoteReplacement(fileName);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Matcher.quoteReplacement(fileName)");
                    fileName = string;
                    String string2 = matcher.replaceAll('!' + fileName + '!');
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"matcher.replaceAll(\"!$fileName!\")");
                    result = string2;
                }
            }
            Pattern pattern3 = Pattern.compile("\\[image:\\s*\\Q" + fileName + "\\E\\]", 2);
            Intrinsics.checkExpressionValueIsNotNull((Object)pattern3, (String)"Pattern.compile(\"\\\\[imag\u2026Pattern.CASE_INSENSITIVE)");
            pattern = pattern3;
            Matcher matcher3 = pattern.matcher(result);
            Intrinsics.checkExpressionValueIsNotNull((Object)matcher3, (String)"pattern.matcher(result)");
            matcher = matcher3;
            if (!matcher.matches()) {
                Pattern pattern4 = Pattern.compile("\\[image:\\s*\\Q" + AttachmentCollectorPartsVisitorKt.getOriginalName(attachment2) + "\\E\\]", 2);
                Intrinsics.checkExpressionValueIsNotNull((Object)pattern4, (String)"Pattern.compile(\"\\\\[imag\u2026Pattern.CASE_INSENSITIVE)");
                pattern = pattern4;
                Matcher matcher4 = pattern.matcher(result);
                Intrinsics.checkExpressionValueIsNotNull((Object)matcher4, (String)"pattern.matcher(result)");
                matcher = matcher4;
            }
            String string = matcher.replaceFirst('!' + Matcher.quoteReplacement(fileName) + '!');
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"matcher.replaceFirst(\"!$\u2026Replacement(fileName)}!\")");
            result = string;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ICommandList applyCommand(String commandText, XdIssue issue, FetchedMessage message, XdMailboxRule rule) {
        String string = StringsKt.replace$default((String)commandText, (String)FROM_VARIABLE, (String)StringsKt.replace$default((String)message.getFromEmail(), (String)"\"", (String)"\\\"", (boolean)false, (int)4, null), (boolean)false, (int)4, null);
        String string2 = message.getFromName();
        if (string2 == null) {
            string2 = message.getFromEmail();
        }
        String string3 = StringsKt.replace$default((String)string, (String)FROM_USERNAME_VARIABLE, (String)StringsKt.replace$default((String)string2, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null), (boolean)false, (int)4, null);
        String string4 = message.getReplyTo();
        if (string4 == null || (string4 = StringsKt.replace$default((String)string4, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null)) == null) {
            string4 = "";
        }
        String string5 = StringsKt.replace$default((String)string3, (String)REPLY_TO_VARIABLE, (String)string4, (boolean)false, (int)4, null);
        Message.RecipientType recipientType = MimeMessage.RecipientType.TO;
        Intrinsics.checkExpressionValueIsNotNull((Object)recipientType, (String)"MimeMessage.RecipientType.TO");
        String string6 = StringsKt.replace$default((String)string5, (String)TO_VARIABLE, (String)StringsKt.replace$default((String)message.getRecipients(recipientType), (String)"\"", (String)"\\\"", (boolean)false, (int)4, null), (boolean)false, (int)4, null);
        Message.RecipientType recipientType2 = MimeMessage.RecipientType.CC;
        Intrinsics.checkExpressionValueIsNotNull((Object)recipientType2, (String)"MimeMessage.RecipientType.CC");
        String command = StringsKt.replace$default((String)string6, (String)CC_VARIABLE, (String)StringsKt.replace$default((String)message.getRecipients(recipientType2), (String)"\"", (String)"\\\"", (boolean)false, (int)4, null), (boolean)false, (int)4, null);
        XdUser user$iv = rule.getMaintainer();
        boolean $i$f$runAs = false;
        Entity user$iv$iv = user$iv.getEntity();
        boolean $i$f$runAs2 = false;
        PrincipalManager _principalManager$iv$iv = jetbrains.youtrack.core.security.BeansKt.getPrincipalManager();
        try {
            _principalManager$iv$iv.setTemporaryServerPrincipal((Object)user$iv$iv);
            boolean bl = false;
            ICommandList commandList = BeansKt.getCommandService().parse(command, issue);
            commandList.execute(false);
            ICommandList iCommandList = commandList;
            return iCommandList;
        }
        finally {
            _principalManager$iv$iv.unsetTemporaryServerPrincipal();
        }
    }

    private final void addWatchers(XdMailboxRule rule, FetchedMessage message, XdIssue issue) {
        if (rule.getStarRecipients()) {
            for (String recipient : message.getRecipients()) {
                if ((XdUser)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdQuery)XdUser.Companion.all(), (Function2)((Function2)new Function2<FilteringContext, XdUser, XdSearchingNode>(recipient){
                    final /* synthetic */ String $recipient;

                    @NotNull
                    public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdUser it) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return $this$filter.eq((Comparable)((Object)it.getEmail()), (Comparable)((Object)this.$recipient));
                    }
                    {
                        this.$recipient = string;
                        super(2);
                    }
                }))) != null) {
                    XdUser xdUser;
                    boolean bl = false;
                    boolean bl2 = false;
                    XdUser user2 = xdUser;
                    boolean bl3 = false;
                    IssueTagServiceKt.watch((XdIssue)issue, (XdUser)user2);
                }
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/mailbox/service/MailboxContentFactory$Companion;", "Lmu/KLogging;", "()V", "CC_VARIABLE", "", "FROM_USERNAME_VARIABLE", "FROM_VARIABLE", "REPLY_TO_VARIABLE", "TO_VARIABLE", "youtrack-mailbox"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

