/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.mailbox.service;

import java.util.Collection;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.Store;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.mps.internationalization.runtime.LocalizationObject;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.core.scheduling.SchedulingOptions;
import jetbrains.youtrack.mailbox.BeansKt;
import jetbrains.youtrack.mailbox.MailboxConnectionKt;
import jetbrains.youtrack.mailbox.fetch.EmailFetcher;
import jetbrains.youtrack.mailbox.fetch.MailboxLifecycleKt;
import jetbrains.youtrack.mailbox.persistence.XdMailbox;
import jetbrains.youtrack.mailbox.persistence.XdMailboxRule;
import jetbrains.youtrack.mailbox.service.MailboxFetchService;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.BeanCreationNotAllowedException;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR#\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Ljetbrains/youtrack/mailbox/service/MailboxFetchService;", "", "()V", "maxFetchedCount", "", "kotlin.jvm.PlatformType", "getMaxFetchedCount", "()Ljava/lang/Integer;", "maxFetchedCount$delegate", "Lkotlin/Lazy;", "process", "", "mailbox", "Ljetbrains/youtrack/mailbox/persistence/XdMailbox;", "maxFetchCount", "processAsync", "Companion", "youtrack-mailbox"})
public final class MailboxFetchService {
    private final Lazy maxFetchedCount$delegate = LazyKt.lazy((Function0)maxFetchedCount.2.INSTANCE);
    public static final Companion Companion = new Companion(null);

    private final Integer getMaxFetchedCount() {
        Lazy lazy = this.maxFetchedCount$delegate;
        MailboxFetchService mailboxFetchService = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Integer)lazy.getValue();
    }

    public final void processAsync(@NotNull XdMailbox mailbox2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)mailbox2), (String)"mailbox");
        jetbrains.charisma.persistent.BeansKt.getQuartzThreadExecutor().execute(new Runnable(this, mailbox2){
            final /* synthetic */ MailboxFetchService this$0;
            final /* synthetic */ XdMailbox $mailbox;

            public final void run() {
                try {
                    this.this$0.process(this.$mailbox);
                }
                catch (Throwable e) {
                    this.$mailbox.updateStatus(new LocalizationObject("Mailbox.Failed_to_fetch", new Object[0]), e);
                }
            }
            {
                this.this$0 = mailboxFetchService;
                this.$mailbox = xdMailbox;
            }
        });
    }

    public final void process(@NotNull XdMailbox mailbox2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)mailbox2), (String)"mailbox");
        try {
            Integer n = this.getMaxFetchedCount();
            Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"maxFetchedCount");
            this.process(n, mailbox2);
        }
        catch (BeanCreationNotAllowedException _) {
            XdMailbox.updateStatus$default(mailbox2, new LocalizationObject("Mailbox.Failed_to_fetch", new Object[0]), null, 2, null);
            Companion.getLogger().error((Function0)new Function0<String>(mailbox2){
                final /* synthetic */ XdMailbox $mailbox;

                @NotNull
                public final String invoke() {
                    return "Error while processing mailbox [" + this.$mailbox.getUrl() + "]. YouTrack has been shut down";
                }
                {
                    this.$mailbox = xdMailbox;
                    super(0);
                }
            });
        }
        catch (Throwable e) {
            mailbox2.updateStatus(new LocalizationObject("Mailbox.Failed_to_fetch", new Object[0]), e);
        }
    }

    public final void process(int maxFetchCount, @NotNull XdMailbox mailbox2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)mailbox2), (String)"mailbox");
        MailboxLifecycleKt.fetchLock(mailbox2, (Function0<Unit>)((Function0)new Function0<Unit>(mailbox2, maxFetchCount){
            final /* synthetic */ XdMailbox $mailbox;
            final /* synthetic */ int $maxFetchCount;

            public final void invoke() {
                LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, Unit>(this){
                    final /* synthetic */ process.2 this$0;

                    public final void invoke(@NotNull TransientStoreSession it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        List<XdMailboxRule> activeRules = this.this$0.$mailbox.getActiveRules();
                        Collection collection = activeRules;
                        boolean bl = false;
                        if (!collection.isEmpty()) {
                            this.this$0.$mailbox.setLastFetchStart(System.currentTimeMillis());
                            XdMailbox.updateStatus$default(this.this$0.$mailbox, new LocalizationObject("Mailbox.Start_mail_fetching", new Object[0]), null, 2, null);
                            this.this$0.$mailbox.setStatusError("");
                            try {
                                Function0 isCanceling2 = (Function0)new Function0<Boolean>(this){
                                    final /* synthetic */ process.1 this$0;

                                    public final boolean invoke() {
                                        return jetbrains.youtrack.mailbox.fetch.BeansKt.getMailboxLifecycle().isCanceling(this.this$0.this$0.$mailbox) || SchedulingOptions.isCronJobTooLong((Long)this.this$0.this$0.$mailbox.getLastFetchStart());
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        super(0);
                                    }
                                };
                                MailboxConnectionKt.openStore(this.this$0.$mailbox, (Function1<? super Store, Unit>)((Function1)new Function1<Store, Unit>(this, isCanceling2){
                                    final /* synthetic */ process.1 this$0;
                                    final /* synthetic */ Function0 $isCanceling;

                                    public final void invoke(@NotNull Store store) {
                                        Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
                                        BeansKt.getConnectionFailureTracker().connectionSuccessful(this.this$0.this$0.$mailbox);
                                        EmailFetcher folderFetcher = new EmailFetcher(this.this$0.this$0.$mailbox, store, this.this$0.this$0.$maxFetchCount, (Function0<Boolean>)this.$isCanceling);
                                        for (XdMailboxRule mapping : this.this$0.this$0.$mailbox.getActiveRules()) {
                                            if (((Boolean)this.$isCanceling.invoke()).booleanValue()) continue;
                                            mapping.process(folderFetcher);
                                        }
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        this.$isCanceling = function0;
                                        super(1);
                                    }
                                }));
                                XdMailbox.updateStatus$default(this.this$0.$mailbox, (Boolean)isCanceling2.invoke() != false ? new LocalizationObject("Mailbox.Mail_fetching_canceled", new Object[0]) : new LocalizationObject("Mailbox.Finished_mail_fetching", new Object[0]), null, 2, null);
                            }
                            catch (MessagingException e) {
                                this.this$0.$mailbox.updateStatus(new LocalizationObject("Mailbox.Failed_to_fetch", new Object[0]), e);
                                XdMailbox.updateStatusError$default(this.this$0.$mailbox, ((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getMessage(), null, 2, null);
                                BeansKt.getConnectionFailureTracker().connectionFailed(this.this$0.$mailbox, (Exception)((Object)e));
                            }
                            this.this$0.$mailbox.setLastFetchFinish(System.currentTimeMillis());
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
            }
            {
                this.$mailbox = xdMailbox;
                this.$maxFetchCount = n;
                super(0);
            }
        }));
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/mailbox/service/MailboxFetchService$Companion;", "Lmu/KLogging;", "()V", "youtrack-mailbox"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

