/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.mailbox.service;

import com.sun.mail.pop3.StoreTerminatorKt;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import javax.annotation.PostConstruct;
import javax.mail.Store;
import javax.mail.event.ConnectionAdapter;
import javax.mail.event.ConnectionEvent;
import javax.mail.event.ConnectionListener;
import javax.servlet.ServletContext;
import jetbrains.youtrack.api.webr.LocalScoped;
import jetbrains.youtrack.mailbox.fetch.MailboxLifecycle;
import jetbrains.youtrack.mailbox.persistence.XdMailbox;
import jetbrains.youtrack.mailbox.service.MailboxWatchDog;
import jetbrains.youtrack.mailbox.service.MailboxWatchDog$sam$java_lang_Runnable$0;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import mu.KLogging;
import org.apache.log4j.MDC;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import webr.framework.controller.BeanContainer;
import webr.framework.controller.WebLocalScope;

@Component
@LocalScoped
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0017J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u0016\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000f8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ljetbrains/youtrack/mailbox/service/MailboxWatchDog;", "", "()V", "data", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljavax/mail/Store;", "Ljetbrains/youtrack/mailbox/service/MailboxWatchDog$WatchdogContext;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "hangedConnectionTimeout", "", "getHangedConnectionTimeout", "()J", "mailboxLifecycle", "Ljetbrains/youtrack/mailbox/fetch/MailboxLifecycle;", "checkStoresToClose", "", "init", "terminate", "store", "unwatch", "watchFor", "mailbox", "Ljetbrains/youtrack/mailbox/persistence/XdMailbox;", "Companion", "WatchdogContext", "youtrack-mailbox"})
public class MailboxWatchDog {
    private final ConcurrentHashMap<Store, WatchdogContext> data = new ConcurrentHashMap();
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    @Autowired
    private MailboxLifecycle mailboxLifecycle;
    @NotNull
    public static final String HANGED_CONNECTION_TIMEOUT = "jetbrains.youtrack.mailbox.watchdog.timeout";
    public static final long WATCHDOG_CHECK_INTERVAL = 10L;
    public static final Companion Companion = new Companion(null);

    private final long getHangedConnectionTimeout() {
        long l;
        String string = System.getProperty(HANGED_CONNECTION_TIMEOUT);
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            l = Long.parseLong(string2);
        } else {
            l = TimeUnit.MINUTES.toMillis(10L);
        }
        return l;
    }

    @PostConstruct
    public void init() {
        Function0 function0 = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                MailboxWatchDog.access$checkStoresToClose((MailboxWatchDog)this.receiver);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(MailboxWatchDog.class);
            }

            public final String getName() {
                return "checkStoresToClose";
            }

            public final String getSignature() {
                return "checkStoresToClose()V";
            }
        };
        this.executor.scheduleWithFixedDelay(new MailboxWatchDog$sam$java_lang_Runnable$0(function0), 10L, 10L, TimeUnit.MINUTES);
    }

    public final void watchFor(@NotNull Store store, @NotNull XdMailbox mailbox2) {
        Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
        Intrinsics.checkParameterIsNotNull((Object)((Object)mailbox2), (String)"mailbox");
        BeanContainer beanContainer = WebLocalScope.getContainer();
        Intrinsics.checkExpressionValueIsNotNull((Object)beanContainer, (String)"WebLocalScope.getContainer()");
        ServletContext servletContext = beanContainer.getContext();
        Map map = this.data;
        long l = System.currentTimeMillis();
        ServletContext servletContext2 = servletContext;
        Intrinsics.checkExpressionValueIsNotNull((Object)servletContext2, (String)"servletContext");
        map.put(store, new WatchdogContext(l, mailbox2, servletContext2));
        store.addConnectionListener((ConnectionListener)new ConnectionAdapter(this){
            final /* synthetic */ MailboxWatchDog this$0;

            public void closed(@NotNull ConnectionEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                try {
                    Object object = e.getSource();
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type javax.mail.Store");
                    }
                    MailboxWatchDog.access$unwatch(this.this$0, (Store)object);
                }
                catch (Throwable e2) {
                    MailboxWatchDog.Companion.getLogger().error("Exception in store connection listener", e2);
                }
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final void unwatch(Store store) {
        this.data.remove(store);
    }

    private final void checkStoresToClose() {
        long time = System.currentTimeMillis();
        this.data.forEach(new BiConsumer<Store, WatchdogContext>(this, time){
            final /* synthetic */ MailboxWatchDog this$0;
            final /* synthetic */ long $time;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void accept(@NotNull Store store, @NotNull WatchdogContext entry) {
                Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
                Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
                long startTime = entry.getStartTime();
                try {
                    MDC.put((String)WebLocalScope.MDC_SERVLET_CONTEXT_KEY, (Object)entry.getContext());
                    MDC.put((String)"domain", (String)entry.getContext().getInitParameter("domain"));
                    if (MailboxWatchDog.access$getMailboxLifecycle$p(this.this$0).isCanceling(entry.getMailbox())) {
                        MailboxWatchDog.access$terminate(this.this$0, store);
                    }
                    if (this.$time - startTime > MailboxWatchDog.access$getHangedConnectionTimeout$p(this.this$0)) {
                        MailboxWatchDog.Companion.getLogger().warn("Found hanged mailbox store with start time : " + new Date(startTime));
                        MailboxWatchDog.access$terminate(this.this$0, store);
                    }
                }
                finally {
                    MDC.remove((String)WebLocalScope.MDC_SERVLET_CONTEXT_KEY);
                    MDC.remove((String)"domain");
                }
            }
            {
                this.this$0 = mailboxWatchDog;
                this.$time = l;
            }
        });
    }

    private final void terminate(Store store) {
        try {
            this.data.remove(store);
            StoreTerminatorKt.close(store);
            Companion.getLogger().warn((Function0)terminate.1.INSTANCE);
        }
        catch (Throwable e) {
            Companion.getLogger().warn(e, (Function0)terminate.2.INSTANCE);
        }
    }

    public static final /* synthetic */ void access$checkStoresToClose(MailboxWatchDog $this) {
        $this.checkStoresToClose();
    }

    public static final /* synthetic */ void access$unwatch(MailboxWatchDog $this, Store store) {
        $this.unwatch(store);
    }

    public static final /* synthetic */ MailboxLifecycle access$getMailboxLifecycle$p(MailboxWatchDog $this) {
        MailboxLifecycle mailboxLifecycle = $this.mailboxLifecycle;
        if (mailboxLifecycle == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mailboxLifecycle");
        }
        return mailboxLifecycle;
    }

    public static final /* synthetic */ void access$setMailboxLifecycle$p(MailboxWatchDog $this, MailboxLifecycle mailboxLifecycle) {
        $this.mailboxLifecycle = mailboxLifecycle;
    }

    public static final /* synthetic */ void access$terminate(MailboxWatchDog $this, Store store) {
        $this.terminate(store);
    }

    public static final /* synthetic */ long access$getHangedConnectionTimeout$p(MailboxWatchDog $this) {
        return $this.getHangedConnectionTimeout();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Ljetbrains/youtrack/mailbox/service/MailboxWatchDog$WatchdogContext;", "", "startTime", "", "mailbox", "Ljetbrains/youtrack/mailbox/persistence/XdMailbox;", "context", "Ljavax/servlet/ServletContext;", "(JLjetbrains/youtrack/mailbox/persistence/XdMailbox;Ljavax/servlet/ServletContext;)V", "getContext", "()Ljavax/servlet/ServletContext;", "getMailbox", "()Ljetbrains/youtrack/mailbox/persistence/XdMailbox;", "getStartTime", "()J", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "youtrack-mailbox"})
    public static final class WatchdogContext {
        private final long startTime;
        @NotNull
        private final XdMailbox mailbox;
        @NotNull
        private final ServletContext context;

        public final long getStartTime() {
            return this.startTime;
        }

        @NotNull
        public final XdMailbox getMailbox() {
            return this.mailbox;
        }

        @NotNull
        public final ServletContext getContext() {
            return this.context;
        }

        public WatchdogContext(long startTime, @NotNull XdMailbox mailbox2, @NotNull ServletContext context) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)mailbox2), (String)"mailbox");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.startTime = startTime;
            this.mailbox = mailbox2;
            this.context = context;
        }

        public final long component1() {
            return this.startTime;
        }

        @NotNull
        public final XdMailbox component2() {
            return this.mailbox;
        }

        @NotNull
        public final ServletContext component3() {
            return this.context;
        }

        @NotNull
        public final WatchdogContext copy(long startTime, @NotNull XdMailbox mailbox2, @NotNull ServletContext context) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)mailbox2), (String)"mailbox");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            return new WatchdogContext(startTime, mailbox2, context);
        }

        public static /* synthetic */ WatchdogContext copy$default(WatchdogContext watchdogContext, long l, XdMailbox xdMailbox, ServletContext servletContext, int n, Object object) {
            if ((n & 1) != 0) {
                l = watchdogContext.startTime;
            }
            if ((n & 2) != 0) {
                xdMailbox = watchdogContext.mailbox;
            }
            if ((n & 4) != 0) {
                servletContext = watchdogContext.context;
            }
            return watchdogContext.copy(l, xdMailbox, servletContext);
        }

        @NotNull
        public String toString() {
            return "WatchdogContext(startTime=" + this.startTime + ", mailbox=" + (Object)((Object)this.mailbox) + ", context=" + this.context + ")";
        }

        public int hashCode() {
            XdMailbox xdMailbox = this.mailbox;
            ServletContext servletContext = this.context;
            return (Long.hashCode(this.startTime) * 31 + (xdMailbox != null ? ((Object)((Object)xdMailbox)).hashCode() : 0)) * 31 + (servletContext != null ? servletContext.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof WatchdogContext)) break block3;
                    WatchdogContext watchdogContext = (WatchdogContext)object;
                    if (this.startTime != watchdogContext.startTime || !Intrinsics.areEqual((Object)((Object)this.mailbox), (Object)((Object)watchdogContext.mailbox)) || !Intrinsics.areEqual((Object)this.context, (Object)watchdogContext.context)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ljetbrains/youtrack/mailbox/service/MailboxWatchDog$Companion;", "Lmu/KLogging;", "()V", "HANGED_CONNECTION_TIMEOUT", "", "WATCHDOG_CHECK_INTERVAL", "", "youtrack-mailbox"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

