/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.maintenance.backup;

import java.io.File;
import jetbrains.exodus.backup.BackupBean;
import jetbrains.exodus.backup.Backupable;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.util.CompressBackupUtil;
import jetbrains.mps.internationalization.runtime.Localization;
import jetbrains.mps.internationalization.runtime.LocalizationObject;
import jetbrains.mps.webr.runtime.templateComponent.LocalizedLogicException;
import jetbrains.youtrack.api.webr.LocalScoped;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.maintenance.BeansKt;
import jetbrains.youtrack.maintenance.backup.AsyncBackupBean;
import jetbrains.youtrack.maintenance.backup.listeners.XdDatabaseBackupConfig;
import jetbrains.youtrack.maintenance.backup.listeners.XdDatabaseBackupError;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@LocalScoped
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eR\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Ljetbrains/youtrack/maintenance/backup/AsyncBackupBean;", "", "()V", "backupBean", "Ljetbrains/exodus/backup/BackupBean;", "getBackupBean", "()Ljetbrains/exodus/backup/BackupBean;", "setBackupBean", "(Ljetbrains/exodus/backup/BackupBean;)V", "backupInProgress", "", "getBackupInProgress", "()Z", "asyncBackup", "", "Companion", "youtrack-maintenance"})
public final class AsyncBackupBean {
    @Autowired
    @NotNull
    public BackupBean backupBean;
    private static final String JOB_NAME = "Database backup";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final BackupBean getBackupBean() {
        BackupBean backupBean2 = this.backupBean;
        if (backupBean2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"backupBean");
        }
        return backupBean2;
    }

    public final void setBackupBean(@NotNull BackupBean backupBean2) {
        Intrinsics.checkParameterIsNotNull((Object)backupBean2, (String)"<set-?>");
        this.backupBean = backupBean2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getBackupInProgress() {
        if (jetbrains.charisma.persistence.customfields.BeansKt.getUserActionJobContainer().hasGlobalJob(JOB_NAME)) return true;
        BackupBean backupBean2 = this.backupBean;
        if (backupBean2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"backupBean");
        }
        if (!backupBean2.isBackupInProgress()) return false;
        return true;
    }

    public final synchronized void asyncBackup() {
        if (this.getBackupInProgress()) {
            throw (Throwable)new LocalizedLogicException((Localization)new LocalizationObject("AsyncBackupBean._Backup_is_already_in_progress", new Object[0]));
        }
        BackupBean backupBean2 = this.backupBean;
        if (backupBean2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"backupBean");
        }
        backupBean2.setBackupStartTicks(System.currentTimeMillis());
        jetbrains.charisma.persistence.customfields.BeansKt.getUserActionJobContainer().getOrCreateJob(new Runnable(this){
            final /* synthetic */ AsyncBackupBean this$0;

            public final void run() {
                LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, File>(this){
                    final /* synthetic */ asyncBackup.1 this$0;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @NotNull
                    public final File invoke(@NotNull TransientStoreSession it) {
                        File file;
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        File backupFile = BeansKt.getBackupFolder().getNextBackupFile();
                        try {
                            file = CompressBackupUtil.backup((Backupable)((Backupable)this.this$0.this$0.getBackupBean()), (File)backupFile, (boolean)this.this$0.this$0.getBackupBean().getBackupToZip());
                        }
                        catch (Throwable e) {
                            ((XdDatabaseBackupConfig)XdDatabaseBackupConfig.Companion.get()).getErrors().add((XdEntity)XdDatabaseBackupError.Companion.new$default(XdDatabaseBackupError.Companion, backupFile, e, null, 4, null));
                            LegacySupportKt.flush();
                            throw e;
                        }
                        finally {
                            this.this$0.this$0.getBackupBean().setBackupStartTicks(0L);
                        }
                        return file;
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = asyncBackupBean;
            }
        }, JOB_NAME, new Entity[0]);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/youtrack/maintenance/backup/AsyncBackupBean$Companion;", "Lmu/KLogging;", "()V", "JOB_NAME", "", "youtrack-maintenance"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

