/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.maintenance.backup;

import java.io.Closeable;
import java.io.File;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jetbrains.exodus.backup.Backupable;
import jetbrains.exodus.crypto.StreamCipherProvider;
import jetbrains.exodus.crypto.convert.ArchiveBackupableFactory;
import jetbrains.exodus.crypto.convert.EncryptListener;
import jetbrains.exodus.crypto.convert.ScytaleEngine;
import jetbrains.exodus.crypto.convert.UtilKt;
import jetbrains.mps.webr.runtime.templateComponent.LogicException;
import jetbrains.youtrack.config.BeansKt;
import jetbrains.youtrack.maintenance.backup.HttpServletResponseEncryptListenerFactory;
import jetbrains.youtrack.maintenance.backup.listeners.CloseableEncryptListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service(value="asyncEncryptedBackup")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013R\u001b\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Ljetbrains/youtrack/maintenance/backup/AsyncEncryptedBackup;", "", "()V", "backupTimeout", "", "kotlin.jvm.PlatformType", "getBackupTimeout", "()Ljava/lang/Long;", "Ljava/lang/Long;", "writeBackup", "", "request", "Ljavax/servlet/http/HttpServletRequest;", "response", "Ljavax/servlet/http/HttpServletResponse;", "key", "", "basicIV", "file", "Ljava/io/File;", "youtrack-maintenance"})
public final class AsyncEncryptedBackup {
    private final Long backupTimeout = Long.getLong("jetbrains.youtrack.maintenance.backup.timeout", 600000L);

    public final Long getBackupTimeout() {
        return this.backupTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeBackup(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull byte[] key, long basicIV, @NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        StreamCipherProvider streamCipherProvider = BeansKt.getPersistentDataEnvironment().getCipherProvider();
        if (streamCipherProvider == null) {
            throw (Throwable)new LogicException("No cipher provider found");
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)streamCipherProvider, (String)"persistentDataEnvironmen\u2026o cipher provider found\")");
        StreamCipherProvider cipherProvider = streamCipherProvider;
        AsyncContext asyncContext = request.startAsync();
        Intrinsics.checkExpressionValueIsNotNull((Object)asyncContext, (String)"request.startAsync()");
        Long l = this.backupTimeout;
        Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"backupTimeout");
        asyncContext.setTimeout(l.longValue());
        Backupable input = ArchiveBackupableFactory.INSTANCE.newBackupable(file, true);
        Closeable closeable = HttpServletResponseEncryptListenerFactory.INSTANCE.newListener(response, true);
        boolean bl = false;
        Throwable throwable = null;
        try {
            CloseableEncryptListener output = (CloseableEncryptListener)closeable;
            boolean bl2 = false;
            UtilKt.encryptBackupable((ScytaleEngine)new ScytaleEngine((EncryptListener)output, cipherProvider, key, basicIV, 0, 0, 0, 0, 240, null), (Backupable)input);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

