/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.maintenance.backup;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.env.Environment;
import jetbrains.mps.webr.runtime.requestProcessor.ResponseFactory;
import jetbrains.mps.webr.runtime.templateComponent.ActionController;
import jetbrains.mps.webr.runtime.templateComponent.ActionFactory;
import jetbrains.mps.webr.runtime.templateComponent.IdParameter;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.maintenance.BeansKt;
import jetbrains.youtrack.maintenance.Localization;
import jetbrains.youtrack.maintenance.backup.AsyncEncryptedBackup;
import jetbrains.youtrack.maintenance.backup.BackupFileDispatchAction;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import webr.framework.controller.BaseApplication;
import webr.framework.runtime.response.ResponseAction;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Ljetbrains/youtrack/maintenance/backup/BackupFileDispatchAction;", "Ljetbrains/mps/webr/runtime/templateComponent/ActionFactory;", "()V", "asyncEncryptedBackup", "Ljetbrains/youtrack/maintenance/backup/AsyncEncryptedBackup;", "getAsyncEncryptedBackup", "()Ljetbrains/youtrack/maintenance/backup/AsyncEncryptedBackup;", "setAsyncEncryptedBackup", "(Ljetbrains/youtrack/maintenance/backup/AsyncEncryptedBackup;)V", "createAction", "Ljetbrains/mps/webr/runtime/templateComponent/ActionController;", "idParameter", "", "windowId", "Action", "youtrack-maintenance"})
public class BackupFileDispatchAction
extends ActionFactory {
    @Autowired
    @NotNull
    public AsyncEncryptedBackup asyncEncryptedBackup;

    @NotNull
    public final AsyncEncryptedBackup getAsyncEncryptedBackup() {
        AsyncEncryptedBackup asyncEncryptedBackup = this.asyncEncryptedBackup;
        if (asyncEncryptedBackup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"asyncEncryptedBackup");
        }
        return asyncEncryptedBackup;
    }

    public final void setAsyncEncryptedBackup(@NotNull AsyncEncryptedBackup asyncEncryptedBackup) {
        Intrinsics.checkParameterIsNotNull((Object)asyncEncryptedBackup, (String)"<set-?>");
        this.asyncEncryptedBackup = asyncEncryptedBackup;
    }

    @NotNull
    public ActionController createAction(@NotNull String idParameter, @NotNull String windowId) {
        Intrinsics.checkParameterIsNotNull((Object)idParameter, (String)"idParameter");
        Intrinsics.checkParameterIsNotNull((Object)windowId, (String)"windowId");
        ActionFactory actionFactory = this;
        AsyncEncryptedBackup asyncEncryptedBackup = this.asyncEncryptedBackup;
        if (asyncEncryptedBackup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"asyncEncryptedBackup");
        }
        return new Action(windowId, actionFactory, idParameter, asyncEncryptedBackup);
    }

    public BackupFileDispatchAction() {
        super("BackupFile");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0014J\u0013\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fH\u0014\u00a2\u0006\u0002\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Ljetbrains/youtrack/maintenance/backup/BackupFileDispatchAction$Action;", "Ljetbrains/mps/webr/runtime/templateComponent/ActionController;", "windowId", "", "actionFactory", "Ljetbrains/mps/webr/runtime/templateComponent/ActionFactory;", "idParameter", "asyncEncryptedBackup", "Ljetbrains/youtrack/maintenance/backup/AsyncEncryptedBackup;", "(Ljava/lang/String;Ljetbrains/mps/webr/runtime/templateComponent/ActionFactory;Ljava/lang/String;Ljetbrains/youtrack/maintenance/backup/AsyncEncryptedBackup;)V", "getAsyncEncryptedBackup", "()Ljetbrains/youtrack/maintenance/backup/AsyncEncryptedBackup;", "doEnterAction", "Lwebr/framework/runtime/response/ResponseAction;", "getActionParameterNames", "", "()[Ljava/lang/String;", "youtrack-maintenance"})
    private static final class Action
    extends ActionController {
        @NotNull
        private final AsyncEncryptedBackup asyncEncryptedBackup;

        @NotNull
        protected String[] getActionParameterNames() {
            return new String[]{"fileName"};
        }

        @NotNull
        protected ResponseAction doEnterAction() {
            Object object = LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, ResponseAction>(this){
                final /* synthetic */ Action this$0;

                /*
                 * WARNING - void declaration
                 */
                public final ResponseAction invoke(@NotNull TransientStoreSession it) {
                    void var3_3;
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    String fileName = (String)this.this$0.getActionParameters().get("fileName");
                    ResponseAction responseAction = null;
                    if (fileName == null || StringsKt.isBlank((CharSequence)fileName)) {
                        ResponseAction responseAction2 = ResponseFactory.getInstance().getNotFoundResponse((String)Localization.INSTANCE.getBackupFileNameIsEmpty().invoke());
                        Intrinsics.checkExpressionValueIsNotNull((Object)responseAction2, (String)"ResponseFactory.getInsta\u2026.backupFileNameIsEmpty())");
                        return responseAction2;
                    }
                    if (StringsKt.indexOf$default((CharSequence)fileName, (char)'/', (int)0, (boolean)false, (int)6, null) >= 0 || StringsKt.indexOf$default((CharSequence)fileName, (char)'\\', (int)0, (boolean)false, (int)6, null) >= 0) {
                        ResponseAction responseAction3 = ResponseFactory.getInstance().getForbiddenResponse((String)Localization.INSTANCE.getSlashesAreNotAllowedInFileName().invoke());
                        Intrinsics.checkExpressionValueIsNotNull((Object)responseAction3, (String)"ResponseFactory.getInsta\u2026reNotAllowedInFileName())");
                        responseAction = responseAction3;
                    } else {
                        File file = BeansKt.getBackupFolder().getBackupFile(fileName);
                        if (!jetbrains.charisma.persistent.BeansKt.getXdLoggedInUser().hasPermission(Permission.ADMIN_UPDATE_APP)) {
                            ResponseAction responseAction4 = ResponseFactory.getInstance().getForbiddenResponse((String)Localization.INSTANCE.getYouHaveNoAccessToBackups().invoke());
                            Intrinsics.checkExpressionValueIsNotNull((Object)responseAction4, (String)"ResponseFactory.getInsta\u2026uHaveNoAccessToBackups())");
                            responseAction = responseAction4;
                        } else if (file == null) {
                            ResponseAction responseAction5 = ResponseFactory.getInstance().getNotFoundResponse((String)Localization.INSTANCE.getNoBackupWithName().invoke((Object)fileName));
                            Intrinsics.checkExpressionValueIsNotNull((Object)responseAction5, (String)"ResponseFactory.getInsta\u2026BackupWithName(fileName))");
                            responseAction = responseAction5;
                        } else {
                            responseAction = new ResponseAction(this, fileName, file){
                                final /* synthetic */ doEnterAction.1 this$0;
                                final /* synthetic */ String $fileName;
                                final /* synthetic */ File $file;

                                /*
                                 * Enabled aggressive block sorting
                                 */
                                public final void doAction(HttpServletResponse response) {
                                    response.setHeader("Content-Disposition", "attachment; filename=" + this.$fileName);
                                    ServletContext servletContext = BaseApplication.getServletContext();
                                    String mimeType = servletContext.getMimeType(this.$file.getAbsolutePath());
                                    if (mimeType != null) {
                                        CharSequence charSequence = mimeType;
                                        boolean bl = false;
                                        if (!StringsKt.isBlank((CharSequence)charSequence)) {
                                            HttpServletResponse httpServletResponse = response;
                                            Intrinsics.checkExpressionValueIsNotNull((Object)httpServletResponse, (String)"response");
                                            httpServletResponse.setContentType(mimeType);
                                        }
                                    }
                                    Environment environment = jetbrains.youtrack.core.persistent.BeansKt.getPersistentEntityStore().getEnvironment();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)environment, (String)"persistentEntityStore.environment");
                                    Environment env = environment;
                                    byte[] key = env.getCipherKey();
                                    if (key != null) {
                                        String string = this.$file.getName();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
                                        if (StringsKt.endsWith$default((String)string, (String)"tar.gz", (boolean)false, (int)2, null)) {
                                            AsyncEncryptedBackup asyncEncryptedBackup = this.this$0.this$0.getAsyncEncryptedBackup();
                                            HttpServletRequest httpServletRequest = BaseApplication.getRequest();
                                            Intrinsics.checkExpressionValueIsNotNull((Object)httpServletRequest, (String)"BaseApplication.getRequest()");
                                            HttpServletResponse httpServletResponse = response;
                                            Intrinsics.checkExpressionValueIsNotNull((Object)httpServletResponse, (String)"response");
                                            asyncEncryptedBackup.writeBackup(httpServletRequest, httpServletResponse, key, env.getCipherBasicIV(), this.$file);
                                            return;
                                        }
                                    }
                                    response.setHeader("Content-Length", String.valueOf(this.$file.length()));
                                    InputStream inputStream = new FileInputStream(this.$file);
                                    HttpServletResponse httpServletResponse = response;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)httpServletResponse, (String)"response");
                                    IOUtils.copyLarge((InputStream)inputStream, (OutputStream)((OutputStream)httpServletResponse.getOutputStream()));
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$fileName = string;
                                    this.$file = file;
                                }
                            };
                        }
                    }
                    return var3_3;
                }
                {
                    this.this$0 = action;
                    super(1);
                }
            }));
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"transactional {\n        \u2026ponseAction\n            }");
            return (ResponseAction)object;
        }

        @NotNull
        public final AsyncEncryptedBackup getAsyncEncryptedBackup() {
            return this.asyncEncryptedBackup;
        }

        public Action(@NotNull String windowId, @NotNull ActionFactory actionFactory, @NotNull String idParameter, @NotNull AsyncEncryptedBackup asyncEncryptedBackup) {
            Intrinsics.checkParameterIsNotNull((Object)windowId, (String)"windowId");
            Intrinsics.checkParameterIsNotNull((Object)actionFactory, (String)"actionFactory");
            Intrinsics.checkParameterIsNotNull((Object)idParameter, (String)"idParameter");
            Intrinsics.checkParameterIsNotNull((Object)asyncEncryptedBackup, (String)"asyncEncryptedBackup");
            super("dispatchAction", windowId, actionFactory);
            this.asyncEncryptedBackup = asyncEncryptedBackup;
            this.setIdParameter(new IdParameter("fileName", idParameter));
        }
    }
}

