/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.maintenance.backup;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import jetbrains.exodus.util.CompressBackupUtil;
import jetbrains.youtrack.maintenance.backup.listeners.XdDatabaseBackupConfig;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.CanReadFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.util.SystemPropertyUtils;

@Service(value="backupFolder")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0002J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\fJ\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eR\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0011"}, d2={"Ljetbrains/youtrack/maintenance/backup/DatabaseBackupFolder;", "", "()V", "nextBackupFile", "Ljava/io/File;", "getNextBackupFile", "()Ljava/io/File;", "rootBackupFolder", "getRootBackupFolder", "deleteBackup", "", "name", "", "doListBackupFiles", "", "getBackupFile", "listBackupFiles", "youtrack-maintenance"})
public final class DatabaseBackupFolder {
    /*
     * Unable to fully structure code
     */
    @NotNull
    public final File getRootBackupFolder() {
        savedLocation = ((XdDatabaseBackupConfig)XdDatabaseBackupConfig.Companion.get()).getBackupLocation();
        if (savedLocation == null) ** GOTO lbl-1000
        var3_2 = savedLocation;
        var4_3 = false;
        if (var3_2.length() == 0) lbl-1000:
        // 2 sources

        {
            v0 = "backup";
        } else {
            v0 = SystemPropertyUtils.resolvePlaceholders((String)savedLocation);
        }
        backupDir = v0;
        result = new File(backupDir);
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    @NotNull
    public final File getNextBackupFile() {
        return ((XdDatabaseBackupConfig)XdDatabaseBackupConfig.Companion.get()).getZipArhive() ? new File(this.getRootBackupFolder(), CompressBackupUtil.getTimeStampedZipFileName()) : new File(this.getRootBackupFolder(), CompressBackupUtil.getTimeStampedTarGzFileName());
    }

    @Nullable
    public final File getBackupFile(@NotNull String name) {
        File file;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Iterable<File> $this$firstOrNull$iv = this.doListBackupFiles();
            boolean $i$f$firstOrNull = false;
            Iterator<File> iterator = $this$firstOrNull$iv.iterator();
            while (iterator.hasNext()) {
                File element$iv;
                File it = element$iv = iterator.next();
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                file = element$iv;
                break block1;
            }
            file = null;
        }
        return file;
    }

    @NotNull
    public final Iterable<File> listBackupFiles() {
        Iterable<File> $this$sortedByDescending$iv = this.doListBackupFiles();
        boolean $i$f$sortedByDescending = false;
        Iterable<File> iterable = $this$sortedByDescending$iv;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                File it = (File)b;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(it.lastModified());
                it = (File)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Long l = it.lastModified();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        };
        return CollectionsKt.sortedWith(iterable, (Comparator)comparator);
    }

    private final Iterable<File> doListBackupFiles() {
        File backupDirectory = this.getRootBackupFolder();
        Collection files2 = FileUtils.listFiles((File)backupDirectory, (IOFileFilter)((IOFileFilter)new AndFileFilter((IOFileFilter)new SuffixFileFilter(XdDatabaseBackupConfig.Companion.getFILE_FORMATS()), CanReadFileFilter.CAN_READ)), (IOFileFilter)((IOFileFilter)new AbstractFileFilter(backupDirectory){
            final /* synthetic */ File $backupDirectory;

            public boolean accept(@NotNull File file) {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                return Intrinsics.areEqual((Object)file.getParent(), (Object)this.$backupDirectory.getAbsolutePath());
            }
            {
                this.$backupDirectory = $captured_local_variable$0;
            }
        }));
        ArrayList fileList = new ArrayList();
        fileList.addAll(files2);
        Collection collection = files2;
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"files");
        return collection;
    }

    public final boolean deleteBackup(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        File fileToRemove = this.getBackupFile(name);
        try {
            File file = fileToRemove;
            return file != null ? file.delete() : false;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }
}

