/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.maintenance.backup.listeners;

import jetbrains.youtrack.api.user.UserMergeHandler;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.maintenance.backup.listeners.XdDatabaseBackupConfig;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Ljetbrains/youtrack/maintenance/backup/listeners/DatabaseConfigUserMergeHandler;", "Ljetbrains/youtrack/api/user/UserMergeHandler;", "()V", "priority", "", "getPriority", "()I", "userDeleted", "", "deleted", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "successor", "userMerged", "from", "into", "youtrack-maintenance"})
public final class DatabaseConfigUserMergeHandler
implements UserMergeHandler {
    private final int priority = 10000;

    public int getPriority() {
        return this.priority;
    }

    public void userMerged(@NotNull XdUser from, @NotNull XdUser into) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)into, (String)"into");
        XdDatabaseBackupConfig backupConfig = (XdDatabaseBackupConfig)XdDatabaseBackupConfig.Companion.get();
        if (XdQueryKt.contains((XdQuery)((XdQuery)backupConfig.getNotifiedUsers()), (XdEntity)((XdEntity)from))) {
            backupConfig.getNotifiedUsers().remove((XdEntity)from);
            if (!into.isGuest()) {
                backupConfig.getNotifiedUsers().add((XdEntity)into);
            }
        }
    }

    public void userDeleted(@NotNull XdUser deleted, @NotNull XdUser successor) {
        Intrinsics.checkParameterIsNotNull((Object)deleted, (String)"deleted");
        Intrinsics.checkParameterIsNotNull((Object)successor, (String)"successor");
        ((XdDatabaseBackupConfig)XdDatabaseBackupConfig.Companion.get()).getNotifiedUsers().remove((XdEntity)deleted);
    }
}

