/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.maintenance.backup.rest;

import java.io.File;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import jetbrains.charisma.persistent.security.PrincipalsKt;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.gap.resource.components.EntityGetter;
import jetbrains.gap.resource.components.EntityRemover;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.gaprest.exception.LocalizedBadRequestException;
import jetbrains.youtrack.maintenance.BeansKt;
import jetbrains.youtrack.maintenance.backup.rest.BackupFile;
import jetbrains.youtrack.maintenance.backup.rest.BackupStatus;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0016J\u0014\u0010\f\u001a\u0004\u0018\u00010\u00022\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Ljetbrains/youtrack/maintenance/backup/rest/BackupFileResource;", "Ljetbrains/gap/resource/components/EntityGetter;", "Ljetbrains/gap/resource/Entity;", "Ljetbrains/gap/resource/components/EntityRemover;", "file", "Ljetbrains/youtrack/maintenance/backup/rest/BackupFile;", "(Ljetbrains/youtrack/maintenance/backup/rest/BackupFile;)V", "getFile", "()Ljetbrains/youtrack/maintenance/backup/rest/BackupFile;", "assertDeleteAccess", "", "doGet", "doSet", "value", "youtrack-maintenance"})
public final class BackupFileResource
implements EntityGetter<jetbrains.gap.resource.Entity>,
EntityRemover<jetbrains.gap.resource.Entity> {
    @NotNull
    private final BackupFile file;

    @Nullable
    public jetbrains.gap.resource.Entity doGet() {
        return this.file;
    }

    @Nullable
    public jetbrains.gap.resource.Entity doSet(@Nullable jetbrains.gap.resource.Entity value) {
        if (value == null) {
            Iterable<File> backups;
            File unfinishedBackup;
            if (BackupStatus.Companion.getINSTANCE().getBackupInProgress() && (unfinishedBackup = (File)CollectionsKt.firstOrNull(backups = BeansKt.getBackupFolder().listBackupFiles())) != null && Intrinsics.areEqual((Object)unfinishedBackup, (Object)this.file.getFile())) {
                throw (Throwable)new LocalizedBadRequestException("Resources.cannot_delete_unfinished_backup", new Object[0]);
            }
            this.file.getFile().delete();
            return null;
        }
        throw (Throwable)new LocalizedBadRequestException("Resources.cant_edit_backup_file", new Object[0]);
    }

    public void assertDeleteAccess() {
        PrincipalsKt.assertAccess((boolean)PrincipalsKt.hasPermission((Entity)((Entity)jetbrains.charisma.persistent.BeansKt.getLoggedInUser()), (Permission)Permission.ADMIN_UPDATE_APP));
    }

    @NotNull
    public final BackupFile getFile() {
        return this.file;
    }

    public BackupFileResource(@NotNull BackupFile file) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)file), (String)"file");
        this.file = file;
    }

    public void assertCanAccess() {
        EntityGetter.DefaultImpls.assertCanAccess((EntityGetter)this);
    }

    @GET
    @Produces(value={"application/json"})
    @NotNull
    public jetbrains.gap.resource.Entity getEntity() {
        return EntityGetter.DefaultImpls.getEntity((EntityGetter)this);
    }

    @DELETE
    @Produces(value={"application/json"})
    @NotNull
    public Response delete() {
        return EntityRemover.DefaultImpls.delete((EntityRemover)this);
    }

    @Nullable
    public jetbrains.gap.resource.Entity doDelete() {
        return EntityRemover.DefaultImpls.doDelete((EntityRemover)this);
    }
}

