/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.maintenance.backup.rest;

import jetbrains.charisma.main.CharismaLicenseChecker;
import jetbrains.charisma.main.ConfigurationUtil;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.charisma.persistent.security.PrincipalsKt;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.gap.resource.HelpersKt;
import jetbrains.gap.resource.Secured;
import jetbrains.gap.resource.metadata.Delegate;
import jetbrains.gap.resource.metadata.DelegateProvider;
import jetbrains.gap.resource.metadata.DelegateProviderKt;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.rest.RestPublic;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.gaprest.RestInternal;
import jetbrains.youtrack.gaprest.db.XodusDatabase;
import jetbrains.youtrack.gaprest.exception.LocalizedBadRequestException;
import jetbrains.youtrack.gaprest.util.SingletonEntity;
import jetbrains.youtrack.maintenance.backup.AsyncBackupBean;
import jetbrains.youtrack.maintenance.backup.listeners.XdDatabaseBackupConfig;
import jetbrains.youtrack.maintenance.backup.listeners.XdDatabaseBackupError;
import jetbrains.youtrack.maintenance.backup.rest.BackupError;
import jetbrains.youtrack.maintenance.backup.rest.BackupStatus;
import jetbrains.youtrack.maintenance.backup.rest.BackupStatus$updateFrom$1;
import jetbrains.youtrack.maintenance.backup.rest.BackupStatus$updateFrom$2;
import jetbrains.youtrack.maintenance.backup.rest.BackupStatus$updateFrom$3;
import jetbrains.youtrack.maintenance.backup.rest.BackupStatusKt;
import jetbrains.youtrack.maintenance.backup.rest.DatabaseBackupSettings;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KMutableProperty1;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlinx.dnq.XdEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RestPublic
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0016\u001a\u00020\u0005H\u0016J\b\u0010\u0017\u001a\u00020\u0005H\u0016J\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R1\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00058V@VX\u0097\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u0014\u0010\u0015\u0012\u0004\b\u0010\u0010\u0003\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Ljetbrains/youtrack/maintenance/backup/rest/BackupStatus;", "Ljetbrains/youtrack/gaprest/util/SingletonEntity;", "Ljetbrains/gap/resource/Secured;", "()V", "backupCancelled", "", "getBackupCancelled", "()Z", "backupError", "Ljetbrains/youtrack/maintenance/backup/rest/BackupError;", "getBackupError", "()Ljetbrains/youtrack/maintenance/backup/rest/BackupError;", "backupInProgress", "getBackupInProgress", "<set-?>", "stopBackup", "stopBackup$annotations", "getStopBackup", "setStopBackup", "(Z)V", "stopBackup$delegate", "Ljetbrains/gap/resource/metadata/Delegate;", "canAccess", "canUpdate", "startBackup", "", "updateFrom", "that", "Ljetbrains/gap/resource/Entity;", "Companion", "youtrack-maintenance"})
public class BackupStatus
extends SingletonEntity
implements Secured {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final Delegate stopBackup$delegate = DelegateProviderKt.delegate((DelegateProvider)this, (Function0)stopBackup.2.INSTANCE);
    @NotNull
    private static final BackupStatus INSTANCE;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(BackupStatus.class), "stopBackup", "getStopBackup()Z"))};
        Companion = new Companion(null);
        INSTANCE = new BackupStatus();
    }

    public boolean getBackupInProgress() {
        return BackupStatusKt.getBackupBean().getBackupStartTicks() > 0L;
    }

    @RestInternal
    public static /* synthetic */ void stopBackup$annotations() {
    }

    public boolean getStopBackup() {
        return (Boolean)this.stopBackup$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public void setStopBackup(boolean bl) {
        this.stopBackup$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)bl);
    }

    public boolean getBackupCancelled() {
        return BackupStatusKt.getBackupBean().isCancelled();
    }

    @Nullable
    public BackupError getBackupError() {
        if (!this.getBackupInProgress()) {
            BackupError backupError;
            XdDatabaseBackupError xdDatabaseBackupError = ((XdDatabaseBackupConfig)XdDatabaseBackupConfig.Companion.get()).getLastError();
            if (xdDatabaseBackupError != null) {
                XdEntity $this$kt$iv = (XdEntity)xdDatabaseBackupError;
                boolean $i$f$kt = false;
                Entity $receiver$iv$iv = $this$kt$iv.getEntity();
                backupError = (BackupError)XodusDatabase.INSTANCE.wrap(BackupError.class, $receiver$iv$iv, new Object[0]);
            } else {
                backupError = null;
            }
            return backupError;
        }
        return null;
    }

    public void updateFrom(@NotNull jetbrains.gap.resource.Entity that) {
        Intrinsics.checkParameterIsNotNull((Object)that, (String)"that");
        if (that instanceof BackupStatus && that.provides(BackupStatus$updateFrom$1.INSTANCE) && !this.getBackupInProgress() && ((BackupStatus)that).getBackupInProgress() && (!that.provides(BackupStatus$updateFrom$2.INSTANCE) || !((BackupStatus)that).getBackupCancelled())) {
            this.startBackup();
        }
        HelpersKt.apply((jetbrains.gap.resource.Entity)this, (jetbrains.gap.resource.Entity)that, (KMutableProperty1)BackupStatus$updateFrom$3.INSTANCE);
    }

    public boolean canAccess() {
        return PrincipalsKt.hasPermission((Entity)((Entity)BeansKt.getLoggedInUser()), (Permission)Permission.ADMIN_READ_APP);
    }

    public boolean canUpdate() {
        return PrincipalsKt.hasPermission((Entity)((Entity)BeansKt.getLoggedInUser()), (Permission)Permission.ADMIN_UPDATE_APP);
    }

    public final void startBackup() {
        Object object;
        try {
            DatabaseBackupSettings.Companion.validateBackupLocationPermissions(BackupStatusKt.getBackupBean().getBackupPath());
        }
        catch (Throwable e) {
            throw (Throwable)new LocalizedBadRequestException("BackupStatus.cannot_start_backup_the_backup_location_is_not_write_accessible", new Object[0]);
        }
        if (CharismaLicenseChecker.isEnoughDiskSpace() || ConfigurationUtil.isYoutrackHosted()) {
            String name$iv = "asyncBackupBean";
            boolean $i$f$getBean = false;
            object = ServiceLocator.getBean((String)name$iv);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.maintenance.backup.AsyncBackupBean");
            }
        } else {
            throw (Throwable)new LocalizedBadRequestException("BackupStatus.cannot_start_backup_license_disk_limit", new Object[0]);
        }
        AsyncBackupBean asyncBackupBean = (AsyncBackupBean)object;
        asyncBackupBean.asyncBackup();
    }

    public void assertAccess() {
        Secured.DefaultImpls.assertAccess((Secured)this);
    }

    public void assertDeleteAccess() {
        Secured.DefaultImpls.assertDeleteAccess((Secured)this);
    }

    public void assertUpdateAccess() {
        Secured.DefaultImpls.assertUpdateAccess((Secured)this);
    }

    public void assertUpdateAccess(@NotNull KProperty1<?, ?> property) {
        Intrinsics.checkParameterIsNotNull(property, (String)"property");
        Secured.DefaultImpls.assertUpdateAccess((Secured)this, property);
    }

    public boolean canDelete() {
        return Secured.DefaultImpls.canDelete((Secured)this);
    }

    public boolean canUpdateProperty(@NotNull KProperty1<?, ?> property) {
        Intrinsics.checkParameterIsNotNull(property, (String)"property");
        return Secured.DefaultImpls.canUpdateProperty((Secured)this, property);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/youtrack/maintenance/backup/rest/BackupStatus$Companion;", "", "()V", "INSTANCE", "Ljetbrains/youtrack/maintenance/backup/rest/BackupStatus;", "getINSTANCE", "()Ljetbrains/youtrack/maintenance/backup/rest/BackupStatus;", "youtrack-maintenance"})
    public static final class Companion {
        @NotNull
        public final BackupStatus getINSTANCE() {
            return INSTANCE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

