/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.maintenance.rest;

import java.util.Locale;
import jetbrains.charisma.main.ConfigurationUtil;
import jetbrains.charisma.maintenance.MaintenanceUtil;
import jetbrains.charisma.persistent.security.PrincipalsKt;
import jetbrains.exodus.entitystore.BlobVault;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentStatistics;
import jetbrains.exodus.management.StatisticsItem;
import jetbrains.gap.resource.Secured;
import jetbrains.mps.webr.runtime.servlet.MainServlet;
import jetbrains.youtrack.api.rest.RestPublic;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.gaprest.RestInternal;
import jetbrains.youtrack.gaprest.util.SingletonEntity;
import jetbrains.youtrack.maintenance.BeansKt;
import jetbrains.youtrack.maintenance.rest.Jobs;
import jetbrains.youtrack.maintenance.rest.OnlineUsers;
import jetbrains.youtrack.maintenance.rest.Telemetry;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormat;

@RestPublic
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010<\u001a\u00020=H\u0016J#\u0010>\u001a\u0004\u0018\u0001H?\"\u0004\b\u0000\u0010?2\f\u0010@\u001a\b\u0012\u0004\u0012\u0002H?0AH\u0002\u00a2\u0006\u0002\u0010BR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0007R\u0014\u0010\u0010\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0007R\u0014\u0010\u0017\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0007R\u0014\u0010\u0019\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0007R\u0014\u0010\u001b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0007R\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0007R\u001a\u0010\u001f\u001a\u00020 8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b!\u0010\u0003\u001a\u0004\b\"\u0010#R\u0016\u0010$\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0007R\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0012R\u0014\u0010,\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0007R\u0014\u0010.\u001a\u00020/8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0014\u00102\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0007R\u0014\u00104\u001a\u00020/8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00101R\u0014\u00106\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u0007R\u0014\u00108\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u0007R\u0016\u0010:\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010\u0007\u00a8\u0006C"}, d2={"Ljetbrains/youtrack/maintenance/rest/Telemetry;", "Ljetbrains/youtrack/gaprest/util/SingletonEntity;", "Ljetbrains/gap/resource/Secured;", "()V", "allocatedMemory", "", "getAllocatedMemory", "()Ljava/lang/String;", "availableMemory", "getAvailableMemory", "availableProcessors", "", "getAvailableProcessors", "()Ljava/lang/Integer;", "blobStringsCacheHitRate", "getBlobStringsCacheHitRate", "cachedResultsCountInDBQueriesCache", "getCachedResultsCountInDBQueriesCache", "()I", "databaseBackgroundThreads", "getDatabaseBackgroundThreads", "databaseLocation", "getDatabaseLocation", "databaseQueriesCacheHitRate", "getDatabaseQueriesCacheHitRate", "databaseSize", "getDatabaseSize", "fullDatabaseSize", "getFullDatabaseSize", "installationFolder", "getInstallationFolder", "jobs", "Ljetbrains/youtrack/maintenance/rest/Jobs;", "jobs$annotations", "getJobs", "()Ljetbrains/youtrack/maintenance/rest/Jobs;", "logsLocation", "getLogsLocation", "onlineUsers", "Ljetbrains/youtrack/maintenance/rest/OnlineUsers;", "getOnlineUsers", "()Ljetbrains/youtrack/maintenance/rest/OnlineUsers;", "pendingAsyncJobs", "getPendingAsyncJobs", "requestsPerSecond", "getRequestsPerSecond", "startedTime", "", "getStartedTime", "()J", "textIndexSize", "getTextIndexSize", "totalTransactions", "getTotalTransactions", "transactionsPerSecond", "getTransactionsPerSecond", "uptime", "getUptime", "usedMemory", "getUsedMemory", "canAccess", "", "standaloneOnly", "T", "value", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "youtrack-maintenance"})
public class Telemetry
extends SingletonEntity
implements Secured {
    @Nullable
    public String getInstallationFolder() {
        return (String)this.standaloneOnly(installationFolder.1.INSTANCE);
    }

    @Nullable
    public String getDatabaseLocation() {
        return (String)this.standaloneOnly(databaseLocation.1.INSTANCE);
    }

    @Nullable
    public String getLogsLocation() {
        return (String)this.standaloneOnly(logsLocation.1.INSTANCE);
    }

    @Nullable
    public Integer getAvailableProcessors() {
        return (Integer)this.standaloneOnly(availableProcessors.1.INSTANCE);
    }

    @Nullable
    public String getAvailableMemory() {
        return (String)this.standaloneOnly(availableMemory.1.INSTANCE);
    }

    @Nullable
    public String getAllocatedMemory() {
        return (String)this.standaloneOnly(allocatedMemory.1.INSTANCE);
    }

    @Nullable
    public String getUsedMemory() {
        return (String)this.standaloneOnly(usedMemory.1.INSTANCE);
    }

    @NotNull
    public String getUptime() {
        String string = PeriodFormat.wordBased((Locale)jetbrains.charisma.persistent.BeansKt.getXdApplicationMetaData().getLocale()).print((ReadablePeriod)new Period(BeansKt.getApplicationStatus().getUptime()));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PeriodFormat.wordBased(x\u2026pplicationStatus.uptime))");
        return string;
    }

    public long getStartedTime() {
        return BeansKt.getApplicationStatus().getStartTime();
    }

    public int getDatabaseBackgroundThreads() {
        return jetbrains.youtrack.core.persistent.BeansKt.getPersistentEntityStore().getAsyncProcessor().getThreadCount();
    }

    public int getPendingAsyncJobs() {
        return jetbrains.youtrack.core.persistent.BeansKt.getPersistentEntityStore().getAsyncProcessor().pendingJobs();
    }

    public int getCachedResultsCountInDBQueriesCache() {
        return jetbrains.youtrack.core.persistent.BeansKt.getPersistentEntityStore().getEntityIterableCache().count();
    }

    @NotNull
    public String getDatabaseQueriesCacheHitRate() {
        String string = MaintenanceUtil.formatFractionInPercents((float)jetbrains.youtrack.core.persistent.BeansKt.getPersistentEntityStore().getEntityIterableCache().hitRate());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"MaintenanceUtil.formatFr\u2026yIterableCache.hitRate())");
        return string;
    }

    @NotNull
    public String getBlobStringsCacheHitRate() {
        BlobVault blobVault = jetbrains.youtrack.core.persistent.BeansKt.getPersistentEntityStore().getBlobVault();
        Intrinsics.checkExpressionValueIsNotNull((Object)blobVault, (String)"persistentEntityStore.blobVault");
        String string = MaintenanceUtil.formatFractionInPercents((float)blobVault.getStringContentCacheHitRate());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"MaintenanceUtil.formatFr\u2026tringContentCacheHitRate)");
        return string;
    }

    public long getTotalTransactions() {
        Environment environment = jetbrains.youtrack.core.persistent.BeansKt.getPersistentEntityStore().getEnvironment();
        Intrinsics.checkExpressionValueIsNotNull((Object)environment, (String)"persistentEntityStore.environment");
        StatisticsItem statisticsItem = environment.getStatistics().getStatisticsItem((Enum)EnvironmentStatistics.Type.TRANSACTIONS);
        Intrinsics.checkExpressionValueIsNotNull((Object)statisticsItem, (String)"persistentEntityStore.en\u2026tisticsItem(TRANSACTIONS)");
        return statisticsItem.getTotal();
    }

    @NotNull
    public String getTransactionsPerSecond() {
        Environment environment = jetbrains.youtrack.core.persistent.BeansKt.getPersistentEntityStore().getEnvironment();
        Intrinsics.checkExpressionValueIsNotNull((Object)environment, (String)"persistentEntityStore.environment");
        StatisticsItem statisticsItem = environment.getStatistics().getStatisticsItem((Enum)EnvironmentStatistics.Type.TRANSACTIONS);
        Intrinsics.checkExpressionValueIsNotNull((Object)statisticsItem, (String)"persistentEntityStore.en\u2026tisticsItem(TRANSACTIONS)");
        String string = MaintenanceUtil.formatFraction((double)statisticsItem.getMean());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"MaintenanceUtil.formatFr\u2026(TRANSACTIONS).mean\n    )");
        return string;
    }

    @NotNull
    public String getRequestsPerSecond() {
        String string = MaintenanceUtil.formatFraction((double)MainServlet.getRequestsPerSecond());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"MaintenanceUtil.formatFr\u2026t.getRequestsPerSecond())");
        return string;
    }

    @NotNull
    public String getDatabaseSize() {
        Environment environment = jetbrains.youtrack.core.persistent.BeansKt.getPersistentEntityStore().getEnvironment();
        Intrinsics.checkExpressionValueIsNotNull((Object)environment, (String)"persistentEntityStore.environment");
        StatisticsItem statisticsItem = environment.getStatistics().getStatisticsItem((Enum)EnvironmentStatistics.Type.DISK_USAGE);
        Intrinsics.checkExpressionValueIsNotNull((Object)statisticsItem, (String)"persistentEntityStore.en\u2026tatisticsItem(DISK_USAGE)");
        String string = MaintenanceUtil.formatDiskSpace((long)statisticsItem.getTotal());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"MaintenanceUtil.formatDi\u2026m(DISK_USAGE).total\n    )");
        return string;
    }

    @NotNull
    public String getFullDatabaseSize() {
        String string = MaintenanceUtil.formatDiskSpace((long)jetbrains.charisma.persistent.BeansKt.getDiskSpaceManagement().getStorageSize());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"MaintenanceUtil.formatDi\u2026ceManagement.storageSize)");
        return string;
    }

    @NotNull
    public String getTextIndexSize() {
        String string = MaintenanceUtil.formatDiskSpace((long)jetbrains.charisma.persistent.BeansKt.getTextIndexManager().getStoreSize());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"MaintenanceUtil.formatDi\u2026xtIndexManager.storeSize)");
        return string;
    }

    @NotNull
    public OnlineUsers getOnlineUsers() {
        return new OnlineUsers();
    }

    @RestInternal
    public static /* synthetic */ void jobs$annotations() {
    }

    @NotNull
    public Jobs getJobs() {
        return new Jobs();
    }

    public boolean canAccess() {
        return PrincipalsKt.hasPermission((Entity)((Entity)jetbrains.charisma.persistent.BeansKt.getLoggedInUser()), (Permission)Permission.ADMIN_READ_APP);
    }

    private final <T> T standaloneOnly(Function0<? extends T> value) {
        return (T)(ConfigurationUtil.isYoutrackHosted() ? null : value.invoke());
    }

    public void assertAccess() {
        Secured.DefaultImpls.assertAccess((Secured)this);
    }

    public void assertDeleteAccess() {
        Secured.DefaultImpls.assertDeleteAccess((Secured)this);
    }

    public void assertUpdateAccess() {
        Secured.DefaultImpls.assertUpdateAccess((Secured)this);
    }

    public void assertUpdateAccess(@NotNull KProperty1<?, ?> property) {
        Intrinsics.checkParameterIsNotNull(property, (String)"property");
        Secured.DefaultImpls.assertUpdateAccess((Secured)this, property);
    }

    public boolean canDelete() {
        return Secured.DefaultImpls.canDelete((Secured)this);
    }

    public boolean canUpdate() {
        return Secured.DefaultImpls.canUpdate((Secured)this);
    }

    public boolean canUpdateProperty(@NotNull KProperty1<?, ?> property) {
        Intrinsics.checkParameterIsNotNull(property, (String)"property");
        return Secured.DefaultImpls.canUpdateProperty((Secured)this, property);
    }
}

