/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.maintenance.scheduling;

import java.io.File;
import jetbrains.charisma.main.CharismaLicenseChecker;
import jetbrains.charisma.main.ConfigurationUtil;
import jetbrains.exodus.backup.Backupable;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.util.CompressBackupUtil;
import jetbrains.youtrack.api.notifications.NotificationCase;
import jetbrains.youtrack.api.notifications.NotificationData;
import jetbrains.youtrack.api.notifications.NotificationDataProperty;
import jetbrains.youtrack.api.webr.LocalScoped;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.core.security.Security;
import jetbrains.youtrack.maintenance.BeansKt;
import jetbrains.youtrack.maintenance.backup.AsyncBackupBean;
import jetbrains.youtrack.maintenance.backup.CancellableBackupBean;
import jetbrains.youtrack.maintenance.backup.listeners.XdDatabaseBackupConfig;
import jetbrains.youtrack.maintenance.backup.listeners.XdDatabaseBackupError;
import jetbrains.youtrack.maintenance.notification.StatusBackupNotificationCaseKt;
import jetbrains.youtrack.maintenance.scheduling.BackupDatabaseScheduling$execute$;
import jetbrains.youtrack.notifications.NotificationService;
import jetbrains.youtrack.scheduling.LocalCronScheduling;
import jetbrains.youtrack.scheduling.LocalScheduling;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@LocalScoped
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00020\u00138\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00108\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00020\u00178\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ljetbrains/youtrack/maintenance/scheduling/BackupDatabaseScheduling;", "Ljetbrains/youtrack/scheduling/LocalCronScheduling;", "()V", "asyncBackupBean", "Ljetbrains/youtrack/maintenance/backup/AsyncBackupBean;", "backupBean", "Ljetbrains/youtrack/maintenance/backup/CancellableBackupBean;", "cron", "", "getCron", "()Ljava/lang/String;", "dbBackupConfig", "Ljetbrains/youtrack/maintenance/backup/listeners/XdDatabaseBackupConfig;", "getDbBackupConfig", "()Ljetbrains/youtrack/maintenance/backup/listeners/XdDatabaseBackupConfig;", "exceptionNotificationProperty", "Ljetbrains/youtrack/api/notifications/NotificationDataProperty;", "", "notificationService", "Ljetbrains/youtrack/notifications/NotificationService;", "recipientNotificationProperty", "Ljetbrains/exodus/entitystore/Entity;", "security", "Ljetbrains/youtrack/core/security/Security;", "execute", "", "shouldSchedule", "", "youtrack-maintenance"})
public final class BackupDatabaseScheduling
extends LocalCronScheduling {
    @Autowired
    @Qualifier(value="exceptionNotificationProperty")
    private NotificationDataProperty<Throwable> exceptionNotificationProperty;
    @Autowired
    @Qualifier(value="recipientNotificationProperty")
    private NotificationDataProperty<Entity> recipientNotificationProperty;
    @Autowired
    private AsyncBackupBean asyncBackupBean;
    @Autowired
    private CancellableBackupBean backupBean;
    @Autowired
    private Security security;
    @Autowired
    private NotificationService notificationService;

    private final XdDatabaseBackupConfig getDbBackupConfig() {
        return (XdDatabaseBackupConfig)XdDatabaseBackupConfig.Companion.get();
    }

    @NotNull
    public String getCron() {
        return (String)LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, String>(this){
            final /* synthetic */ BackupDatabaseScheduling this$0;

            @NotNull
            public final String invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return BackupDatabaseScheduling.access$getDbBackupConfig$p(this.this$0).getCronExpression();
            }
            {
                this.this$0 = backupDatabaseScheduling;
                super(1);
            }
        }));
    }

    public boolean shouldSchedule() {
        return !ConfigurationUtil.isYoutrackHosted();
    }

    public void execute() {
        if (!this.getDbBackupConfig().isOn()) {
            return;
        }
        File backupFile = BeansKt.getBackupFolder().getNextBackupFile();
        try {
            if (!CharismaLicenseChecker.isEnoughDiskSpace()) {
                throw (Throwable)new Exception(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("AdministrativeTasks.Not_enough_disk_space_to_make_backup", new Object[0]));
            }
            AsyncBackupBean asyncBackupBean = this.asyncBackupBean;
            if (asyncBackupBean == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"asyncBackupBean");
            }
            if (asyncBackupBean.getBackupInProgress()) {
                LocalScheduling.Companion.getLogger().info("Attempt to execute simultaneous database backup");
            } else {
                CancellableBackupBean cancellableBackupBean = this.backupBean;
                if (cancellableBackupBean == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"backupBean");
                }
                Backupable backupable = (Backupable)cancellableBackupBean;
                CancellableBackupBean cancellableBackupBean2 = this.backupBean;
                if (cancellableBackupBean2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"backupBean");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)CompressBackupUtil.backup((Backupable)backupable, (File)backupFile, (boolean)cancellableBackupBean2.getBackupToZip()), (String)"backup(backupBean, backu\u2026, backupBean.backupToZip)");
            }
        }
        catch (Throwable t) {
            this.getDbBackupConfig().getErrors().add((XdEntity)XdDatabaseBackupError.Companion.new$default(XdDatabaseBackupError.Companion, backupFile, t, null, 4, null));
            Sequence $this$forEach$iv = XdQueryKt.asSequence((XdQuery)((XdQuery)this.getDbBackupConfig().getNotifiedUsers()));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                XdUser user = (XdUser)element$iv;
                boolean bl = false;
                LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, Unit>(user, this, t){
                    final /* synthetic */ XdUser $user;
                    final /* synthetic */ BackupDatabaseScheduling this$0;
                    final /* synthetic */ Throwable $t$inlined;
                    {
                        this.$user = xdUser;
                        this.this$0 = backupDatabaseScheduling;
                        this.$t$inlined = throwable;
                        super(1);
                    }

                    public final void invoke(@NotNull TransientStoreSession it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        if (BackupDatabaseScheduling.access$getSecurity$p(this.this$0).hasPermission(this.$user.getEntity(), Permission.ADMIN_READ_APP) && !this.$user.getBanned()) {
                            NotificationService.DefaultImpls.notifyCase$default((NotificationService)BackupDatabaseScheduling.access$getNotificationService$p(this.this$0), (NotificationCase)StatusBackupNotificationCaseKt.getStatusBackupNotificationCase(), (XdUser)this.$user, null, (Function1)((Function1)new Function1<NotificationData, Unit>(this){
                                final /* synthetic */ execute$$inlined$forEach$lambda$1 this$0;
                                {
                                    this.this$0 = var1_1;
                                    super(1);
                                }

                                public final void invoke(@NotNull NotificationData $this$notifyCase) {
                                    Intrinsics.checkParameterIsNotNull((Object)$this$notifyCase, (String)"$receiver");
                                    $this$notifyCase.set(BackupDatabaseScheduling.access$getExceptionNotificationProperty$p(this.this$0.this$0), (Object)this.this$0.$t$inlined);
                                    $this$notifyCase.set(BackupDatabaseScheduling.access$getRecipientNotificationProperty$p(this.this$0.this$0), (Object)this.this$0.$user.getEntity());
                                }
                            }), (int)4, null);
                        } else {
                            LocalScheduling.Companion.getLogger().warn(this.$t$inlined, (Function0)new Function0<String>(this){
                                final /* synthetic */ execute$$inlined$forEach$lambda$1 this$0;
                                {
                                    this.this$0 = var1_1;
                                    super(0);
                                }

                                @NotNull
                                public final String invoke() {
                                    return "User " + this.this$0.$user.getLogin() + " is configured to receive database backup notification, but has no permissions to do so.";
                                }
                            });
                        }
                    }
                }));
            }
        }
    }

    public static final /* synthetic */ XdDatabaseBackupConfig access$getDbBackupConfig$p(BackupDatabaseScheduling $this) {
        return $this.getDbBackupConfig();
    }

    public static final /* synthetic */ Security access$getSecurity$p(BackupDatabaseScheduling $this) {
        Security security = $this.security;
        if (security == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"security");
        }
        return security;
    }

    public static final /* synthetic */ void access$setSecurity$p(BackupDatabaseScheduling $this, Security security) {
        $this.security = security;
    }

    public static final /* synthetic */ NotificationService access$getNotificationService$p(BackupDatabaseScheduling $this) {
        NotificationService notificationService = $this.notificationService;
        if (notificationService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"notificationService");
        }
        return notificationService;
    }

    public static final /* synthetic */ void access$setNotificationService$p(BackupDatabaseScheduling $this, NotificationService notificationService) {
        $this.notificationService = notificationService;
    }

    public static final /* synthetic */ NotificationDataProperty access$getExceptionNotificationProperty$p(BackupDatabaseScheduling $this) {
        NotificationDataProperty<Throwable> notificationDataProperty = $this.exceptionNotificationProperty;
        if (notificationDataProperty == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"exceptionNotificationProperty");
        }
        return notificationDataProperty;
    }

    public static final /* synthetic */ void access$setExceptionNotificationProperty$p(BackupDatabaseScheduling $this, NotificationDataProperty notificationDataProperty) {
        $this.exceptionNotificationProperty = notificationDataProperty;
    }

    public static final /* synthetic */ NotificationDataProperty access$getRecipientNotificationProperty$p(BackupDatabaseScheduling $this) {
        NotificationDataProperty<Entity> notificationDataProperty = $this.recipientNotificationProperty;
        if (notificationDataProperty == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recipientNotificationProperty");
        }
        return notificationDataProperty;
    }

    public static final /* synthetic */ void access$setRecipientNotificationProperty$p(BackupDatabaseScheduling $this, NotificationDataProperty notificationDataProperty) {
        $this.recipientNotificationProperty = notificationDataProperty;
    }
}

