/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.maintenance.scheduling;

import jetbrains.charisma.main.ConfigurationUtil;
import jetbrains.charisma.persistent.FreeDiskSpaceSamples;
import jetbrains.charisma.persistent.ReadOnlyKt;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.youtrack.api.webr.LocalScoped;
import jetbrains.youtrack.config.SystemEventsBannerProvider;
import jetbrains.youtrack.maintenance.Localization;
import jetbrains.youtrack.maintenance.backup.listeners.XdDatabaseBackupConfig;
import jetbrains.youtrack.scheduling.LocalCronScheduling;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@LocalScoped
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\r8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\u000f8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ljetbrains/youtrack/maintenance/scheduling/VerifyUsableSpaceScheduling;", "Ljetbrains/youtrack/scheduling/LocalCronScheduling;", "Ljetbrains/youtrack/config/SystemEventsBannerProvider;", "()V", "cron", "", "getCron", "()Ljava/lang/String;", "dbBackupConfig", "Ljetbrains/youtrack/maintenance/backup/listeners/XdDatabaseBackupConfig;", "getDbBackupConfig", "()Ljetbrains/youtrack/maintenance/backup/listeners/XdDatabaseBackupConfig;", "freeDiskSpaceSamples", "Ljetbrains/charisma/persistent/FreeDiskSpaceSamples;", "persistentEntityStore", "Ljetbrains/exodus/entitystore/PersistentEntityStore;", "execute", "", "renderBanner", "shouldSchedule", "", "youtrack-maintenance"})
public final class VerifyUsableSpaceScheduling
extends LocalCronScheduling
implements SystemEventsBannerProvider {
    @Autowired
    private PersistentEntityStore persistentEntityStore;
    @Autowired
    private FreeDiskSpaceSamples freeDiskSpaceSamples;
    @NotNull
    private final String cron = "0 * * * * ?";

    private final XdDatabaseBackupConfig getDbBackupConfig() {
        return (XdDatabaseBackupConfig)XdDatabaseBackupConfig.Companion.get();
    }

    @NotNull
    public String getCron() {
        return this.cron;
    }

    public boolean shouldSchedule() {
        return !ConfigurationUtil.isYoutrackHosted() && !ConfigurationUtil.isTestMode();
    }

    public void execute() {
        long freeSpace;
        if (ReadOnlyKt.isReadonly()) {
            return;
        }
        this.getDbBackupConfig().setTimeToExhaustDisk(0L);
        PersistentEntityStore persistentEntityStore = this.persistentEntityStore;
        if (persistentEntityStore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"persistentEntityStore");
        }
        if ((freeSpace = persistentEntityStore.getUsableSpace()) < 1000000000L) {
            Long latestFreeSpace;
            Pair latestSample;
            FreeDiskSpaceSamples freeDiskSpaceSamples = this.freeDiskSpaceSamples;
            if (freeDiskSpaceSamples == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"freeDiskSpaceSamples");
            }
            if ((latestSample = freeDiskSpaceSamples.getLatestSample()) != null && (latestFreeSpace = (Long)latestSample.getSecond()) > freeSpace) {
                long l = System.currentTimeMillis();
                Object object = latestSample.getFirst();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"latestSample.first");
                double timeToExhaustDisk = (double)(l - ((Number)object).longValue()) * (double)freeSpace / (double)(latestFreeSpace - freeSpace);
                if (timeToExhaustDisk < (double)86400000) {
                    this.getDbBackupConfig().setTimeToExhaustDisk((long)timeToExhaustDisk);
                }
            }
        }
        FreeDiskSpaceSamples freeDiskSpaceSamples = this.freeDiskSpaceSamples;
        if (freeDiskSpaceSamples == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"freeDiskSpaceSamples");
        }
        freeDiskSpaceSamples.addSample(freeSpace);
    }

    @Nullable
    public String renderBanner() {
        String string;
        FreeDiskSpaceSamples freeDiskSpaceSamples = this.freeDiskSpaceSamples;
        if (freeDiskSpaceSamples == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"freeDiskSpaceSamples");
        }
        Pair pair = freeDiskSpaceSamples.getLatestSample();
        if (pair != null) {
            Pair pair2 = pair;
            boolean bl = false;
            boolean bl2 = false;
            Pair it = pair2;
            boolean bl3 = false;
            Pair pair3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)pair3, (String)"it");
            string = ((Number)pair3.getSecond()).longValue() < 500000000L ? (String)Localization.INSTANCE.getNotEnoughDiskSpaceForDatabase().invoke() : null;
        } else {
            string = null;
        }
        return string;
    }
}

