/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.maintenance.sitemap;

import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.core.security.BeansKt;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.gaprest.util.AdditionalResource;
import jetbrains.youtrack.maintenance.sitemap.ProjectSitemap;
import jetbrains.youtrack.maintenance.sitemap.SitemapBuilderService;
import jetbrains.youtrack.maintenance.sitemap.YoutrackSitemapIndex;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
@Path(value="/sitemaps")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\b2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0007J\u0012\u0010\f\u001a\u00020\u00062\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ljetbrains/youtrack/maintenance/sitemap/SitemapResource;", "Ljetbrains/youtrack/gaprest/util/AdditionalResource;", "sitemapBuilderService", "Ljetbrains/youtrack/maintenance/sitemap/SitemapBuilderService;", "(Ljetbrains/youtrack/maintenance/sitemap/SitemapBuilderService;)V", "projectSitemap", "", "projectCode", "", "resolvedName", "response", "Ljavax/servlet/http/HttpServletResponse;", "sitemap", "youtrack-maintenance"})
public final class SitemapResource
implements AdditionalResource {
    private final SitemapBuilderService sitemapBuilderService;

    @GET
    @Path(value="/sitemap.xml")
    @Produces(value={"application/xml"})
    public final void sitemap(@Context @NotNull HttpServletResponse response) {
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        YoutrackSitemapIndex index = this.sitemapBuilderService.buildSitemapIndex();
        response.setStatus(200);
        response.setContentType("application/xml");
        ServletOutputStream servletOutputStream = response.getOutputStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)servletOutputStream, (String)"response.outputStream");
        index.serialize((OutputStream)servletOutputStream);
        response.flushBuffer();
    }

    @GET
    @Path(value="/sitemap.{projectCode}-{resolved}.xml")
    @Produces(value={"application/xml"})
    public final void projectSitemap(@PathParam(value="projectCode") @NotNull String projectCode, @PathParam(value="resolved") @NotNull String resolvedName, @Context @NotNull HttpServletResponse response) {
        String project;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)projectCode, (String)"projectCode");
        Intrinsics.checkParameterIsNotNull((Object)resolvedName, (String)"resolvedName");
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        Entity entity2 = BeansKt.getSecurity().getGuest();
        Intrinsics.checkExpressionValueIsNotNull((Object)entity2, (String)"security.guest");
        Entity guest = entity2;
        String string2 = projectCode;
        XdProject.Companion companion = XdProject.Companion;
        boolean bl = false;
        String string3 = string2.toUpperCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
        String string4 = string3;
        XdProject xdProject = companion.findByKey(string4);
        if (xdProject != null) {
            string2 = xdProject;
            bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            string = BeansKt.getSecurity().hasPermission(guest, Permission.READ_ISSUE, it.getEntity()) ? string2 : null;
        } else {
            string = project = null;
        }
        if (project == null) {
            throw (Throwable)new NotFoundException();
        }
        ProjectSitemap projectSitemap = this.sitemapBuilderService.buildProjectSitemap((XdProject)project, resolvedName);
        response.setStatus(200);
        response.setContentType("application/xml");
        ServletOutputStream servletOutputStream = response.getOutputStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)servletOutputStream, (String)"response.outputStream");
        projectSitemap.serialize((OutputStream)servletOutputStream);
        response.flushBuffer();
    }

    public SitemapResource(@NotNull SitemapBuilderService sitemapBuilderService) {
        Intrinsics.checkParameterIsNotNull((Object)sitemapBuilderService, (String)"sitemapBuilderService");
        this.sitemapBuilderService = sitemapBuilderService;
    }
}

