/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.maintenance.updates;

import java.util.Map;
import jetbrains.charisma.main.CharismaLicenseChecker;
import jetbrains.charisma.main.ConfigurationParameter;
import jetbrains.charisma.main.ConfigurationUtil;
import jetbrains.charisma.persistent.UserActionJobContainer;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.misc.UpdateCheckResult;
import jetbrains.youtrack.api.misc.UpdateChecker;
import jetbrains.youtrack.api.webr.LocalScoped;
import jetbrains.youtrack.config.BeansKt;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.maintenance.updates.Build;
import jetbrains.youtrack.maintenance.updates.Channel;
import jetbrains.youtrack.maintenance.updates.ChannelStatus;
import jetbrains.youtrack.maintenance.updates.UpdateCheckerImpl;
import jetbrains.youtrack.maintenance.updates.UpdateRest;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import webr.framework.controller.CentralManager;

@LocalScoped
@Service(value="updateChecker")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0014\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J.\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0005R\u0012\u0010\u0007\u001a\u00020\b8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u00108\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ljetbrains/youtrack/maintenance/updates/UpdateCheckerImpl;", "Ljetbrains/youtrack/api/misc/UpdateChecker;", "()V", "isChecking", "", "()Z", "isUpdateCheckRequired", "jobContainer", "Ljetbrains/charisma/persistent/UserActionJobContainer;", "recentResult", "Ljetbrains/youtrack/api/misc/UpdateCheckResult;", "getRecentResult", "()Ljetbrains/youtrack/api/misc/UpdateCheckResult;", "setRecentResult", "(Ljetbrains/youtrack/api/misc/UpdateCheckResult;)V", "updateRest", "Ljetbrains/youtrack/maintenance/updates/UpdateRest;", "checkForUpdate", "", "newParams", "", "", "pairOf", "Lkotlin/Pair;", "key", "value", "", "undefinedValue", "Companion", "youtrack-maintenance"})
public final class UpdateCheckerImpl
implements UpdateChecker {
    @Autowired
    private UpdateRest updateRest;
    @Autowired
    private UserActionJobContainer jobContainer;
    @NotNull
    private volatile UpdateCheckResult recentResult = UpdateCheckResult.Companion.notAvailable();
    @NotNull
    public static final String jobName = "Check for update";
    @NotNull
    public static final String productCode = "JT";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public UpdateCheckResult getRecentResult() {
        return this.recentResult;
    }

    public void setRecentResult(@NotNull UpdateCheckResult updateCheckResult) {
        Intrinsics.checkParameterIsNotNull((Object)updateCheckResult, (String)"<set-?>");
        this.recentResult = updateCheckResult;
    }

    public boolean isUpdateCheckRequired() {
        return !ConfigurationUtil.isYoutrackHosted() && !Intrinsics.areEqual((Object)"true", (Object)ConfigurationParameter.getParameter((String)"jetbrains.youtrack.disableCheckForUpdate"));
    }

    public void checkForUpdate() {
        UserActionJobContainer userActionJobContainer = this.jobContainer;
        if (userActionJobContainer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"jobContainer");
        }
        userActionJobContainer.getOrCreateJob(new Runnable(this){
            final /* synthetic */ UpdateCheckerImpl this$0;

            public final void run() {
                UpdateCheckResult updateCheckResult;
                try {
                    UpdateCheckResult updateCheckResult2;
                    Channel channel = UpdateCheckerImpl.access$getUpdateRest$p(this.this$0).getNewerBuild("JT", ChannelStatus.RELEASE, UpdateCheckerImpl.access$newParams(this.this$0));
                    if (channel != null) {
                        Build build = channel.getBuild();
                        Build build2 = channel.getBuild();
                        updateCheckResult2 = UpdateCheckResult.Companion.available(build != null ? build.getMessage() : null, build2 != null ? build2.getDate() : null, channel.getUrl());
                    } else {
                        updateCheckResult2 = UpdateCheckResult.Companion.nothingFoundToUpdate();
                    }
                    updateCheckResult = updateCheckResult2;
                }
                catch (Exception e) {
                    updateCheckResult = UpdateCheckResult.Companion.fail(e);
                }
                UpdateCheckResult result = updateCheckResult;
                this.this$0.setRecentResult(result);
            }
            {
                this.this$0 = updateCheckerImpl;
            }
        }, jobName, new Entity[0]);
    }

    private final Map<String, String> newParams() {
        Object[] objectArray = new Pair[10];
        objectArray[0] = this.pairOf("u", CharismaLicenseChecker.getUserCount(), Integer.MAX_VALUE);
        objectArray[1] = this.pairOf("i", CharismaLicenseChecker.getIssueCount(), Long.MAX_VALUE);
        objectArray[2] = this.pairOf("exp", CharismaLicenseChecker.getLicenseExpirationTime(), Long.MAX_VALUE);
        objectArray[3] = this.pairOf("upd", CharismaLicenseChecker.getLicenseFreeUpdateEnd(), Long.MAX_VALUE);
        objectArray[4] = TuplesKt.to((Object)"os", (Object)System.getProperty("os.name", "UNKNOWN"));
        objectArray[5] = TuplesKt.to((Object)"inst", (Object)System.getProperty("jetbrains.youtrack.installation-type", "UNKNOWN"));
        Object object = ServiceLocator.getBean((String)"centralManager");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type webr.framework.controller.CentralManager");
        }
        objectArray[6] = TuplesKt.to((Object)"v", (Object)((CentralManager)object).getAppicationVersion());
        objectArray[7] = TuplesKt.to((Object)"b", (Object)BeansKt.getCentralManager().getAppicationBuild());
        String string = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().getLocale().toLanguageTag();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.locale.toLanguageTag()");
        objectArray[8] = TuplesKt.to((Object)"lang", (Object)StringsKt.replace$default((String)string, (String)"-", (String)"_", (boolean)false, (int)4, null));
        objectArray[9] = TuplesKt.to((Object)"uuid", (Object)LegacySupportKt.transactional((Function1)newParams.1.INSTANCE));
        return MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray));
    }

    private final Pair<String, String> pairOf(String key, long value, long undefinedValue) {
        if (value != undefinedValue) {
            return TuplesKt.to((Object)key, (Object)String.valueOf(value));
        }
        return null;
    }

    public boolean isChecking() {
        UserActionJobContainer userActionJobContainer = this.jobContainer;
        if (userActionJobContainer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"jobContainer");
        }
        return userActionJobContainer.hasGlobalJob(jobName);
    }

    public static final /* synthetic */ UpdateRest access$getUpdateRest$p(UpdateCheckerImpl $this) {
        UpdateRest updateRest = $this.updateRest;
        if (updateRest == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"updateRest");
        }
        return updateRest;
    }

    public static final /* synthetic */ void access$setUpdateRest$p(UpdateCheckerImpl $this, UpdateRest updateRest) {
        $this.updateRest = updateRest;
    }

    public static final /* synthetic */ Map access$newParams(UpdateCheckerImpl $this) {
        return $this.newParams();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ljetbrains/youtrack/maintenance/updates/UpdateCheckerImpl$Companion;", "", "()V", "jobName", "", "productCode", "youtrack-maintenance"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

