/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.analyzer;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.exodus.core.execution.Job;
import jetbrains.youtrack.api.events.Event;
import jetbrains.youtrack.api.events.EventMerge;
import jetbrains.youtrack.notifications.analyzer.AnalyzerJobFactory;
import jetbrains.youtrack.notifications.analyzer.EventMergeAccumulator;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="eventMergeAnalyzer")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R'\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Ljetbrains/youtrack/notifications/analyzer/EventMergeAnalyzer;", "", "()V", "factories", "", "Ljetbrains/youtrack/notifications/analyzer/AnalyzerJobFactory;", "factoriesByType", "", "", "getFactoriesByType", "()Ljava/util/Map;", "factoriesByType$delegate", "Lkotlin/Lazy;", "analyze", "Ljetbrains/exodus/core/execution/Job;", "merge", "Ljetbrains/youtrack/api/events/EventMerge;", "hasNoNotifiableEvents", "", "isSilent", "youtrack-notifications"})
public final class EventMergeAnalyzer {
    @Autowired
    private List<? extends AnalyzerJobFactory> factories;
    private final Lazy factoriesByType$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, ? extends AnalyzerJobFactory>>(this){
        final /* synthetic */ EventMergeAnalyzer this$0;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<String, AnalyzerJobFactory> invoke() {
            void $this$associateByTo$iv$iv;
            Iterable $this$associateBy$iv = EventMergeAnalyzer.access$getFactories$p(this.this$0);
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (T element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                AnalyzerJobFactory analyzerJobFactory = (AnalyzerJobFactory)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                String string = it.getContainerEntityType();
                map2.put(string, element$iv$iv);
            }
            return destination$iv$iv;
        }
        {
            this.this$0 = eventMergeAnalyzer;
            super(0);
        }
    }));

    private final Map<String, AnalyzerJobFactory> getFactoriesByType() {
        Lazy lazy = this.factoriesByType$delegate;
        EventMergeAnalyzer eventMergeAnalyzer = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Map)lazy.getValue();
    }

    @Nullable
    public final Job analyze(@NotNull EventMerge merge2) {
        Intrinsics.checkParameterIsNotNull((Object)merge2, (String)"merge");
        if (this.isSilent(merge2)) {
            return null;
        }
        if (this.hasNoNotifiableEvents(merge2)) {
            return null;
        }
        String string = merge2.getContainer().getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"merge.container.type");
        String containerType = string;
        AnalyzerJobFactory analyzerJobFactory = this.getFactoriesByType().get(containerType);
        if (analyzerJobFactory == null) {
            throw (Throwable)new IllegalArgumentException("Cannot find analyzer job factory for " + containerType);
        }
        AnalyzerJobFactory factory = analyzerJobFactory;
        return factory.createAnalyzerJob(merge2);
    }

    private final boolean isSilent(EventMerge merge2) {
        boolean bl;
        block3: {
            byte silentApplyMarkerId = BeansKt.getSilentApplyEventMarker().getId();
            byte adminActionMarkerId = BeansKt.getSystemApplyEventMarker().getId();
            Iterable $this$all$iv = merge2.getEvents();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Event it = (Event)element$iv;
                    boolean bl2 = false;
                    if (it.getMarker() == silentApplyMarkerId || it.getMarker() == adminActionMarkerId) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean hasNoNotifiableEvents(EventMerge merge2) {
        return new EventMergeAccumulator(merge2).getMask() == 0;
    }

    public static final /* synthetic */ List access$getFactories$p(EventMergeAnalyzer $this) {
        List<? extends AnalyzerJobFactory> list = $this.factories;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"factories");
        }
        return list;
    }

    public static final /* synthetic */ void access$setFactories$p(EventMergeAnalyzer $this, List list) {
        $this.factories = list;
    }
}

