/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.awsses;

import com.sun.mail.smtp.SMTPTransport;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Message;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import jetbrains.charisma.main.ConfigurationParameter;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.mail.MailAuthenticationException;
import org.springframework.mail.MailSendException;
import org.springframework.mail.javamail.JavaMailSenderImpl;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J+\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000eH\u0014\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ljetbrains/youtrack/notifications/awsses/AwsSesAwareJavaMailSender;", "Lorg/springframework/mail/javamail/JavaMailSenderImpl;", "()V", "isAwsSes", "", "captureMessageId", "", "message", "Ljavax/mail/internet/MimeMessage;", "transport", "Ljavax/mail/Transport;", "doSend", "", "mimeMessages", "", "originalMessages", "", "([Ljavax/mail/internet/MimeMessage;[Ljava/lang/Object;)V", "Companion", "youtrack-notifications"})
public final class AwsSesAwareJavaMailSender
extends JavaMailSenderImpl {
    private final boolean isAwsSes = ConfigurationParameter.getParameter((String)"jetbrains.youtrack.awsses.configuration") != null;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doSend(@NotNull MimeMessage[] mimeMessages, @Nullable Object[] originalMessages) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)mimeMessages, (String)"mimeMessages");
        Map failedMessages = new LinkedHashMap();
        Transport transport = null;
        try {
            int n2 = 0;
            n = mimeMessages.length;
            while (n2 < n) {
                void i;
                if (transport == null || !transport.isConnected()) {
                    if (transport != null) {
                        try {
                            transport.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        transport = null;
                    }
                    try {
                        transport = this.connectTransport();
                    }
                    catch (AuthenticationFailedException ex) {
                        throw (Throwable)new MailAuthenticationException((Throwable)ex);
                    }
                    catch (Exception ex) {
                        void j = i;
                        while (j < mimeMessages.length) {
                            MimeMessage mimeMessage = originalMessages;
                            if (mimeMessage == null || (mimeMessage = mimeMessage[j]) == null) {
                                mimeMessage = mimeMessages[j];
                            }
                            MimeMessage mimeMessage2 = mimeMessage;
                            failedMessages.put(mimeMessage2, ex);
                            ++j;
                        }
                        throw (Throwable)new MailSendException("Mail server connection failed", (Throwable)ex, failedMessages);
                    }
                }
                MimeMessage mimeMessage = mimeMessages[i];
                try {
                    if (mimeMessage.getSentDate() == null) {
                        mimeMessage.setSentDate(new Date());
                    }
                    String messageId = mimeMessage.getMessageID();
                    mimeMessage.saveChanges();
                    if (messageId != null) {
                        mimeMessage.setHeader("Message-ID", messageId);
                    }
                    Address[] addressArray = mimeMessage.getAllRecipients();
                    Transport transport2 = transport;
                    if (transport2 == null) {
                        Intrinsics.throwNpe();
                    }
                    Message message = (Message)mimeMessage;
                    Address[] addressArray2 = addressArray;
                    if (addressArray == null) {
                        addressArray2 = new Address[]{};
                    }
                    transport2.sendMessage(message, addressArray2);
                    mimeMessage.setHeader("Message-ID", this.captureMessageId(mimeMessage, transport));
                }
                catch (Exception ex) {
                    MimeMessage mimeMessage3 = originalMessages;
                    if (mimeMessage3 == null || (mimeMessage3 = mimeMessage3[i]) == null) {
                        mimeMessage3 = mimeMessage;
                    }
                    MimeMessage mimeMessage4 = mimeMessage3;
                    failedMessages.put(mimeMessage4, ex);
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            try {
                Transport transport3 = transport;
                if (transport3 == null) throw throwable;
                transport3.close();
                throw throwable;
            }
            catch (Exception ex) {
                Map map2 = failedMessages;
                boolean bl = false;
                if (!(!map2.isEmpty())) throw (Throwable)new MailSendException("Failed to close server connection after message sending", (Throwable)ex);
                throw (Throwable)new MailSendException("Failed to close server connection after message failures", (Throwable)ex, failedMessages);
            }
        }
        try {
            Transport transport4 = transport;
            if (transport4 != null) {
                transport4.close();
            }
        }
        catch (Exception ex) {
            Map map3 = failedMessages;
            boolean bl = false;
            if (!(!map3.isEmpty())) throw (Throwable)new MailSendException("Failed to close server connection after message sending", (Throwable)ex);
            throw (Throwable)new MailSendException("Failed to close server connection after message failures", (Throwable)ex, failedMessages);
        }
        Map map4 = failedMessages;
        n = 0;
        if (!(!map4.isEmpty())) return;
        throw (Throwable)new MailSendException(failedMessages);
    }

    private final String captureMessageId(MimeMessage message, Transport transport) {
        if (this.isAwsSes) {
            try {
                Transport transport2 = transport;
                if (transport2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.sun.mail.smtp.SMTPTransport");
                }
                SMTPTransport cfr_ignored_0 = (SMTPTransport)transport2;
                if (((SMTPTransport)transport).getLastReturnCode() == 250) {
                    StringBuilder stringBuilder = new StringBuilder().append('<');
                    String string = ((SMTPTransport)transport).getLastServerResponse();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"transport.lastServerResponse");
                    String string2 = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)string, (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null));
                    StringBuilder stringBuilder2 = stringBuilder;
                    boolean bl = false;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    String string4 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                    return stringBuilder2.append(string4).append("@eu-west-1.amazonses.com>").toString();
                }
            }
            catch (Exception e) {
                Companion.getLogger().warn("Failed to capture message id from AWS SES", (Throwable)e);
            }
        }
        String string = message.getMessageID();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message.messageID");
        return string;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/notifications/awsses/AwsSesAwareJavaMailSender$Companion;", "Lmu/KLogging;", "()V", "youtrack-notifications"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

