/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.controller;

import jetbrains.youtrack.core.persistent.IssueFolderImpl;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.notifications.controller.BeansKt;
import jetbrains.youtrack.notifications.controller.UserDefinedTemplateManager;
import jetbrains.youtrack.notifications.persistence.XdProjectNotificationTemplate;
import jetbrains.youtrack.persistent.listeners.GlobalXdListener;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.query.XdSearchingNode;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J&\u0010\u0007\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0002H\u0016\u00a8\u0006\u000f"}, d2={"Ljetbrains/youtrack/notifications/controller/ProjectNotificationTemplateListener;", "Ljetbrains/youtrack/persistent/listeners/GlobalXdListener;", "Ljetbrains/youtrack/notifications/persistence/XdProjectNotificationTemplate;", "()V", "addedSync", "", "added", "log", "id", "", "content", "p", "Ljetbrains/youtrack/core/persistent/issue/XdProject;", "removedAsync", "removed", "youtrack-notifications"})
public class ProjectNotificationTemplateListener
extends GlobalXdListener<XdProjectNotificationTemplate> {
    public void addedSync(@NotNull XdProjectNotificationTemplate added) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)added), (String)"added");
        BeansKt.getNotificationConfigurationProvider().addProject(added.getProject());
    }

    public void removedAsync(@NotNull XdProjectNotificationTemplate removed2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)removed2), (String)"removed");
        XdProject project = removed2.getProject();
        if (project.isRemoved()) {
            UserDefinedTemplateManager.Companion.getTEMPLATE_LOG().info("Project " + project.getName() + " is being deleted, hence all custom templates for it will be deleted");
        } else {
            this.log(removed2.getFreemarkerId(), removed2.getContent(), project);
            if (XdQueryKt.isEmpty((XdQuery)XdFilteringQueryKt.filter((XdQuery)XdProjectNotificationTemplate.Companion.all(), (Function2)((Function2)new Function2<FilteringContext, XdProjectNotificationTemplate, XdSearchingNode>(project){
                final /* synthetic */ XdProject $project;

                @NotNull
                public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdProjectNotificationTemplate it) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                    Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                    return $this$filter.eq((XdEntity)it.getProject(), (XdEntity)this.$project);
                }
                {
                    this.$project = xdProject;
                    super(2);
                }
            })))) {
                BeansKt.getNotificationConfigurationProvider().removeProject(project);
            }
        }
    }

    private final void log(String id, String content2, XdProject p) {
        UserDefinedTemplateManager.Companion.getTEMPLATE_LOG().info("--------------------Reset to default-------------------------------");
        Logger logger = UserDefinedTemplateManager.Companion.getTEMPLATE_LOG();
        StringBuilder stringBuilder = new StringBuilder().append("Notification template ").append(id).append(", deleted user defined content for project ");
        Object object = p;
        if (object == null || (object = object.getName()) == null) {
            object = IssueFolderImpl.getNullName();
        }
        logger.info(stringBuilder.append((String)object).toString());
        UserDefinedTemplateManager.Companion.getTEMPLATE_LOG().info("-------------------------------------------------------------------");
        UserDefinedTemplateManager.Companion.getTEMPLATE_LOG().info(content2);
    }
}

