/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.data;

import jetbrains.youtrack.api.notifications.NotificationCase;
import jetbrains.youtrack.api.notifications.NotificationData;
import jetbrains.youtrack.notifications.data.NotificationJSON;
import jetbrains.youtrack.notifications.data.NotificationJsonFactory;
import jetbrains.youtrack.notifications.persistence.UserNotificationExtension;
import jetbrains.youtrack.notifications.persistence.XdNotification;
import jetbrains.youtrack.notifications.persistence.XdUserNotification;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Ljetbrains/youtrack/notifications/data/IssueNotificationJsonFactory;", "Ljetbrains/youtrack/notifications/data/NotificationJsonFactory;", "()V", "issueNotificationExtension", "Ljetbrains/youtrack/notifications/persistence/UserNotificationExtension;", "metadataJsonClass", "Ljava/lang/Class;", "getMetadataJsonClass", "()Ljava/lang/Class;", "metadataJsonType", "", "getMetadataJsonType", "()Ljava/lang/String;", "createMetadataJson", "Ljetbrains/youtrack/notifications/data/NotificationJSON;", "data", "Ljetbrains/youtrack/api/notifications/NotificationData;", "isApplicable", "", "notification", "Ljetbrains/youtrack/notifications/persistence/XdNotification;", "youtrack-notifications"})
public final class IssueNotificationJsonFactory
implements NotificationJsonFactory {
    @Autowired
    private UserNotificationExtension issueNotificationExtension;

    @Override
    @NotNull
    public Class<?> getMetadataJsonClass() {
        return NotificationJSON.class;
    }

    @Override
    @NotNull
    public String getMetadataJsonType() {
        return "issue";
    }

    @Override
    @NotNull
    public NotificationJSON createMetadataJson(@NotNull NotificationData data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return new NotificationJSON(data);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicable(@NotNull XdNotification notification) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)notification), (String)"notification");
        if (!(notification instanceof XdUserNotification)) return false;
        UserNotificationExtension userNotificationExtension = this.issueNotificationExtension;
        if (userNotificationExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"issueNotificationExtension");
        }
        if (!userNotificationExtension.isApplicable((XdUserNotification)notification)) return false;
        NotificationCase notificationCase = ((XdUserNotification)notification).getCase();
        if (notificationCase == null) return false;
        if (!notificationCase.isDataPersistable()) return false;
        return true;
    }
}

