/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.data;

import java.util.List;
import jetbrains.youtrack.api.events.Event;
import jetbrains.youtrack.api.events.EventMerge;
import jetbrains.youtrack.api.notifications.NotificationData;
import jetbrains.youtrack.api.notifications.NotificationIssueAdapter;
import jetbrains.youtrack.api.notifications.NotificationPropertiesKt;
import jetbrains.youtrack.api.notifications.NotificationReason;
import jetbrains.youtrack.event.merge.EventMergeImpl;
import jetbrains.youtrack.event.rollback.DebugInfoMethodsKt;
import jetbrains.youtrack.notifications.analyzer.EventMergeAccumulator;
import jetbrains.youtrack.notifications.data.NotificationIssueDeserializer;
import jetbrains.youtrack.notifications.data.NotificationPropertyDeserializer;
import jetbrains.youtrack.notifications.data.change.IssueChangeAdapterFactory;
import jetbrains.youtrack.notifications.data.change.NotificationChangeAdapter;
import jetbrains.youtrack.notifications.persistence.IssueNotificationExtensionKt;
import jetbrains.youtrack.notifications.persistence.UserNotificationExtension;
import jetbrains.youtrack.notifications.persistence.XdUserNotification;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0003\u001a\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u00078\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ljetbrains/youtrack/notifications/data/NotificationIssueChangeDeserializer;", "Ljetbrains/youtrack/notifications/data/NotificationPropertyDeserializer;", "()V", "launchAfter", "getLaunchAfter", "()Ljetbrains/youtrack/notifications/data/NotificationPropertyDeserializer;", "notificationIssueDeserializer", "Ljetbrains/youtrack/notifications/data/NotificationIssueDeserializer;", "deserializeAndSet", "", "data", "Ljetbrains/youtrack/api/notifications/NotificationData;", "notification", "Ljetbrains/youtrack/notifications/persistence/XdUserNotification;", "youtrack-notifications"})
public final class NotificationIssueChangeDeserializer
implements NotificationPropertyDeserializer {
    @Autowired
    private NotificationIssueDeserializer notificationIssueDeserializer;

    @Override
    @NotNull
    public NotificationPropertyDeserializer getLaunchAfter() {
        NotificationIssueDeserializer notificationIssueDeserializer = this.notificationIssueDeserializer;
        if (notificationIssueDeserializer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"notificationIssueDeserializer");
        }
        return notificationIssueDeserializer;
    }

    @Override
    public void deserializeAndSet(@NotNull NotificationData data, @NotNull XdUserNotification notification) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)((Object)notification), (String)"notification");
        UserNotificationExtension extension = IssueNotificationExtensionKt.getIssueNotificationExtension();
        if (!extension.isApplicable(notification)) {
            return;
        }
        NotificationIssueAdapter notificationIssueAdapter = (NotificationIssueAdapter)data.get(NotificationPropertiesKt.getIssueNotificationProperty());
        if (notificationIssueAdapter == null) {
            throw (Throwable)new IllegalArgumentException('[' + notification.getXdId() + "] does not contain issue property");
        }
        NotificationIssueAdapter issueSnapshot = notificationIssueAdapter;
        NotificationReason notificationReason = (NotificationReason)data.get(jetbrains.youtrack.notifications.main.NotificationPropertiesKt.getReasonNotificationProperty());
        if (notificationReason == null) {
            throw (Throwable)new IllegalArgumentException('[' + notification.getXdId() + "] does not contain reason");
        }
        NotificationReason recipientReason = notificationReason;
        Boolean bl = (Boolean)data.get(jetbrains.youtrack.notifications.main.NotificationPropertiesKt.getLastNotificationNotificationProperty());
        boolean recipientLostAccess = bl != null ? bl : false;
        List events = SequencesKt.toList(extension.readEvents(notification));
        EventMergeAccumulator mergeAccumulator = new EventMergeAccumulator((EventMerge)new EventMergeImpl(events));
        NotificationChangeAdapter issueChange = new IssueChangeAdapterFactory(issueSnapshot).createChangeAdapter(mergeAccumulator, notification.getRecipient(), recipientReason, recipientLostAccess);
        if (issueChange == null) {
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuilder $this$buildString = stringBuilder;
            boolean bl5 = false;
            $this$buildString.append('[' + notification.getXdId() + "] has no notifiable events:\n");
            Iterable $this$forEach$iv = events;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Event it = (Event)element$iv;
                boolean bl6 = false;
                $this$buildString.append("\t").append(DebugInfoMethodsKt.getDebugInfo((Event)it)).append("\n");
            }
            String string = stringBuilder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            String noNotifiableEventsMessage = string;
            throw (Throwable)new IllegalArgumentException(noNotifiableEventsMessage);
        }
        data.set(jetbrains.youtrack.notifications.main.NotificationPropertiesKt.getChangeNotificationProperty(), (Object)issueChange);
    }
}

