/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.data;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.PostConstruct;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.api.notifications.NotificationCase;
import jetbrains.youtrack.api.notifications.NotificationData;
import jetbrains.youtrack.api.notifications.NotificationDataProperty;
import jetbrains.youtrack.api.notifications.NotificationPropertiesKt;
import jetbrains.youtrack.api.notifications.NotificationReason;
import jetbrains.youtrack.api.notifications.SerializableNotificationDataProperty;
import jetbrains.youtrack.api.notifications.SerializableNotificationPropertiesKt;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.notifications.NotificationServiceKt;
import jetbrains.youtrack.notifications.data.NotificationJsonFactory;
import jetbrains.youtrack.notifications.data.NotificationPropertyDeserializer;
import jetbrains.youtrack.notifications.data.NotificationPropertyDeserializerKt;
import jetbrains.youtrack.notifications.data.NotificationRenderingJSON;
import jetbrains.youtrack.notifications.data.NotificationsDataMapper$readPreRenderedNotification$metadataJsonRaw$1;
import jetbrains.youtrack.notifications.data.NotificationsDataMapper$readPreRenderedNotification$renderingJsonRaw$1;
import jetbrains.youtrack.notifications.data.NotificationsDataMapper$toJson$jsonContent$1;
import jetbrains.youtrack.notifications.data.NotificationsDataMapper$write$1;
import jetbrains.youtrack.notifications.data.NotificationsDataMapper$write$2;
import jetbrains.youtrack.notifications.data.NotificationsDataMapper$write$3;
import jetbrains.youtrack.notifications.data.PreRenderedNotificationJSON;
import jetbrains.youtrack.notifications.data.ProjectJSON;
import jetbrains.youtrack.notifications.data.RootNotification;
import jetbrains.youtrack.notifications.main.NotificationDataImpl;
import jetbrains.youtrack.notifications.persistence.XdNotification;
import jetbrains.youtrack.notifications.persistence.XdOpenNotification;
import jetbrains.youtrack.notifications.persistence.XdUserNotification;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KMutableProperty1;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.util.IdsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="notificationsDataMapper")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 52\u00020\u0001:\u00015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0002J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\u0016H\u0002J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J5\u0010\u001d\u001a\u0004\u0018\u00010\u0016\"\b\b\u0000\u0010\u001e*\u00020\u001f2\u0006\u0010\u0013\u001a\u0002H\u001e2\u0014\u0010 \u001a\u0010\u0012\u0004\u0012\u0002H\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u00160!\u00a2\u0006\u0002\u0010\"J\u0010\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020(H\u0007J\u0010\u0010)\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u0016\u0010*\u001a\u00020(2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\u001bJ=\u0010,\u001a\u00020(\"\b\b\u0000\u0010\u001e*\u00020\u001f2\u0006\u0010\u0013\u001a\u0002H\u001e2\u0014\u0010 \u001a\u0010\u0012\u0004\u0012\u0002H\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u00160!2\b\u0010-\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\u0002\u0010.J\u0010\u0010/\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016H\u0002J\u001a\u00100\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u000101*\u00020&H\u0002J\u0016\u00102\u001a\u0004\u0018\u00010\u0016*\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u00103\u001a\u0004\u0018\u00010\u0016*\u00020\u001bH\u0002J\u000e\u00104\u001a\u0004\u0018\u00010\u0016*\u00020\u001bH\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Ljetbrains/youtrack/notifications/data/NotificationsDataMapper;", "", "()V", "defaultJsonFactory", "Ljetbrains/youtrack/notifications/data/NotificationJsonFactory;", "getDefaultJsonFactory", "()Ljetbrains/youtrack/notifications/data/NotificationJsonFactory;", "setDefaultJsonFactory", "(Ljetbrains/youtrack/notifications/data/NotificationJsonFactory;)V", "factories", "", "getFactories", "()Ljava/util/List;", "setFactories", "(Ljava/util/List;)V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "typeAwareMapper", "findJsonFactory", "notification", "Ljetbrains/youtrack/notifications/persistence/XdNotification;", "nullableUnzip", "", "blob", "nullableZip", "jsonContent", "read", "Ljetbrains/youtrack/api/notifications/NotificationData;", "readPreRenderedNotification", "readRaw", "T", "Lkotlinx/dnq/XdEntity;", "property", "Lkotlin/reflect/KMutableProperty1;", "(Lkotlinx/dnq/XdEntity;Lkotlin/reflect/KMutableProperty1;)Ljava/lang/String;", "readReason", "Ljetbrains/youtrack/api/notifications/NotificationReason;", "readUserNotification", "Ljetbrains/youtrack/notifications/persistence/XdUserNotification;", "registerSubtypes", "", "unzip", "write", "data", "writeRaw", "content", "(Lkotlinx/dnq/XdEntity;Lkotlin/reflect/KMutableProperty1;Ljava/lang/String;)V", "zip", "toJson", "Ljava/util/HashMap;", "toMetadataJsonRaw", "toNotificationDataJsonRaw", "toRenderingJsonRaw", "Companion", "youtrack-notifications"})
public final class NotificationsDataMapper {
    @Autowired
    @Qualifier(value="messageNotificationJsonFactory")
    @NotNull
    public NotificationJsonFactory defaultJsonFactory;
    @Autowired
    @NotNull
    public List<? extends NotificationJsonFactory> factories;
    private final ObjectMapper mapper;
    private final ObjectMapper typeAwareMapper;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final NotificationJsonFactory getDefaultJsonFactory() {
        NotificationJsonFactory notificationJsonFactory = this.defaultJsonFactory;
        if (notificationJsonFactory == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"defaultJsonFactory");
        }
        return notificationJsonFactory;
    }

    public final void setDefaultJsonFactory(@NotNull NotificationJsonFactory notificationJsonFactory) {
        Intrinsics.checkParameterIsNotNull((Object)notificationJsonFactory, (String)"<set-?>");
        this.defaultJsonFactory = notificationJsonFactory;
    }

    @NotNull
    public final List<NotificationJsonFactory> getFactories() {
        List<NotificationJsonFactory> list = this.factories;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"factories");
        }
        return list;
    }

    public final void setFactories(@NotNull List<? extends NotificationJsonFactory> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.factories = list;
    }

    @PostConstruct
    public final void registerSubtypes() {
        List<? extends NotificationJsonFactory> list = this.factories;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"factories");
        }
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NotificationJsonFactory factory = (NotificationJsonFactory)element$iv;
            boolean bl = false;
            NamedType namedType = new NamedType(factory.getMetadataJsonClass(), factory.getMetadataJsonType());
            boolean bl2 = false;
            boolean bl3 = false;
            NamedType namedType2 = namedType;
            boolean bl4 = false;
            this.mapper.registerSubtypes(new NamedType[]{namedType2});
            this.typeAwareMapper.registerSubtypes(new NamedType[]{namedType2});
        }
    }

    private final NotificationJsonFactory findJsonFactory(XdNotification notification) {
        NotificationJsonFactory notificationJsonFactory;
        Object v1;
        block3: {
            List<? extends NotificationJsonFactory> list = this.factories;
            if (list == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"factories");
            }
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                NotificationJsonFactory factory = (NotificationJsonFactory)element$iv;
                boolean bl = false;
                if (!factory.isApplicable(notification)) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        if ((notificationJsonFactory = (NotificationJsonFactory)v1) == null && (notificationJsonFactory = this.defaultJsonFactory) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"defaultJsonFactory");
        }
        return notificationJsonFactory;
    }

    public final <T extends XdEntity> void writeRaw(@NotNull T notification, @NotNull KMutableProperty1<T, String> property, @Nullable String content2) {
        Intrinsics.checkParameterIsNotNull(notification, (String)"notification");
        Intrinsics.checkParameterIsNotNull(property, (String)"property");
        property.set(notification, (Object)this.nullableZip(content2));
    }

    @Nullable
    public final <T extends XdEntity> String readRaw(@NotNull T notification, @NotNull KMutableProperty1<T, String> property) {
        Intrinsics.checkParameterIsNotNull(notification, (String)"notification");
        Intrinsics.checkParameterIsNotNull(property, (String)"property");
        return this.nullableUnzip((String)property.get(notification));
    }

    public final void write(@NotNull XdNotification notification, @NotNull NotificationData data) {
        XdUserNotification xdUserNotification;
        Intrinsics.checkParameterIsNotNull((Object)((Object)notification), (String)"notification");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        XdNotification xdNotification = notification;
        if (!(xdNotification instanceof XdUserNotification)) {
            xdNotification = null;
        }
        boolean canPersistData = (xdUserNotification = (XdUserNotification)xdNotification) != null && (xdUserNotification = xdUserNotification.getCase()) != null ? xdUserNotification.isDataPersistable() : false;
        String metadataJsonRaw2 = this.toMetadataJsonRaw(data, notification);
        this.writeRaw((XdEntity)notification, NotificationsDataMapper$write$1.INSTANCE, metadataJsonRaw2);
        if (canPersistData && notification instanceof XdUserNotification) {
            String notificationDataJsonRaw = this.toNotificationDataJsonRaw(data);
            this.writeRaw((XdEntity)notification, NotificationsDataMapper$write$2.INSTANCE, notificationDataJsonRaw);
        }
        if (!canPersistData || notification instanceof XdOpenNotification) {
            String renderedDataJsonRaw = this.toRenderingJsonRaw(data);
            this.writeRaw((XdEntity)notification, NotificationsDataMapper$write$3.INSTANCE, renderedDataJsonRaw);
        }
    }

    private final String toMetadataJsonRaw(@NotNull NotificationData $this$toMetadataJsonRaw, XdNotification notification) {
        NotificationJsonFactory factory = this.findJsonFactory(notification);
        RootNotification json = factory.createMetadataJson($this$toMetadataJsonRaw);
        return this.mapper.writeValueAsString((Object)json);
    }

    /*
     * WARNING - void declaration
     */
    private final String toNotificationDataJsonRaw(@NotNull NotificationData $this$toNotificationDataJsonRaw) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = SerializableNotificationPropertiesKt.getSerializableNotificationProperties();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            SerializableNotificationDataProperty p = (SerializableNotificationDataProperty)element$iv$iv;
            boolean bl2 = false;
            if ($this$toNotificationDataJsonRaw.get((NotificationDataProperty)p) != null) {
                Object object;
                boolean bl3 = false;
                boolean bl4 = false;
                Object it = object;
                boolean bl5 = false;
                pair = TuplesKt.to((Object)p.getName(), (Object)p.getAndSerialize($this$toNotificationDataJsonRaw));
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair pair2 = pair;
            boolean bl6 = false;
            boolean bl7 = false;
            Pair it$iv$iv = pair2;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map notificationData = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        return this.typeAwareMapper.writeValueAsString((Object)notificationData);
    }

    private final String toRenderingJsonRaw(@NotNull NotificationData $this$toRenderingJsonRaw) {
        NotificationRenderingJSON json = new NotificationRenderingJSON($this$toRenderingJsonRaw);
        return this.mapper.writeValueAsString((Object)json);
    }

    @NotNull
    public final NotificationData read(@NotNull XdNotification notification) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)notification), (String)"notification");
        XdNotification xdNotification = notification;
        if (!(xdNotification instanceof XdUserNotification)) {
            xdNotification = null;
        }
        XdUserNotification xdUserNotification = (XdUserNotification)xdNotification;
        String data = xdUserNotification != null ? xdUserNotification.getNotificationData() : null;
        CharSequence charSequence = data;
        boolean bl = false;
        boolean bl2 = false;
        return charSequence == null || charSequence.length() == 0 ? this.readPreRenderedNotification(notification) : this.readUserNotification((XdUserNotification)notification);
    }

    @Nullable
    public final NotificationReason readReason(@NotNull XdNotification notification) {
        NotificationReason notificationReason;
        Intrinsics.checkParameterIsNotNull((Object)((Object)notification), (String)"notification");
        XdNotification xdNotification = notification;
        if (!(xdNotification instanceof XdUserNotification)) {
            xdNotification = null;
        }
        XdUserNotification xdUserNotification = (XdUserNotification)xdNotification;
        String notificationData = xdUserNotification != null ? xdUserNotification.getNotificationData() : null;
        CharSequence charSequence = notificationData;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            notificationReason = null;
        } else {
            HashMap<String, Object> json = this.toJson((XdUserNotification)notification);
            NotificationDataImpl data = new NotificationDataImpl();
            NotificationDataProperty<NotificationReason> notificationDataProperty = jetbrains.youtrack.notifications.main.NotificationPropertiesKt.getReasonNotificationProperty();
            if (notificationDataProperty == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.api.notifications.SerializableNotificationDataProperty<jetbrains.youtrack.api.notifications.NotificationReason, *>");
            }
            SerializableNotificationDataProperty prop = (SerializableNotificationDataProperty)notificationDataProperty;
            Object object = json.get(prop.getName());
            if (object != null) {
                Object object2 = object;
                boolean bl3 = false;
                boolean bl4 = false;
                Object value2 = object2;
                boolean bl5 = false;
                NotificationData notificationData2 = data;
                Object object3 = value2;
                Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"value");
                prop.deserializeAndSet(notificationData2, object3);
            }
            notificationReason = (NotificationReason)data.get((NotificationDataProperty)prop);
        }
        return notificationReason;
    }

    private final NotificationData readPreRenderedNotification(XdNotification notification) {
        NotificationRenderingJSON notificationRenderingJSON;
        boolean bl;
        boolean bl2;
        Object object;
        String renderingJsonRaw2;
        String metadataJsonRaw2 = this.readRaw((XdEntity)notification, NotificationsDataMapper$readPreRenderedNotification$metadataJsonRaw$1.INSTANCE);
        PreRenderedNotificationJSON metadataJson = (PreRenderedNotificationJSON)this.mapper.readValue(metadataJsonRaw2, PreRenderedNotificationJSON.class);
        String string = renderingJsonRaw2 = this.readRaw((XdEntity)notification, NotificationsDataMapper$readPreRenderedNotification$renderingJsonRaw$1.INSTANCE);
        if (string != null) {
            object = string;
            bl2 = false;
            bl = false;
            String it = object;
            boolean bl3 = false;
            notificationRenderingJSON = (NotificationRenderingJSON)this.mapper.readValue(renderingJsonRaw2, NotificationRenderingJSON.class);
        } else {
            notificationRenderingJSON = null;
        }
        NotificationRenderingJSON renderingJson = notificationRenderingJSON;
        object = new NotificationDataImpl();
        bl2 = false;
        bl = false;
        Object $this$apply = object;
        boolean bl4 = false;
        ((NotificationDataImpl)$this$apply).set(NotificationPropertiesKt.getHeaderNotificationProperty(), metadataJson.getHeader());
        ProjectJSON projectJSON = metadataJson.getProject();
        if (projectJSON != null) {
            ProjectJSON projectJSON2 = projectJSON;
            boolean bl5 = false;
            boolean bl6 = false;
            ProjectJSON it = projectJSON2;
            boolean bl7 = false;
            Entity project = ((XdProject)IdsKt.findById((XdEntityType)((XdEntityType)XdProject.Companion), (String)it.getEntityId())).getEntity();
            ((NotificationDataImpl)$this$apply).set(NotificationPropertiesKt.getProjectNotificationProperty(), project);
        }
        NotificationDataProperty<String> notificationDataProperty = jetbrains.youtrack.notifications.main.NotificationPropertiesKt.getSubjectNotificationProperty();
        Object object2 = renderingJson;
        if (object2 == null || (object2 = ((NotificationRenderingJSON)object2).getSubject()) == null) {
            object2 = metadataJson.getSubject();
        }
        ((NotificationDataImpl)$this$apply).set(notificationDataProperty, object2);
        NotificationDataProperty<String> notificationDataProperty2 = jetbrains.youtrack.notifications.main.NotificationPropertiesKt.getHtmlBodyNotificationProperty();
        Object object3 = renderingJson;
        if (object3 == null || (object3 = ((NotificationRenderingJSON)object3).getHtmlBody()) == null) {
            object3 = metadataJson.getBody();
        }
        ((NotificationDataImpl)$this$apply).set(notificationDataProperty2, object3);
        NotificationDataProperty<String> notificationDataProperty3 = jetbrains.youtrack.notifications.main.NotificationPropertiesKt.getTextBodyNotificationProperty();
        Object object4 = renderingJson;
        if (object4 == null || (object4 = ((NotificationRenderingJSON)object4).getTextBody()) == null) {
            object4 = metadataJson.getText();
        }
        ((NotificationDataImpl)$this$apply).set(notificationDataProperty3, object4);
        return (NotificationData)object;
    }

    private final NotificationData readUserNotification(XdUserNotification notification) {
        HashMap<String, Object> json = this.toJson(notification);
        NotificationCase notificationCase = notification.getCase();
        if (notificationCase == null) {
            throw (Throwable)new IllegalArgumentException("No case name provided");
        }
        NotificationCase notificationCase2 = notificationCase;
        NotificationData notificationData = NotificationServiceKt.getNotificationService().createData(notificationCase2, notification.getIssue());
        boolean bl = false;
        boolean bl2 = false;
        NotificationData data = notificationData;
        boolean bl3 = false;
        Iterable $this$forEach$iv = SerializableNotificationPropertiesKt.getSerializableNotificationProperties();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            SerializableNotificationDataProperty p = (SerializableNotificationDataProperty)element$iv;
            boolean bl4 = false;
            if (json.get(p.getName()) == null) continue;
            boolean bl5 = false;
            boolean bl6 = false;
            Object jsonValue = object;
            boolean bl7 = false;
            Object object2 = jsonValue;
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"jsonValue");
            p.deserializeAndSet(data, object2);
        }
        $this$forEach$iv = NotificationPropertyDeserializerKt.getDependentDeserializers();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NotificationPropertyDeserializer d = (NotificationPropertyDeserializer)element$iv;
            boolean bl8 = false;
            d.deserializeAndSet(data, notification);
        }
        return notificationData;
    }

    private final HashMap<String, Object> toJson(@NotNull XdUserNotification $this$toJson) {
        TypeReference<HashMap<String, Object>> typeRef2 = new TypeReference<HashMap<String, Object>>(){};
        String jsonContent2 = this.readRaw((XdEntity)$this$toJson, NotificationsDataMapper$toJson$jsonContent$1.INSTANCE);
        Object object = this.typeAwareMapper.readValue(jsonContent2, (TypeReference)typeRef2);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"typeAwareMapper.readValue(jsonContent, typeRef)");
        return (HashMap)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String zip(String jsonContent2) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(jsonContent2.length());
        Closeable closeable = new GZIPOutputStream(out);
        boolean bl = false;
        Throwable throwable = null;
        try {
            GZIPOutputStream it = (GZIPOutputStream)closeable;
            boolean bl2 = false;
            String string = jsonContent2;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
            Charset charset2 = charset;
            GZIPOutputStream gZIPOutputStream = it;
            boolean bl3 = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes(charset2);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            gZIPOutputStream.write(byArray2);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String string = Base64.getEncoder().encodeToString(out.toByteArray());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Base64.getEncoder().enco\u2026String(out.toByteArray())");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String unzip(String blob) {
        byte[] decoded = Base64.getDecoder().decode(blob);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Closeable closeable = new GZIPInputStream(new ByteArrayInputStream(decoded));
        boolean bl = false;
        Throwable throwable = null;
        try {
            GZIPInputStream it = (GZIPInputStream)closeable;
            boolean bl2 = false;
            long l = ByteStreamsKt.copyTo$default((InputStream)it, (OutputStream)out, (int)0, (int)2, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String string = out.toString(StandardCharsets.UTF_8.displayName());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"out.toString(StandardCharsets.UTF_8.displayName())");
        return string;
    }

    private final String nullableZip(String jsonContent2) {
        String string;
        String string2 = jsonContent2;
        boolean bl = false;
        boolean bl2 = false;
        String it = string2;
        boolean bl3 = false;
        CharSequence charSequence = it;
        boolean bl4 = false;
        boolean bl5 = false;
        String string3 = !(charSequence == null || charSequence.length() == 0) ? string2 : null;
        if (string3 != null) {
            string2 = string3;
            bl = false;
            bl2 = false;
            String safeContent = string2;
            boolean bl6 = false;
            string = this.zip(safeContent);
        } else {
            string = null;
        }
        return string;
    }

    private final String nullableUnzip(String blob) {
        String string;
        String string2 = blob;
        boolean bl = false;
        boolean bl2 = false;
        String it = string2;
        boolean bl3 = false;
        CharSequence charSequence = it;
        boolean bl4 = false;
        boolean bl5 = false;
        String string3 = !(charSequence == null || charSequence.length() == 0) ? string2 : null;
        if (string3 != null) {
            string2 = string3;
            bl = false;
            bl2 = false;
            String safeBlob = string2;
            boolean bl6 = false;
            string = this.unzip(safeBlob);
        } else {
            string = null;
        }
        return string;
    }

    public NotificationsDataMapper() {
        ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new KotlinModule(0, false, false, 7, null)).configure(SerializationFeature.INDENT_OUTPUT, true);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectMapper, (String)"ObjectMapper()\n         \u2026ture.INDENT_OUTPUT, true)");
        this.mapper = objectMapper;
        ObjectMapper objectMapper2 = new ObjectMapper().registerModule((Module)new KotlinModule(0, false, false, 7, null)).configure(SerializationFeature.INDENT_OUTPUT, true).enableDefaultTyping(ObjectMapper.DefaultTyping.JAVA_LANG_OBJECT);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectMapper2, (String)"ObjectMapper()\n         \u2026tTyping.JAVA_LANG_OBJECT)");
        this.typeAwareMapper = objectMapper2;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/notifications/data/NotificationsDataMapper$Companion;", "Lmu/KLogging;", "()V", "youtrack-notifications"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

