/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.data.event;

import jetbrains.exodus.util.ByteUtil;
import jetbrains.youtrack.api.events.Event;
import jetbrains.youtrack.api.events.EventCategory;
import jetbrains.youtrack.api.notifications.EventNotificationAdapter;
import jetbrains.youtrack.api.notifications.EventNotificationMapper;
import jetbrains.youtrack.api.notifications.NotificationReason;
import jetbrains.youtrack.core.watchFolder.RuleType;
import jetbrains.youtrack.notifications.analyzer.ReasonMatchUtilKt;
import jetbrains.youtrack.notifications.data.event.StarEventAdapter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0017\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\u000fJ0\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000eH\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Ljetbrains/youtrack/notifications/data/event/StarEventNotificationMapper;", "Ljetbrains/youtrack/api/notifications/EventNotificationMapper;", "()V", "category", "Ljetbrains/youtrack/api/events/EventCategory;", "getCategory", "()Ljetbrains/youtrack/api/events/EventCategory;", "setCategory", "(Ljetbrains/youtrack/api/events/EventCategory;)V", "createAdapter", "Ljetbrains/youtrack/api/notifications/EventNotificationAdapter;", "event", "Ljetbrains/youtrack/api/events/Event;", "getPositiveMask", "", "(Ljetbrains/youtrack/api/events/Event;)Ljava/lang/Integer;", "match", "", "reason", "Ljetbrains/youtrack/api/notifications/NotificationReason;", "eventMask", "searchMask", "totalMask", "youtrack-notifications"})
public final class StarEventNotificationMapper
implements EventNotificationMapper {
    @Autowired
    @Qualifier(value="starCategory")
    @NotNull
    public EventCategory category;

    @NotNull
    public EventCategory getCategory() {
        EventCategory eventCategory = this.category;
        if (eventCategory == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"category");
        }
        return eventCategory;
    }

    public void setCategory(@NotNull EventCategory eventCategory) {
        Intrinsics.checkParameterIsNotNull((Object)eventCategory, (String)"<set-?>");
        this.category = eventCategory;
    }

    @Nullable
    public EventNotificationAdapter createAdapter(@NotNull Event event2) {
        Intrinsics.checkParameterIsNotNull((Object)event2, (String)"event");
        return (EventNotificationAdapter)new StarEventAdapter(event2);
    }

    @Nullable
    public Integer getPositiveMask(@NotNull Event event2) {
        Intrinsics.checkParameterIsNotNull((Object)event2, (String)"event");
        return ByteUtil.or((int)RuleType.NOTIFY_ON_TAG.mask, (int)RuleType.NOTIFY_ON_UNTAG.mask);
    }

    public boolean match(@NotNull Event event2, @NotNull NotificationReason reason, int eventMask, int searchMask, int totalMask) {
        Intrinsics.checkParameterIsNotNull((Object)event2, (String)"event");
        Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
        return ReasonMatchUtilKt.hasTaggedReason(reason, event2) || ReasonMatchUtilKt.hasUntaggedReason(reason, event2);
    }

    @Nullable
    public Integer getNegativeMask(@NotNull Event event2) {
        Intrinsics.checkParameterIsNotNull((Object)event2, (String)"event");
        return EventNotificationMapper.DefaultImpls.getNegativeMask((EventNotificationMapper)this, (Event)event2);
    }
}

