/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.durability;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import jetbrains.exodus.core.execution.Job;
import jetbrains.youtrack.notifications.durability.DurabilityExceptionHandler;
import jetbrains.youtrack.notifications.durability.DurabilityJob;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLoggable;
import mu.KLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import webr.framework.controller.BeanContainerAwareSingleThreadDelegatingJobProcessor;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\b&\u0018\u0000 )2\u00020\u0001:\u0001)B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0006H&J\b\u0010\u001b\u001a\u00020\u0015H\u0017J\b\u0010\u001c\u001a\u00020\u0006H\u0016J\b\u0010\u001d\u001a\u00020\u0006H\u0016J\b\u0010\u001e\u001a\u00020\u0015H\u0007J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u0017H&J\u0006\u0010!\u001a\u00020\rJ\b\u0010\"\u001a\u00020\u0015H\u0016J\u001a\u0010#\u001a\u00020\u00152\b\u0010 \u001a\u0004\u0018\u00010\u00172\u0006\u0010$\u001a\u00020\u0006H\u0002J\u0014\u0010%\u001a\u00020\u00152\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u0017H\u0016J\u0006\u0010&\u001a\u00020\u0015J\u000e\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u0003R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\t\"\u0004\b\u0010\u0010\u000bR\u0012\u0010\u0011\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006*"}, d2={"Ljetbrains/youtrack/notifications/durability/DurabilityJobProcessor;", "Lwebr/framework/controller/BeanContainerAwareSingleThreadDelegatingJobProcessor;", "key", "", "(Ljava/lang/String;)V", "value", "", "startDelay", "getStartDelay", "()J", "setStartDelay", "(J)V", "stoppedDurability", "", "timeout", "getTimeout", "setTimeout", "title", "getTitle", "()Ljava/lang/String;", "afterProcessingJob", "", "job", "Ljetbrains/exodus/core/execution/Job;", "createDurabilityJob", "Ljetbrains/youtrack/notifications/durability/DurabilityJob;", "id", "finish", "getFirstTimeout", "getNextTimeout", "init", "isApplicable", "oldJob", "isStopped", "queueFirst", "queueInNotLaterAfter", "delay", "queueNext", "startDurability", "stopDurability", "reason", "Companion", "youtrack-notifications"})
public abstract class DurabilityJobProcessor
extends BeanContainerAwareSingleThreadDelegatingJobProcessor {
    private long startDelay;
    private long timeout;
    private boolean stoppedDurability;
    @NotNull
    private static final KLogger logger;
    private static final long DEFAULT_TIMEOUT = 90000L;
    private static final long DEFAULT_START_DELAY = 0L;
    public static final Companion Companion;

    @PostConstruct
    public final void init() {
        this.exceptionHandler = new DurabilityExceptionHandler();
        this.start();
    }

    @PreDestroy
    public void finish() {
        super.finish();
    }

    public void afterProcessingJob(@NotNull Job job) {
        Intrinsics.checkParameterIsNotNull((Object)job, (String)"job");
        if (this.isApplicable(job)) {
            this.queueNext(job);
        }
        super.afterProcessingJob(job);
    }

    public void queueFirst() {
        this.queueInNotLaterAfter(null, this.getFirstTimeout());
    }

    public void queueNext(@Nullable Job oldJob) {
        this.queueInNotLaterAfter(oldJob, this.getNextTimeout());
    }

    public static /* synthetic */ void queueNext$default(DurabilityJobProcessor durabilityJobProcessor, Job job, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: queueNext");
        }
        if ((n & 1) != 0) {
            job = null;
        }
        durabilityJobProcessor.queueNext(job);
    }

    private final void queueInNotLaterAfter(Job oldJob, long delay) {
        if (this.isStopped()) {
            Companion.getLogger().info((Function0)new Function0<String>(this){
                final /* synthetic */ DurabilityJobProcessor this$0;

                @NotNull
                public final String invoke() {
                    return this.this$0.getTitle() + " is stopped, next durable job was not scheduled";
                }
                {
                    this.this$0 = durabilityJobProcessor;
                    super(0);
                }
            });
        } else {
            long now = System.currentTimeMillis();
            Job job = oldJob;
            long lastStartAt = job != null ? job.getStartedAt() : now;
            long nextStartAt = lastStartAt + delay;
            long l = nextStartAt - now;
            long l2 = 0L;
            boolean bl = false;
            long nextStartIn = Math.max(l, l2);
            this.queueIn((Job)this.createDurabilityJob(now), nextStartIn);
            Companion.getLogger().debug((Function0)new Function0<String>(this, nextStartIn, now, nextStartAt){
                final /* synthetic */ DurabilityJobProcessor this$0;
                final /* synthetic */ long $nextStartIn;
                final /* synthetic */ long $now;
                final /* synthetic */ long $nextStartAt;

                @NotNull
                public final String invoke() {
                    String nextStartAtStr = this.$nextStartIn == 0L ? "" + '~' + this.$now : String.valueOf(this.$nextStartAt);
                    return this.this$0.getTitle() + " scheduled next job to run in " + this.$nextStartIn + " millis, at " + nextStartAtStr;
                }
                {
                    this.this$0 = durabilityJobProcessor;
                    this.$nextStartIn = l;
                    this.$now = l2;
                    this.$nextStartAt = l3;
                    super(0);
                }
            });
        }
    }

    @NotNull
    public abstract String getTitle();

    @NotNull
    public abstract DurabilityJob createDurabilityJob(long var1);

    public abstract boolean isApplicable(@NotNull Job var1);

    public final long getStartDelay() {
        return this.startDelay;
    }

    public final void setStartDelay(long value2) {
        Companion.getLogger().info((Function0)new Function0<String>(this, value2){
            final /* synthetic */ DurabilityJobProcessor this$0;
            final /* synthetic */ long $value;

            @NotNull
            public final String invoke() {
                return this.this$0.getTitle() + " start delay was changed: " + DurabilityJobProcessor.access$getStartDelay$lp(this.this$0) + " -> " + this.$value;
            }
            {
                this.this$0 = durabilityJobProcessor;
                this.$value = l;
                super(0);
            }
        });
        this.startDelay = value2;
    }

    public final long getTimeout() {
        return this.timeout;
    }

    public final void setTimeout(long value2) {
        Companion.getLogger().info((Function0)new Function0<String>(this, value2){
            final /* synthetic */ DurabilityJobProcessor this$0;
            final /* synthetic */ long $value;

            @NotNull
            public final String invoke() {
                return this.this$0.getTitle() + " timeout was changed: " + DurabilityJobProcessor.access$getTimeout$lp(this.this$0) + " -> " + this.$value;
            }
            {
                this.this$0 = durabilityJobProcessor;
                this.$value = l;
                super(0);
            }
        });
        this.timeout = value2;
    }

    public long getFirstTimeout() {
        return this.startDelay;
    }

    public long getNextTimeout() {
        return this.timeout;
    }

    public final boolean isStopped() {
        return this.stoppedDurability;
    }

    public final void stopDurability(@NotNull String reason) {
        Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
        if (!this.stoppedDurability) {
            this.stoppedDurability = true;
            Companion.getLogger().info((Function0)new Function0<String>(this, reason){
                final /* synthetic */ DurabilityJobProcessor this$0;
                final /* synthetic */ String $reason;

                @NotNull
                public final String invoke() {
                    return this.this$0.getTitle() + " was stopped due to " + this.$reason;
                }
                {
                    this.this$0 = durabilityJobProcessor;
                    this.$reason = string;
                    super(0);
                }
            });
        }
    }

    public final void startDurability() {
        if (this.stoppedDurability) {
            this.stoppedDurability = false;
            if (this.getCurrentJob() == null && this.pendingTimedJobs() == 0) {
                DurabilityJobProcessor.queueNext$default(this, null, 1, null);
            }
            Companion.getLogger().info((Function0)new Function0<String>(this){
                final /* synthetic */ DurabilityJobProcessor this$0;

                @NotNull
                public final String invoke() {
                    return this.this$0.getTitle() + " was started";
                }
                {
                    this.this$0 = durabilityJobProcessor;
                    super(0);
                }
            });
        }
    }

    public DurabilityJobProcessor(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        super(key);
        this.timeout = 90000L;
    }

    static {
        Companion = new Companion(null);
        logger = Companion.logger();
    }

    public static final /* synthetic */ long access$getStartDelay$lp(DurabilityJobProcessor $this) {
        return $this.startDelay;
    }

    public static final /* synthetic */ void access$setStartDelay$lp(DurabilityJobProcessor $this, long l) {
        $this.startDelay = l;
    }

    public static final /* synthetic */ long access$getTimeout$lp(DurabilityJobProcessor $this) {
        return $this.timeout;
    }

    public static final /* synthetic */ void access$setTimeout$lp(DurabilityJobProcessor $this, long l) {
        $this.timeout = l;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Ljetbrains/youtrack/notifications/durability/DurabilityJobProcessor$Companion;", "Lmu/KLoggable;", "()V", "DEFAULT_START_DELAY", "", "DEFAULT_TIMEOUT", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "youtrack-notifications"})
    public static final class Companion
    implements KLoggable {
        @NotNull
        public KLogger getLogger() {
            return logger;
        }

        private Companion() {
        }

        @NotNull
        public KLogger logger() {
            return KLoggable.DefaultImpls.logger((KLoggable)this);
        }

        @NotNull
        public KLogger logger(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            return KLoggable.DefaultImpls.logger((KLoggable)this, (String)name);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

