/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.durability;

import jetbrains.charisma.main.ConfigurationParameter;
import jetbrains.youtrack.api.application.AppLifecycleListenerAdapter;
import jetbrains.youtrack.notifications.durability.DurabilityJobProcessor;
import jetbrains.youtrack.notifications.persistence.XdDurability;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\b&\u0018\u0000 (2\u00020\u0001:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0014J\b\u0010\u001e\u001a\u00020\u001cH\u0002J\b\u0010\u001f\u001a\u00020\u001cH&J\b\u0010 \u001a\u00020\u001cH\u0002J\b\u0010!\u001a\u00020\u001cH\u0002J\b\u0010\"\u001a\u00020\u001cH\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\nH\u0002J\b\u0010&\u001a\u00020\u001cH\u0016J\b\u0010'\u001a\u00020\u001cH\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\fR\u0012\u0010\u0017\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\fR\u0011\u0010\u0019\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\f\u00a8\u0006)"}, d2={"Ljetbrains/youtrack/notifications/durability/DurabilityLifecycle;", "Ljetbrains/youtrack/api/application/AppLifecycleListenerAdapter;", "()V", "defaultStartDelay", "", "getDefaultStartDelay", "()J", "defaultTimeout", "getDefaultTimeout", "disableKey", "", "getDisableKey", "()Ljava/lang/String;", "durability", "Ljetbrains/youtrack/notifications/persistence/XdDurability;", "getDurability", "()Ljetbrains/youtrack/notifications/persistence/XdDurability;", "durabilityJobProcessor", "Ljetbrains/youtrack/notifications/durability/DurabilityJobProcessor;", "getDurabilityJobProcessor", "()Ljetbrains/youtrack/notifications/durability/DurabilityJobProcessor;", "startDelayKey", "getStartDelayKey", "timeoutKey", "getTimeoutKey", "title", "getTitle", "applyDisable", "", "applyDisableKey", "applyNotificationDisableKey", "applyReset", "applyStartDelay", "applyTimeout", "initDurability", "isTrueParameter", "", "option", "start", "stop", "Companion", "youtrack-notifications"})
public abstract class DurabilityLifecycle
extends AppLifecycleListenerAdapter {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract XdDurability getDurability();

    @NotNull
    public abstract DurabilityJobProcessor getDurabilityJobProcessor();

    @NotNull
    public abstract String getDisableKey();

    @NotNull
    public final String getTitle() {
        return this.getDurability().getTitle();
    }

    public void start() {
        try {
            this.initDurability();
            this.applyStartDelay();
            this.applyTimeout();
            this.applyDisable();
            this.applyReset();
            this.getDurabilityJobProcessor().queueFirst();
        }
        catch (Throwable e) {
            Companion.getLogger().error(e, (Function0)new Function0<String>(this){
                final /* synthetic */ DurabilityLifecycle this$0;

                @NotNull
                public final String invoke() {
                    return this.this$0.getTitle() + " restart failed";
                }
                {
                    this.this$0 = durabilityLifecycle;
                    super(0);
                }
            });
        }
    }

    public void stop() {
        Companion.getLogger().debug((Function0)new Function0<String>(this){
            final /* synthetic */ DurabilityLifecycle this$0;

            @NotNull
            public final String invoke() {
                return this.this$0.getTitle() + " was stopped";
            }
            {
                this.this$0 = durabilityLifecycle;
                super(0);
            }
        });
    }

    private final void initDurability() {
        this.getDurability();
    }

    @NotNull
    public abstract String getTimeoutKey();

    public abstract long getDefaultTimeout();

    @NotNull
    public abstract String getStartDelayKey();

    public abstract long getDefaultStartDelay();

    private final void applyStartDelay() {
        Object object = ConfigurationParameter.getParameter((String)this.getStartDelayKey());
        long startDelay2 = object != null && (object = StringsKt.toLongOrNull((String)object)) != null ? ((Long)object).longValue() : this.getDefaultStartDelay();
        this.getDurabilityJobProcessor().setStartDelay(startDelay2);
    }

    private final void applyTimeout() {
        Object object = ConfigurationParameter.getParameter((String)this.getTimeoutKey());
        long timeout2 = object != null && (object = StringsKt.toLongOrNull((String)object)) != null ? ((Long)object).longValue() : this.getDefaultTimeout();
        this.getDurabilityJobProcessor().setTimeout(timeout2);
    }

    private final void applyDisable() {
        this.applyNotificationDisableKey();
        this.applyDisableKey();
    }

    private final void applyNotificationDisableKey() {
        String notificationDisableKey;
        String string = notificationDisableKey = ConfigurationParameter.DISABLE_NOTIFICATIONS.getKey()[0];
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"notificationDisableKey");
        if (this.isTrueParameter(string)) {
            this.getDurabilityJobProcessor().stopDurability(notificationDisableKey + "=true");
        }
    }

    protected void applyDisableKey() {
        if (this.isTrueParameter(this.getDisableKey())) {
            this.getDurabilityJobProcessor().stopDurability(this.getDisableKey() + "=true");
        }
    }

    public abstract void applyReset();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isTrueParameter(String option) {
        String string = ConfigurationParameter.getParameter((String)option);
        if (string == null) return false;
        String string2 = string;
        boolean bl = false;
        if (!Boolean.parseBoolean(string2)) return false;
        return true;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/notifications/durability/DurabilityLifecycle$Companion;", "Lmu/KLogging;", "()V", "youtrack-notifications"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

