/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.main;

import java.util.NoSuchElementException;
import jetbrains.youtrack.api.events.Event;
import jetbrains.youtrack.api.events.EventCategory;
import jetbrains.youtrack.api.notifications.DataAwareNotificationCase;
import jetbrains.youtrack.api.notifications.EventComponentTemplateDescriptor;
import jetbrains.youtrack.api.notifications.NotificationCase;
import jetbrains.youtrack.api.notifications.NotificationData;
import jetbrains.youtrack.api.notifications.NotificationTestDataBuilder;
import jetbrains.youtrack.api.webr.LocalScoped;
import jetbrains.youtrack.config.BeansKt;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.core.persistent.issue.XdIssueFolder;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.event.rollback.EventRollbackService;
import jetbrains.youtrack.notifications.NotificationService;
import jetbrains.youtrack.notifications.NotificationServiceKt;
import jetbrains.youtrack.notifications.data.IssueEntitySnapshotAdapter;
import jetbrains.youtrack.notifications.data.event.EventNotificationMapperDispatchKt;
import jetbrains.youtrack.notifications.main.DigestNotificationData;
import jetbrains.youtrack.notifications.main.NotificationPool;
import jetbrains.youtrack.notifications.main.NotificationPropertiesKt;
import jetbrains.youtrack.notifications.main.TemplateComponentGroup;
import jetbrains.youtrack.notifications.persistence.XdNotificationManagement;
import jetbrains.youtrack.persistent.XdIssueComment;
import jetbrains.youtrack.persistent.XdIssueExtKt;
import jetbrains.youtrack.persistent.XdIssueTag;
import jetbrains.youtrack.persistent.XdProjectExtKt;
import jetbrains.youtrack.persistent.XdWatchFolder;
import jetbrains.youtrack.persistent.comment.IssueCommentServiceKt;
import jetbrains.youtrack.persistent.tag.IssueTagServiceKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="previewTestDataBuilder")
@LocalScoped
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0012\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010\u001c\u001a\u00020\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u001eH\u0016J\u0014\u0010!\u001a\u00020\u00142\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u001eH\u0002J\b\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020(H\u0002J\f\u0010)\u001a\u00020**\u00020\u0014H\u0002J\f\u0010+\u001a\u00020**\u00020\u0014H\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\f8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\nR\u0012\u0010\u0010\u001a\u00020\u00118\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Ljetbrains/youtrack/notifications/main/TestDataBuilder;", "Ljetbrains/youtrack/api/notifications/NotificationTestDataBuilder;", "()V", "eventRollbackService", "Ljetbrains/youtrack/event/rollback/EventRollbackService;", "initialNotification", "", "issue", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "getIssue", "()Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "notificationPool", "Ljetbrains/youtrack/notifications/main/NotificationPool;", "onlyViaDuplicate", "previewIssue", "getPreviewIssue", "templateComponentGroup", "Ljetbrains/youtrack/notifications/main/TemplateComponentGroup;", "badIssue", "createEventBasedData", "Ljetbrains/youtrack/api/notifications/NotificationData;", "category", "Ljetbrains/youtrack/api/events/EventCategory;", "user", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "createNotificationCaseTestData", "case", "Ljetbrains/youtrack/api/notifications/DataAwareNotificationCase;", "createNotificationComponentTestData", "id", "", "createTestData", "templateFileName", "createUniversalData", "templateId", "suitableComment", "Ljetbrains/youtrack/persistent/XdIssueComment;", "suitableProject", "Ljetbrains/youtrack/core/persistent/issue/XdProject;", "suitableTag", "Ljetbrains/youtrack/persistent/XdIssueTag;", "addContextIssue", "", "addSharedVariables", "youtrack-notifications"})
public final class TestDataBuilder
implements NotificationTestDataBuilder {
    @Autowired
    private TemplateComponentGroup templateComponentGroup;
    @Autowired
    private NotificationPool notificationPool;
    @Autowired
    private EventRollbackService eventRollbackService;
    private final boolean initialNotification = false;
    private final boolean onlyViaDuplicate = false;

    @Nullable
    public XdIssue getPreviewIssue() {
        XdIssue i = ((XdNotificationManagement)XdNotificationManagement.Companion.get()).getTemplateIssue();
        if (i == null || i.isRemoved()) {
            return null;
        }
        return i;
    }

    @NotNull
    public XdIssue getIssue() {
        XdIssue xdIssue = this.getPreviewIssue();
        if (xdIssue == null) {
            throw (Throwable)new IllegalArgumentException(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("TestDataBuilder.Test_issue_is_undefined", new Object[0]));
        }
        return xdIssue;
    }

    @NotNull
    public NotificationData createTestData(@NotNull String templateFileName) {
        NotificationCase notificationCase;
        Intrinsics.checkParameterIsNotNull((Object)templateFileName, (String)"templateFileName");
        NotificationPool notificationPool = this.notificationPool;
        if (notificationPool == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"notificationPool");
        }
        return (notificationCase = notificationPool.findNotificationCase(templateFileName)) instanceof DataAwareNotificationCase ? this.createNotificationCaseTestData((DataAwareNotificationCase)notificationCase) : (notificationCase == null ? this.createNotificationComponentTestData(templateFileName) : this.createUniversalData(templateFileName));
    }

    private final NotificationData createNotificationCaseTestData(DataAwareNotificationCase dataAwareNotificationCase) {
        NotificationData notificationData = NotificationServiceKt.getNotificationService().createData((NotificationCase)dataAwareNotificationCase, this.getPreviewIssue());
        boolean bl = false;
        boolean bl2 = false;
        NotificationData $this$apply = notificationData;
        boolean bl3 = false;
        dataAwareNotificationCase.extendWithTestData($this$apply, jetbrains.charisma.persistent.BeansKt.getXdLoggedInUser());
        $this$apply.set(jetbrains.youtrack.api.notifications.NotificationPropertiesKt.getHeaderNotificationProperty(), (Object)dataAwareNotificationCase.getHeader().getValue());
        this.addSharedVariables($this$apply);
        return notificationData;
    }

    private final NotificationData createNotificationComponentTestData(String id) {
        String string;
        block9: {
            block8: {
                NotificationData notificationData;
                EventComponentTemplateDescriptor eventTemplate;
                EventComponentTemplateDescriptor eventComponentTemplateDescriptor;
                Object v2;
                block7: {
                    string = id;
                    if (string == null) break block8;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String fileName = string2;
                    boolean bl3 = false;
                    TemplateComponentGroup templateComponentGroup = this.templateComponentGroup;
                    if (templateComponentGroup == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"templateComponentGroup");
                    }
                    Iterable $this$firstOrNull$iv = CollectionsKt.filterIsInstance((Iterable)templateComponentGroup.getTemplates(), EventComponentTemplateDescriptor.class);
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        EventComponentTemplateDescriptor it = (EventComponentTemplateDescriptor)element$iv;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it.getFileName(), (Object)fileName)) continue;
                        v2 = element$iv;
                        break block7;
                    }
                    v2 = null;
                }
                if ((eventComponentTemplateDescriptor = (eventTemplate = (EventComponentTemplateDescriptor)v2)) != null && (eventComponentTemplateDescriptor = eventComponentTemplateDescriptor.getEventCategory()) != null) {
                    EventComponentTemplateDescriptor eventComponentTemplateDescriptor2 = eventComponentTemplateDescriptor;
                    boolean bl = false;
                    boolean bl5 = false;
                    EventComponentTemplateDescriptor it = eventComponentTemplateDescriptor2;
                    boolean bl6 = false;
                    notificationData = this.createEventBasedData((EventCategory)it, jetbrains.charisma.persistent.BeansKt.getXdLoggedInUser());
                } else {
                    notificationData = null;
                }
                string = notificationData;
                if (notificationData != null) break block9;
            }
            string = this.createUniversalData(id);
        }
        return string;
    }

    private final NotificationData createEventBasedData(EventCategory category, XdUser user) {
        Object v1;
        IssueEntitySnapshotAdapter adapter;
        block4: {
            Sequence events;
            adapter = new IssueEntitySnapshotAdapter(this.getIssue());
            EventRollbackService eventRollbackService = this.eventRollbackService;
            if (eventRollbackService == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"eventRollbackService");
            }
            Sequence $this$firstOrNull$iv = events = eventRollbackService.reconstructInMemoryReversedEvents((XdEntity)this.getIssue());
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Event it = (Event)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getCategory(), (Object)category) && EventNotificationMapperDispatchKt.getEventNotificationMapper().createAdapter(it) != null)) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        Event event2 = v1;
        if (event2 == null) {
            throw (Throwable)new IllegalArgumentException(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("TestDataBuilder.Test_issue_has_no_changes_for_{0}", new Object[]{category.getName()}));
        }
        Event event3 = event2;
        DigestNotificationData digestNotificationData = new DigestNotificationData(this.getIssue().getEntity());
        boolean bl = false;
        boolean bl2 = false;
        DigestNotificationData $this$apply = digestNotificationData;
        boolean bl3 = false;
        $this$apply.set(jetbrains.youtrack.api.notifications.NotificationPropertiesKt.getIssueNotificationProperty(), adapter);
        $this$apply.set(NotificationPropertiesKt.getEventNotificationProperty(), EventNotificationMapperDispatchKt.getEventNotificationMapper().createAdapter(event3));
        XdUser xdUser = user;
        if (xdUser != null && (xdUser = xdUser.getEntity()) != null) {
            XdUser xdUser2 = xdUser;
            boolean bl4 = false;
            boolean bl5 = false;
            XdUser it = xdUser2;
            boolean bl6 = false;
            $this$apply.set(jetbrains.youtrack.api.notifications.NotificationPropertiesKt.getRecipientNotificationProperty(), it);
            $this$apply.set(jetbrains.youtrack.api.notifications.NotificationPropertiesKt.getSenderNotificationProperty(), it);
        }
        this.addSharedVariables($this$apply);
        return digestNotificationData;
    }

    private final XdIssueComment suitableComment() {
        XdIssueComment comment;
        XdIssueComment xdIssueComment;
        if (this.badIssue(this.getIssue())) {
            Object v1;
            block4: {
                Sequence $this$firstOrNull$iv = XdQueryKt.asSequence((XdQuery)XdIssueComment.Companion.all());
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    XdIssueComment it = (XdIssueComment)element$iv;
                    boolean bl = false;
                    XdIssue commentIssue = it.getIssue();
                    boolean bl2 = !it.getDeleted() && !commentIssue.getDeleted() && !commentIssue.isDraft() && XdIssueComment.isAccessible$default((XdIssueComment)it, (Operation)Operation.READ, null, (int)2, null);
                    if (!bl2) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            xdIssueComment = v1;
        } else {
            xdIssueComment = (XdIssueComment)SequencesKt.lastOrNull((Sequence)IssueCommentServiceKt.findAccessibleComments((XdIssue)this.getIssue()));
        }
        XdIssueComment xdIssueComment2 = comment = xdIssueComment;
        if (xdIssueComment2 == null) {
            throw (Throwable)new IllegalArgumentException(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("TestDataBuilder.{0}_does_not_have_comments_to_use_it_as_test_data", new Object[]{this.getIssue().getIdReadable()}));
        }
        return xdIssueComment2;
    }

    private final XdProject suitableProject() {
        XdProject project;
        XdProject xdProject;
        if (this.badIssue(this.getIssue())) {
            Object v0;
            block4: {
                Sequence $this$firstOrNull$iv = XdQueryKt.asSequence((XdQuery)XdProject.Companion.all());
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    XdProject it = (XdProject)element$iv;
                    boolean bl = false;
                    if (!XdProjectExtKt.isAccessible((XdIssueFolder)((XdIssueFolder)it), (Operation)Operation.READ)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            xdProject = v0;
        } else {
            xdProject = this.getIssue().getProject();
        }
        XdProject xdProject2 = project = xdProject;
        if (xdProject2 == null) {
            throw (Throwable)new IllegalArgumentException(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("TestDataBuilder.{0}_does_not_have_any_project_to_use_it_as_test_data", new Object[]{BeansKt.getCentralManager().getApplicationName()}));
        }
        return xdProject2;
    }

    private final XdIssueTag suitableTag() {
        XdIssueTag tag;
        XdIssueTag xdIssueTag;
        if (this.badIssue(this.getIssue())) {
            Object element$iv2;
            block4: {
                Sequence $this$first$iv = XdQueryKt.asSequence((XdQuery)XdIssueTag.Companion.all());
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    XdIssueTag it = (XdIssueTag)element$iv2;
                    boolean bl = false;
                    if (!XdWatchFolder.isVisible$default((XdWatchFolder)it, null, null, (int)3, null)) continue;
                    break block4;
                }
                throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            xdIssueTag = (XdIssueTag)element$iv2;
        } else {
            xdIssueTag = (XdIssueTag)SequencesKt.lastOrNull((Sequence)CollectionsKt.asSequence((Iterable)IssueTagServiceKt.getExplicitTags((XdIssue)this.getIssue())));
        }
        XdIssueTag xdIssueTag2 = tag = xdIssueTag;
        if (xdIssueTag2 == null) {
            throw (Throwable)new IllegalArgumentException(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("TestDataBuilder.{0}_does_not_have_any_tags_to_use_it_as_test_data", new Object[]{BeansKt.getCentralManager().getApplicationName()}));
        }
        return xdIssueTag2;
    }

    private final boolean badIssue(XdIssue issue2) {
        return issue2 == null || issue2.getDeleted() || XdIssueExtKt.isAccessible$default((XdIssue)issue2, (Operation)Operation.PRIVATE_READ, null, (int)2, null);
    }

    private final NotificationData createUniversalData(String templateId) {
        boolean bl;
        boolean bl2;
        String string;
        XdUser user = jetbrains.charisma.persistent.BeansKt.getXdLoggedInUser();
        NotificationData notificationData = NotificationService.DefaultImpls.createData$default((NotificationService)NotificationServiceKt.getNotificationService(), null, (XdIssue)this.getIssue(), (int)1, null);
        boolean bl3 = false;
        boolean bl4 = false;
        NotificationData data = notificationData;
        boolean bl5 = false;
        String string2 = templateId;
        if (string2 != null) {
            string = string2;
            bl2 = false;
            bl = false;
            String it = string;
            boolean bl6 = false;
            NotificationPool notificationPool = this.notificationPool;
            if (notificationPool == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"notificationPool");
            }
            Iterable $this$forEach$iv = notificationPool.findNotificationCasesUsing(templateId);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DataAwareNotificationCase dataAwareNotificationCase = (DataAwareNotificationCase)element$iv;
                boolean bl7 = false;
                dataAwareNotificationCase.extendWithTestData(data, user);
            }
        }
        string = data;
        bl2 = false;
        bl = false;
        String $this$apply = string;
        boolean bl8 = false;
        this.addContextIssue((NotificationData)$this$apply);
        $this$apply.set(jetbrains.youtrack.api.notifications.NotificationPropertiesKt.getCommentNotificationProperty(), (Object)this.suitableComment().getEntity());
        $this$apply.set(jetbrains.youtrack.api.notifications.NotificationPropertiesKt.getProjectNotificationProperty(), (Object)this.suitableProject().getEntity());
        $this$apply.set(NotificationPropertiesKt.getTagNotificationProperty(), (Object)this.suitableTag().getEntity());
        this.addSharedVariables((NotificationData)$this$apply);
        return notificationData;
    }

    static /* synthetic */ NotificationData createUniversalData$default(TestDataBuilder testDataBuilder, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return testDataBuilder.createUniversalData(string);
    }

    private final void addContextIssue(@NotNull NotificationData $this$addContextIssue) {
        if ($this$addContextIssue.get(jetbrains.youtrack.api.notifications.NotificationPropertiesKt.getIssueNotificationProperty()) == null) {
            $this$addContextIssue.set(jetbrains.youtrack.api.notifications.NotificationPropertiesKt.getIssueNotificationProperty(), (Object)new IssueEntitySnapshotAdapter(this.getIssue()));
        }
    }

    private final void addSharedVariables(@NotNull NotificationData $this$addSharedVariables) {
        $this$addSharedVariables.set(NotificationPropertiesKt.getInitNotificationNotificationProperty(), (Object)this.initialNotification);
        $this$addSharedVariables.set(NotificationPropertiesKt.getOnlyViaDuplicateNotificationProperty(), (Object)this.onlyViaDuplicate);
    }
}

