/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.model;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.Locale;
import java.util.Set;
import jetbrains.charisma.links.persistent.LinkDirection;
import jetbrains.charisma.main.CollectionUtilKt;
import jetbrains.charisma.main.GapUrlUtilsKt;
import jetbrains.charisma.persistence.security.VisibilityGroupsProvider;
import jetbrains.charisma.persistence.user.DefaultAvatarUrlHolder;
import jetbrains.charisma.persistent.sortOrder.HierarhyRootsOrderProviderImplKt;
import jetbrains.charisma.persistent.sortOrder.OrderedIssuesProvider;
import jetbrains.charisma.plugins.GeneralUserProfile;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.youtrack.api.notifications.NotificationEntityAdapter;
import jetbrains.youtrack.api.notifications.NotificationIssueAdapter;
import jetbrains.youtrack.api.notifications.StaticNotificationConfigurationExtension;
import jetbrains.youtrack.config.BeansKt;
import jetbrains.youtrack.core.color.IndexedPallet;
import jetbrains.youtrack.core.dates.DateFormats;
import jetbrains.youtrack.core.persistent.XdPersistentFile;
import jetbrains.youtrack.core.persistent.XdVisibilityEntity;
import jetbrains.youtrack.core.persistent.issue.XdIssueFolder;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.persistent.user.XdUserGroup;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.notifications.data.CommentAdapter;
import jetbrains.youtrack.persistent.XdIssueAttachment;
import jetbrains.youtrack.persistent.XdIssueComment;
import jetbrains.youtrack.persistent.XdIssueLinkPrototype;
import jetbrains.youtrack.persistent.XdIssueTag;
import jetbrains.youtrack.persistent.security.SecurityServiceKt;
import jetbrains.youtrack.security.EntitySigningServiceKt;
import jetbrains.youtrack.security.SignatureDuration;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.stereotype.Component;
import webr.framework.url.UrlUtil;

@Component
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Ljetbrains/youtrack/notifications/model/BasicNotificationConfigurationExtension;", "Ljetbrains/youtrack/api/notifications/StaticNotificationConfigurationExtension;", "()V", "Companion", "youtrack-notifications"})
public final class BasicNotificationConfigurationExtension
extends StaticNotificationConfigurationExtension {
    public static final Companion Companion = new Companion(null);

    public BasicNotificationConfigurationExtension() {
        this.setClazz(((Object)((Object)this)).getClass());
        this.setRefName("Utils");
    }

    @JvmStatic
    @NotNull
    public static final String getUrl(@NotNull NotificationIssueAdapter issue2) {
        return Companion.getUrl(issue2);
    }

    @JvmStatic
    @NotNull
    public static final String getStarSrc(@NotNull NotificationIssueAdapter issue2) {
        return Companion.getStarSrc(issue2);
    }

    @JvmStatic
    @NotNull
    public static final String getIconSrc(@NotNull String name) {
        return Companion.getIconSrc(name);
    }

    @JvmStatic
    public static final int getInvisibleAttachmentsCount(@NotNull NotificationIssueAdapter issue2) {
        return Companion.getInvisibleAttachmentsCount(issue2);
    }

    @JvmStatic
    @NotNull
    public static final Iterable<String> getLinkRoles(@NotNull NotificationIssueAdapter issue2) {
        return Companion.getLinkRoles(issue2);
    }

    @JvmStatic
    public static final boolean hasLinks(@NotNull NotificationIssueAdapter issue2) {
        return Companion.hasLinks(issue2);
    }

    @JvmStatic
    @NotNull
    public static final Iterable<Entity> getLinkedIssues(@NotNull NotificationIssueAdapter issue2, @NotNull String role) {
        return Companion.getLinkedIssues(issue2, role);
    }

    @JvmStatic
    @Nullable
    public static final Entity getDuplicate(@NotNull NotificationIssueAdapter issue2) {
        return Companion.getDuplicate(issue2);
    }

    @JvmStatic
    @NotNull
    public static final Iterable<Entity> getExplicitTags(@NotNull NotificationIssueAdapter issue2) {
        return Companion.getExplicitTags(issue2);
    }

    @JvmStatic
    public static final boolean hasVisibilityRestrictions(@NotNull Entity entity) {
        return Companion.hasVisibilityRestrictions(entity);
    }

    @JvmStatic
    public static final boolean hasVisibilityRestrictions(@NotNull NotificationEntityAdapter adapter) {
        return Companion.hasVisibilityRestrictions(adapter);
    }

    @JvmStatic
    @NotNull
    public static final String getVisibilityPresentation(@NotNull Entity entity) {
        return Companion.getVisibilityPresentation(entity);
    }

    @JvmStatic
    @NotNull
    public static final String getVisibilityPresentation(@NotNull NotificationEntityAdapter adapter) {
        return Companion.getVisibilityPresentation(adapter);
    }

    @JvmStatic
    public static final boolean hasSameVisibility(@NotNull Entity first, @NotNull Entity second) {
        return Companion.hasSameVisibility(first, second);
    }

    @JvmStatic
    public static final boolean hasSameVisibility(@NotNull NotificationIssueAdapter first, @NotNull NotificationIssueAdapter second) {
        return Companion.hasSameVisibility(first, second);
    }

    @JvmStatic
    @NotNull
    public static final String getAvatarUrl(@NotNull Entity user) {
        return Companion.getAvatarUrl(user);
    }

    @JvmStatic
    @NotNull
    public static final String getSettingUrl(@NotNull Entity to) {
        return Companion.getSettingUrl(to);
    }

    @JvmStatic
    @NotNull
    public static final String getSettingUrlWithMute(@NotNull Entity to, @NotNull NotificationIssueAdapter issue2) {
        return Companion.getSettingUrlWithMute(to, issue2);
    }

    @JvmStatic
    @NotNull
    public static final String getTaggedIssuesUrl(@NotNull Entity tag) {
        return Companion.getTaggedIssuesUrl(tag);
    }

    @JvmStatic
    @NotNull
    public static final String getCommentUrl(@NotNull CommentAdapter comment) {
        return Companion.getCommentUrl(comment);
    }

    @JvmStatic
    @Nullable
    public static final String getCommentReplyUrl(@NotNull CommentAdapter comment) {
        return Companion.getCommentReplyUrl(comment);
    }

    @JvmStatic
    @Nullable
    public static final String getAttachmentUrl(@NotNull Entity attachment) {
        return Companion.getAttachmentUrl(attachment);
    }

    @JvmStatic
    @NotNull
    public static final String getPossessiveName(@NotNull Entity from, @NotNull Entity to) {
        return Companion.getPossessiveName(from, to);
    }

    @JvmStatic
    @NotNull
    public static final String getTrimmedTagName(@NotNull Entity tag) {
        return Companion.getTrimmedTagName(tag);
    }

    @JvmStatic
    @NotNull
    public static final String inUserTimeZone(@Nullable Long date) {
        return Companion.inUserTimeZone(date);
    }

    @JvmStatic
    @NotNull
    public static final String getTagStyle(@NotNull Entity tag) {
        return Companion.getTagStyle(tag);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0007J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0004H\u0007J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\u0006\u0010\u001a\u001a\u00020\u0006H\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\u0006\u0010\u001a\u001a\u00020\u0006H\u0002J\u0018\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0006H\u0007J\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0006H\u0007J\u0018\u0010 \u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010!\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0006H\u0007J\u0010\u0010$\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0006H\u0007J\u0010\u0010%\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0006H\u0007J\u0010\u0010&\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010'\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0006H\u0007J\u0010\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020)H\u0007J\u0010\u0010*\u001a\u00020+2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0018\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\u0006H\u0007J\u0018\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000fH\u0007J\u0010\u0010/\u001a\u00020+2\u0006\u0010\u001a\u001a\u00020\u0006H\u0007J\u0010\u0010/\u001a\u00020+2\u0006\u0010(\u001a\u00020)H\u0007J\u0017\u00100\u001a\u00020\u00042\b\u00101\u001a\u0004\u0018\u000102H\u0007\u00a2\u0006\u0002\u00103J\u0010\u00104\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0002\u00a8\u00065"}, d2={"Ljetbrains/youtrack/notifications/model/BasicNotificationConfigurationExtension$Companion;", "", "()V", "getAttachmentUrl", "", "attachment", "Ljetbrains/exodus/entitystore/Entity;", "getAvatarUrl", "user", "getCommentReplyUrl", "comment", "Ljetbrains/youtrack/notifications/data/CommentAdapter;", "getCommentUrl", "getDuplicate", "issue", "Ljetbrains/youtrack/api/notifications/NotificationIssueAdapter;", "getExplicitTags", "", "getIconSrc", "name", "getInvisibleAttachmentsCount", "", "getLinkRoles", "getLinkedIssues", "role", "getPermittedGroups", "entity", "getPermittedUsers", "getPossessiveName", "from", "to", "getSettingUrl", "getSettingUrlWithMute", "getStarSrc", "getTagStyle", "tag", "getTaggedIssuesUrl", "getTrimmedTagName", "getUrl", "getVisibilityPresentation", "adapter", "Ljetbrains/youtrack/api/notifications/NotificationEntityAdapter;", "hasLinks", "", "hasSameVisibility", "first", "second", "hasVisibilityRestrictions", "inUserTimeZone", "date", "", "(Ljava/lang/Long;)Ljava/lang/String;", "notificationsProfileRelativeUrl", "youtrack-notifications"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final String getUrl(@NotNull NotificationIssueAdapter issue2) {
            Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
            return jetbrains.charisma.service.BeansKt.getLocationService().getAbsoluteUrlWithAuth("/issue/" + issue2.getId());
        }

        @JvmStatic
        @NotNull
        public final String getStarSrc(@NotNull NotificationIssueAdapter issue2) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
            if (issue2.isStarred()) {
                String string2 = UrlUtil.getClasspathResourceUri((String)"smartui/img/default/nitifications/star.png", (boolean)true);
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"UrlUtil.getClasspathReso\u2026ications/star.png\", true)");
            } else {
                String string3 = UrlUtil.getClasspathResourceUri((String)"smartui/img/default/nitifications/star2.png", (boolean)true);
                string = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"UrlUtil.getClasspathReso\u2026cations/star2.png\", true)");
            }
            return string;
        }

        @JvmStatic
        @NotNull
        public final String getIconSrc(@NotNull String name) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            switch (name) {
                case "cross": {
                    String string2 = UrlUtil.getClasspathResourceUri((String)"smartui/img/default/nitifications/cross.png", (boolean)true);
                    string = string2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"UrlUtil.getClasspathReso\u2026cations/cross.png\", true)");
                    break;
                }
                case "warning": {
                    String string3 = UrlUtil.getClasspathResourceUri((String)"smartui/img/default/nitifications/warning.png", (boolean)true);
                    string = string3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"UrlUtil.getClasspathReso\u2026tions/warning.png\", true)");
                    break;
                }
                default: {
                    throw (Throwable)new IllegalArgumentException("Undefined icon name \"" + name + '\"');
                }
            }
            return string;
        }

        @JvmStatic
        public final int getInvisibleAttachmentsCount(@NotNull NotificationIssueAdapter issue2) {
            Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
            return issue2.getInvisibleAttachmentCount();
        }

        @JvmStatic
        @NotNull
        public final Iterable<String> getLinkRoles(@NotNull NotificationIssueAdapter issue2) {
            Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
            return issue2.getLinkRoles();
        }

        @JvmStatic
        public final boolean hasLinks(@NotNull NotificationIssueAdapter issue2) {
            Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
            return CollectionUtilKt.isNotEmpty((Iterable)issue2.getLinkRoles());
        }

        @JvmStatic
        @NotNull
        public final Iterable<Entity> getLinkedIssues(@NotNull NotificationIssueAdapter issue2, @NotNull String role) {
            Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
            Intrinsics.checkParameterIsNotNull((Object)role, (String)"role");
            return issue2.getLinkedIssues(role);
        }

        @JvmStatic
        @Nullable
        public final Entity getDuplicate(@NotNull NotificationIssueAdapter issue2) {
            String duplicateRole;
            Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
            Entity entity = jetbrains.charisma.persistent.BeansKt.getIssueLinkTypeAux().getDuplicate();
            Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"issueLinkTypeAux.duplicate");
            String string = duplicateRole = ((XdIssueLinkPrototype)XdExtensionsKt.toXd((Entity)entity)).getDirectedLink(LinkDirection.INWARD).getCapitalizedRole();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"duplicateRole");
            return (Entity)CollectionsKt.firstOrNull((Iterable)issue2.getLinkedIssues(string));
        }

        @JvmStatic
        @NotNull
        public final Iterable<Entity> getExplicitTags(@NotNull NotificationIssueAdapter issue2) {
            Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
            return issue2.getTags();
        }

        @JvmStatic
        public final boolean hasVisibilityRestrictions(@NotNull Entity entity) {
            Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
            return !EntityOperations.equals((Entity)QueryOperations.getFirst(this.getPermittedGroups(entity)), null) || !EntityOperations.equals((Entity)QueryOperations.getFirst(this.getPermittedUsers(entity)), null);
        }

        @JvmStatic
        public final boolean hasVisibilityRestrictions(@NotNull NotificationEntityAdapter adapter) {
            Intrinsics.checkParameterIsNotNull((Object)adapter, (String)"adapter");
            return this.hasVisibilityRestrictions(adapter.getAdaptedEntity());
        }

        @JvmStatic
        @NotNull
        public final String getVisibilityPresentation(@NotNull Entity entity) {
            Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
            String string = VisibilityGroupsProvider.getVisibilityPresentation(this.getPermittedGroups(entity), this.getPermittedUsers(entity));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"VisibilityGroupsProvider\u2026etPermittedUsers(entity))");
            return string;
        }

        @JvmStatic
        @NotNull
        public final String getVisibilityPresentation(@NotNull NotificationEntityAdapter adapter) {
            Intrinsics.checkParameterIsNotNull((Object)adapter, (String)"adapter");
            return this.getVisibilityPresentation(adapter.getAdaptedEntity());
        }

        @JvmStatic
        public final boolean hasSameVisibility(@NotNull Entity first, @NotNull Entity second) {
            Intrinsics.checkParameterIsNotNull((Object)first, (String)"first");
            Intrinsics.checkParameterIsNotNull((Object)second, (String)"second");
            Set firstGroups = CollectionsKt.toSet(this.getPermittedGroups(first));
            Set secondGroups = CollectionsKt.toSet(this.getPermittedGroups(second));
            Set set = firstGroups;
            if (set == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Set<*>");
            }
            if (Intrinsics.areEqual((Object)set, (Object)secondGroups)) {
                Set firstUsers = CollectionsKt.toSet(this.getPermittedUsers(first));
                Set secondUsers = CollectionsKt.toSet(this.getPermittedUsers(second));
                Set set2 = firstUsers;
                if (set2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Set<*>");
                }
                return Intrinsics.areEqual((Object)set2, (Object)secondUsers);
            }
            return false;
        }

        @JvmStatic
        public final boolean hasSameVisibility(@NotNull NotificationIssueAdapter first, @NotNull NotificationIssueAdapter second) {
            Intrinsics.checkParameterIsNotNull((Object)first, (String)"first");
            Intrinsics.checkParameterIsNotNull((Object)second, (String)"second");
            return this.hasSameVisibility(first.getAdaptedEntity(), second.getAdaptedEntity());
        }

        private final Iterable<Entity> getPermittedGroups(Entity entity) {
            XdEntity xdEntity = XdExtensionsKt.toXd((Entity)entity);
            if (xdEntity instanceof XdVisibilityEntity) {
                return ((XdVisibilityEntity)xdEntity).getPermittedGroup().getEntityIterable();
            }
            return XdQueryKt.emptyQuery((XdEntityType)((XdEntityType)XdUserGroup.Companion)).getEntityIterable();
        }

        private final Iterable<Entity> getPermittedUsers(Entity entity) {
            XdEntity xdEntity = XdExtensionsKt.toXd((Entity)entity);
            if (xdEntity instanceof XdVisibilityEntity) {
                return ((XdVisibilityEntity)xdEntity).getPermittedUser().getEntityIterable();
            }
            return XdQueryKt.emptyQuery((XdEntityType)((XdEntityType)XdUser.Companion)).getEntityIterable();
        }

        @JvmStatic
        @NotNull
        public final String getAvatarUrl(@NotNull Entity user) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
            if (BeansKt.getRingConfig().isEnabled()) {
                String string2 = BeansKt.getRingUrls().getAbsoluteHubUserAvatarUrl(user);
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ringUrls.getAbsoluteHubUserAvatarUrl(user)");
            } else {
                String name$iv = "defaultAvatarUrl";
                boolean $i$f$getBean = false;
                Object object = ServiceLocator.getBean((String)name$iv);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type jetbrains.charisma.persistence.user.DefaultAvatarUrlHolder");
                }
                String string3 = ((DefaultAvatarUrlHolder)object).getUrl();
                string = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"getBean<DefaultAvatarUrl\u2026>(\"defaultAvatarUrl\").url");
            }
            return string;
        }

        @JvmStatic
        @NotNull
        public final String getSettingUrl(@NotNull Entity to) {
            Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
            return jetbrains.charisma.service.BeansKt.getLocationService().getAbsoluteUrlWithAuth(this.notificationsProfileRelativeUrl(to));
        }

        @JvmStatic
        @NotNull
        public final String getSettingUrlWithMute(@NotNull Entity to, @NotNull NotificationIssueAdapter issue2) {
            Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
            Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
            String token = EntitySigningServiceKt.urlEncode((String)jetbrains.youtrack.security.BeansKt.getEntitySigningService().newSign((XdUser)XdExtensionsKt.toXd((Entity)to), XdExtensionsKt.toXd((Entity)issue2.getAdaptedEntity()), SignatureDuration.UNSUBSCRIBE));
            return jetbrains.charisma.service.BeansKt.getLocationService().getAbsolutePath() + "/api/unsubscribe?token=" + token;
        }

        private final String notificationsProfileRelativeUrl(Entity user) {
            return "/users/" + jetbrains.charisma.ring.BeansKt.getRingDataStore().getUserRingId((XdUser)XdExtensionsKt.toXd((Entity)user)) + "?tab=notifications";
        }

        @JvmStatic
        @NotNull
        public final String getTaggedIssuesUrl(@NotNull Entity tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            OrderedIssuesProvider orderedIssuesProvider = HierarhyRootsOrderProviderImplKt.getHierarchyRootsOrderProvider().getOrderedIssuesProvider((XdIssueFolder)XdExtensionsKt.toXd((Entity)tag));
            String issuesQuery = orderedIssuesProvider != null ? orderedIssuesProvider.getQuery() : null;
            return jetbrains.charisma.service.BeansKt.getLocationService().getAbsoluteUrlWithAuth("/issues?q=" + issuesQuery);
        }

        @JvmStatic
        @NotNull
        public final String getCommentUrl(@NotNull CommentAdapter comment) {
            Intrinsics.checkParameterIsNotNull((Object)comment, (String)"comment");
            XdEntity xdEntity = XdExtensionsKt.toXd((Entity)comment.getAdaptedEntity());
            if (!(xdEntity instanceof XdIssueComment)) {
                xdEntity = null;
            }
            XdIssueComment xdIssueComment = (XdIssueComment)xdEntity;
            if (xdIssueComment == null) {
                throw (Throwable)new IllegalArgumentException("Cannot create url fo non-issue comment");
            }
            XdIssueComment xdComment = xdIssueComment;
            return jetbrains.charisma.service.BeansKt.getLocationService().getAbsoluteUrlWithAuth("/issue/" + xdComment.getContainer().getIdReadable() + "#comment=" + comment.getId());
        }

        @JvmStatic
        @Nullable
        public final String getCommentReplyUrl(@NotNull CommentAdapter comment) {
            Intrinsics.checkParameterIsNotNull((Object)comment, (String)"comment");
            XdEntity xdEntity = XdExtensionsKt.toXd((Entity)comment.getAdaptedEntity());
            if (!(xdEntity instanceof XdIssueComment)) {
                xdEntity = null;
            }
            XdIssueComment xdIssueComment = (XdIssueComment)xdEntity;
            if (xdIssueComment == null) {
                return null;
            }
            XdIssueComment xdComment = xdIssueComment;
            Permission permission = SecurityServiceKt.getSecurityService().getCreatePermission((XdEntity)xdComment);
            if (permission == null) {
                return null;
            }
            Permission createPermission = permission;
            Entity entity = jetbrains.charisma.persistent.BeansKt.getCurrentUser().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"currentUser.get()");
            boolean canReply = ((XdUser)XdExtensionsKt.toXd((Entity)entity)).hasPermissionInProject(createPermission, new XdProject[]{xdComment.getContainer().getProject()});
            return canReply ? jetbrains.charisma.service.BeansKt.getLocationService().getAbsoluteUrlWithAuth("/issue/" + xdComment.getContainer().getIdReadable() + "?replyTo=" + comment.getId()) : null;
        }

        @JvmStatic
        @Nullable
        public final String getAttachmentUrl(@NotNull Entity attachment) {
            Intrinsics.checkParameterIsNotNull((Object)attachment, (String)"attachment");
            XdIssueAttachment xdAttachment = (XdIssueAttachment)XdExtensionsKt.toXd((Entity)attachment);
            return xdAttachment.getRemoved() ? null : GapUrlUtilsKt.getPersistentFileService().urlOf((XdPersistentFile)XdExtensionsKt.toXd((Entity)attachment), null, null, true, SignatureDuration.NOTIFICATIONS);
        }

        @JvmStatic
        @NotNull
        public final String getPossessiveName(@NotNull Entity from, @NotNull Entity to) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
            Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
            if (EntityOperations.equals((Entity)from, (Object)to)) {
                String string2 = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("Utils.you", new Object[0]);
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"localizer.localizedMsg(\"Utils.you\")");
            } else {
                string = ((XdUser)XdExtensionsKt.toXd((Entity)from)).getVisibleName();
            }
            return string;
        }

        @JvmStatic
        @NotNull
        public final String getTrimmedTagName(@NotNull Entity tag) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            int maxLenght = 25;
            String name = ((XdIssueTag)XdExtensionsKt.toXd((Entity)tag)).getName();
            if (name.length() > maxLenght) {
                String string2 = name;
                int n = 0;
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n, maxLenght);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string5 = string4;
                string = stringBuilder.append(string5).append("...").toString();
            } else {
                string = name;
            }
            return string;
        }

        @JvmStatic
        @NotNull
        public final String inUserTimeZone(@Nullable Long date) {
            GeneralUserProfile generalUserProfile = jetbrains.charisma.persistent.BeansKt.getCurrentUser().getGeneralProfile();
            Intrinsics.checkExpressionValueIsNotNull((Object)generalUserProfile, (String)"currentUser.generalProfile");
            String string = DateTimeOperations.print((DateTime)DateTimeOperations.convert((Long)date, (DateTimeZone)generalUserProfile.getTimeZone()), (DateTimeFormatter)DateFormats.INSTANCE.getFormatter("humanDateTime"), (Locale)jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().getLocale());
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DateTimeOperations.print\u2026Time\"), localizer.locale)");
            return string;
        }

        @JvmStatic
        @NotNull
        public final String getTagStyle(@NotNull Entity tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            IndexedPallet color = ((XdIssueTag)XdExtensionsKt.toXd((Entity)tag)).getColor();
            StringBuilder builder = new StringBuilder();
            StringBuilder stringBuilder = builder.append("color: ").append(color.getFg()).append("; background: ").append(color.getBg()).append(";");
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"builder.append(\"color: \"\u2026end(color.bg).append(\";\")");
            builder = stringBuilder;
            if (color != IndexedPallet.C10) {
                StringBuilder stringBuilder2 = builder.append(" border-color: ").append(color.getBg()).append(";");
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"builder.append(\" border-\u2026end(color.bg).append(\";\")");
                builder = stringBuilder2;
            }
            String string = builder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

