/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.model;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import java.io.IOException;
import java.util.Map;
import jetbrains.mps.webr.runtime.util.DiffUtil;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.notifications.model.NullModel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J=\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ*\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u000e\u0010\u0007\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0015"}, d2={"Ljetbrains/youtrack/notifications/model/DiffDirectiveModel;", "Lfreemarker/template/TemplateDirectiveModel;", "()V", "execute", "", "environment", "Lfreemarker/core/Environment;", "params", "", "array", "", "Lfreemarker/template/TemplateModel;", "body", "Lfreemarker/template/TemplateDirectiveBody;", "(Lfreemarker/core/Environment;Ljava/util/Map;[Lfreemarker/template/TemplateModel;Lfreemarker/template/TemplateDirectiveBody;)V", "findParam", "", "name", "notNull", "", "Companion", "youtrack-notifications"})
public final class DiffDirectiveModel
implements TemplateDirectiveModel {
    @NotNull
    public static final String DIFF_DIRECTIVE_NAME = "diff";
    private static final String PARAMS_OLD_TEXT_NAME = "oldText";
    private static final String PARAMS_NEW_TEXT_NAME = "newText";
    private static final String PARAMS_INS_STYLE_NAME = "insStyle";
    private static final String PARAMS_DEL_STYLE_NAME = "delStyle";
    public static final Companion Companion = new Companion(null);

    public void execute(@NotNull Environment environment, @NotNull Map<?, ?> params, @NotNull TemplateModel[] array, @Nullable TemplateDirectiveBody body) throws TemplateException, IOException {
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull(params, (String)"params");
        Intrinsics.checkParameterIsNotNull((Object)array, (String)"array");
        if (body != null) {
            throw (Throwable)new TemplateModelException(DIFF_DIRECTIVE_NAME + BeansKt.getLocalizer().localizedMsg("notifications.directive_doesnt_allow_not_empty_body", new Object[0]));
        }
        TemplateModel[] templateModelArray = array;
        boolean bl = false;
        TemplateModel[] templateModelArray2 = templateModelArray;
        boolean bl2 = false;
        if (!(templateModelArray2.length == 0)) {
            throw (Throwable)new TemplateModelException(DIFF_DIRECTIVE_NAME + BeansKt.getLocalizer().localizedMsg("notifications.directive_doesnt_allow_loop_variables", new Object[0]));
        }
        if (params.isEmpty()) {
            throw (Throwable)new TemplateModelException(DIFF_DIRECTIVE_NAME + BeansKt.getLocalizer().localizedMsg("notifications.directive_doesnt_allow_no_parameters", new Object[0]));
        }
        String oldText = this.findParam(params, PARAMS_OLD_TEXT_NAME, false);
        String newText = this.findParam(params, PARAMS_NEW_TEXT_NAME, false);
        String insStyle = this.findParam(params, PARAMS_INS_STYLE_NAME, true);
        String delStyle = this.findParam(params, PARAMS_DEL_STYLE_NAME, true);
        String result = DiffUtil.toHtmlDiff((String)oldText, (String)newText, null, null, null, (String)insStyle, (String)delStyle, null);
        environment.getOut().write(result);
    }

    private final String findParam(Map<?, ?> params, String name, boolean notNull) throws TemplateModelException {
        Map<?, ?> map2 = params;
        boolean bl = false;
        Object value2 = map2.get(name);
        if (value2 == null || value2 instanceof NullModel) {
            if (notNull) {
                throw (Throwable)new TemplateModelException(BeansKt.getLocalizer().localizedMsg("DiffDirectiveModel.The_{0}_parameter missed", new Object[]{name}));
            }
            return null;
        }
        try {
            return ((TemplateScalarModel)value2).getAsString();
        }
        catch (Throwable t) {
            throw (Throwable)new TemplateModelException(BeansKt.getLocalizer().localizedMsg("DiffDirectiveModel.The_{0}_parameter must be a string or can be evaluated to the string", new Object[]{name}));
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/notifications/model/DiffDirectiveModel$Companion;", "", "()V", "DIFF_DIRECTIVE_NAME", "", "PARAMS_DEL_STYLE_NAME", "PARAMS_INS_STYLE_NAME", "PARAMS_NEW_TEXT_NAME", "PARAMS_OLD_TEXT_NAME", "youtrack-notifications"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

