/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.model;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.InvalidPropertyException;
import freemarker.template.AdapterTemplateModel;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.api.workflow.wrappers.EntityWrapper;
import jetbrains.youtrack.notifications.model.EntityMethodModel;
import jetbrains.youtrack.notifications.model.SafelyAccessible;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0017\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096\u0002J\u0014\u0010\u0012\u001a\u00020\u000b2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ljetbrains/youtrack/notifications/model/EntityModel;", "Lfreemarker/template/TemplateHashModel;", "Lfreemarker/template/TemplateScalarModel;", "Lfreemarker/template/AdapterTemplateModel;", "Ljetbrains/youtrack/notifications/model/SafelyAccessible;", "entityAccessWrapper", "Ljetbrains/youtrack/api/workflow/wrappers/EntityWrapper;", "wrapper", "Lfreemarker/ext/beans/BeansWrapper;", "(Ljetbrains/youtrack/api/workflow/wrappers/EntityWrapper;Lfreemarker/ext/beans/BeansWrapper;)V", "accessor", "", "getAccessor", "()Ljava/lang/Object;", "get", "Lfreemarker/template/TemplateModel;", "name", "", "getAdaptedObject", "hint", "Ljava/lang/Class;", "getAsString", "isEmpty", "", "youtrack-notifications"})
public final class EntityModel
implements TemplateHashModel,
TemplateScalarModel,
AdapterTemplateModel,
SafelyAccessible {
    private final EntityWrapper entityAccessWrapper;
    private final BeansWrapper wrapper;

    @Override
    @Nullable
    public Object getAccessor() {
        return this.entityAccessWrapper;
    }

    @NotNull
    public TemplateModel get(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        try {
            TemplateModel templateModel;
            if (this.entityAccessWrapper == null) {
                throw (Throwable)new TemplateModelException("No access wrapper for property or method: " + name);
            }
            if (this.entityAccessWrapper.hasProperty(name)) {
                TemplateModel templateModel2 = this.wrapper.wrap(this.entityAccessWrapper.get(name));
                templateModel = templateModel2;
                Intrinsics.checkExpressionValueIsNotNull((Object)templateModel2, (String)"wrapper.wrap(entityAccessWrapper.get(name))");
            } else if (this.entityAccessWrapper.hasMethod(name)) {
                templateModel = (TemplateModel)new EntityMethodModel(name, this.entityAccessWrapper, this.wrapper);
            } else {
                throw (Throwable)new InvalidPropertyException("No such entity property or method: " + name);
            }
            return templateModel;
        }
        catch (RuntimeException re) {
            throw (Throwable)new TemplateModelException("Getting property " + name + " threw an exception", (Exception)re);
        }
    }

    public boolean isEmpty() {
        return this.entityAccessWrapper == null;
    }

    @NotNull
    public String getAsString() {
        Object object = this.entityAccessWrapper;
        if (object == null || (object = object.toString()) == null) {
            throw (Throwable)new TemplateModelException("No access wrapper provided");
        }
        return object;
    }

    @NotNull
    public Object getAdaptedObject(@NotNull Class<?> hint) {
        Intrinsics.checkParameterIsNotNull(hint, (String)"hint");
        EntityWrapper entityWrapper = this.entityAccessWrapper;
        if (entityWrapper == null) {
            Intrinsics.throwNpe();
        }
        Entity entity = entityWrapper.getEntity();
        Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"entityAccessWrapper!!.entity");
        return entity;
    }

    public EntityModel(@Nullable EntityWrapper entityAccessWrapper, @NotNull BeansWrapper wrapper2) {
        Intrinsics.checkParameterIsNotNull((Object)wrapper2, (String)"wrapper");
        this.entityAccessWrapper = entityAccessWrapper;
        this.wrapper = wrapper2;
    }
}

