/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.plugin;

import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.api.statistics.BeansKt;
import jetbrains.youtrack.api.statistics.StatisticsFeatureDescription;
import jetbrains.youtrack.core.annotations.ApiDoc;
import jetbrains.youtrack.core.annotations.ApiJsAcceptsJson;
import jetbrains.youtrack.core.annotations.ApiJsDocIgnore;
import jetbrains.youtrack.core.annotations.ApiJsOptional;
import jetbrains.youtrack.core.annotations.ApiKtIgnore;
import jetbrains.youtrack.core.annotations.ApiMethod;
import jetbrains.youtrack.core.annotations.ApiScope;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.persistent.user.XdUserGroup;
import jetbrains.youtrack.notifications.NotificationServiceKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\bH\u0002\u001a\u001c\u0010\n\u001a\u00020\u000b*\u00020\b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0007\u001a$\u0010\n\u001a\u00020\u000b*\u00020\b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0006H\u0007\u001a6\u0010\n\u001a\u00020\u000b*\u00020\b2\b\b\u0001\u0010\f\u001a\u00020\u00012\b\b\u0001\u0010\r\u001a\u00020\u00012\b\b\u0001\u0010\u000e\u001a\u00020\u00062\n\b\u0001\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007\u001a \u0010\u0011\u001a\u00020\u000b*\u00020\u00122\b\b\u0001\u0010\f\u001a\u00020\u00012\b\b\u0001\u0010\r\u001a\u00020\u0001H\u0007\u001a\u0016\u0010\u0013\u001a\u00020\u000b*\u00020\b2\b\b\u0001\u0010\u0014\u001a\u00020\u0001H\u0007\u001a \u0010\u0015\u001a\u00020\u000b*\u00020\b2\b\b\u0001\u0010\f\u001a\u00020\u00012\b\b\u0001\u0010\r\u001a\u00020\u0001H\u0007\u001a<\u0010\u0015\u001a\u00020\u000b*\u00020\b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00012\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\b\u0002\u0010\u000e\u001a\u00020\u00062\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"STATISTICS_CATEGORY", "", "STATISTICS_EMAIL_TO_GROUP", "STATISTICS_EMAIL_TO_USER", "STATISTICS_JABBER_TO_USER", "shouldNotify", "", "to", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "from", "notify", "", "subject", "body", "ignoreNotifyOnOwnChangesSetting", "project", "Ljetbrains/youtrack/core/persistent/issue/XdProject;", "notifyAllUsers", "Ljetbrains/youtrack/core/persistent/user/XdUserGroup;", "sendJabber", "message", "sendMail", "currentUser", "Ljetbrains/exodus/entitystore/Entity;", "youtrack-notifications"})
public final class ExtensionsKt {
    private static final String STATISTICS_CATEGORY = "workflow";
    private static final String STATISTICS_JABBER_TO_USER = "jabberNotificationToUser";
    private static final String STATISTICS_EMAIL_TO_USER = "emailNotificationToUser";
    private static final String STATISTICS_EMAIL_TO_GROUP = "groupNotification";

    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiDoc(value="Sends an email notification to all of the users who are members of the group.\n@example\nissue.oldValue('permittedGroup').notifyAllUsers('Visibility has been changed',\n  'The visibility group for the issue ' + issue.getId() +\n  ' has been changed to ' + permittedGroup.name);")
    public static final void notifyAllUsers(@NotNull XdUserGroup $this$notifyAllUsers, @ApiDoc(value="The subject line of the email notification.") @NotNull String subject, @ApiDoc(value="The message text of the email notification.") @NotNull String body) {
        Intrinsics.checkParameterIsNotNull((Object)$this$notifyAllUsers, (String)"$this$notifyAllUsers");
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        BeansKt.getStatisticsService().incForInstance(new StatisticsFeatureDescription(STATISTICS_CATEGORY, STATISTICS_EMAIL_TO_GROUP));
        Sequence $this$forEach$iv = XdQueryKt.asSequence((XdQuery)((XdQuery)$this$notifyAllUsers.getUsers()));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            XdUser it = (XdUser)element$iv;
            boolean bl = false;
            ExtensionsKt.notify(it, subject, body);
        }
    }

    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiKtIgnore
    @ApiJsDocIgnore
    public static final void notify(@NotNull XdUser $this$notify, @NotNull String subject, @NotNull String body) {
        Intrinsics.checkParameterIsNotNull((Object)$this$notify, (String)"$this$notify");
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        ExtensionsKt.notify($this$notify, subject, body, false);
    }

    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiKtIgnore
    @ApiJsDocIgnore
    public static final void notify(@NotNull XdUser $this$notify, @NotNull String subject, @NotNull String body, boolean ignoreNotifyOnOwnChangesSetting) {
        Intrinsics.checkParameterIsNotNull((Object)$this$notify, (String)"$this$notify");
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        ExtensionsKt.notify($this$notify, subject, body, ignoreNotifyOnOwnChangesSetting, null);
    }

    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiDoc(value="Sends an email notification to the email address that is set in the user profile.")
    @ApiJsAcceptsJson
    public static final void notify(@NotNull XdUser $this$notify, @ApiDoc(value="The subject line of the email notification.") @NotNull String subject, @ApiDoc(value="The message text of the email notification.") @NotNull String body, @ApiDoc(value="If `false`, the message is not sent when changes are performed on behalf of the current user. Otherwise, the message is sent anyway.") @ApiJsOptional boolean ignoreNotifyOnOwnChangesSetting, @ApiDoc(value="When set, the email address that is used as the 'From' address for the specified project is used to send the message.") @ApiJsOptional @Nullable XdProject project) {
        Intrinsics.checkParameterIsNotNull((Object)$this$notify, (String)"$this$notify");
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        ExtensionsKt.sendMail($this$notify, subject, body, jetbrains.youtrack.core.security.BeansKt.getLoggedInUserOrNull(), ignoreNotifyOnOwnChangesSetting, project);
    }

    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiDoc(value="Sends an email notification to the email address that is set in the user profile. An alias for notify(subject, body, true).")
    public static final void sendMail(@NotNull XdUser $this$sendMail, @ApiDoc(value="The subject line of the email notification.") @NotNull String subject, @ApiDoc(value="The message text of the email notification.") @NotNull String body) {
        Intrinsics.checkParameterIsNotNull((Object)$this$sendMail, (String)"$this$sendMail");
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        ExtensionsKt.sendMail$default($this$sendMail, subject, body, null, false, null, 24, null);
    }

    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiDoc(value="Sends a notification message over Jabber. Similar to the `notify`\nmethod, the message won't be sent on own changes and corresponding flag unchecked.")
    public static final void sendJabber(@NotNull XdUser $this$sendJabber, @ApiDoc(value="The message text for the Jabber notification.") @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)$this$sendJabber, (String)"$this$sendJabber");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        BeansKt.getStatisticsService().incForInstance(new StatisticsFeatureDescription(STATISTICS_CATEGORY, STATISTICS_JABBER_TO_USER));
        if (ExtensionsKt.shouldNotify$default($this$sendJabber, null, 2, null)) {
            NotificationServiceKt.getNotificationService().notifyInstantJabber($this$sendJabber, message);
        }
    }

    private static final void sendMail(@NotNull XdUser $this$sendMail, String subject, String body, Entity currentUser, boolean ignoreNotifyOnOwnChangesSetting, XdProject project) {
        XdUser sender;
        BeansKt.getStatisticsService().incForInstance(new StatisticsFeatureDescription(STATISTICS_CATEGORY, STATISTICS_EMAIL_TO_USER));
        XdUser recipient2 = $this$sendMail;
        Entity entity = currentUser;
        Object object = sender = entity != null ? (XdUser)XdExtensionsKt.toXd((Entity)entity) : null;
        if (ignoreNotifyOnOwnChangesSetting || ExtensionsKt.shouldNotify(recipient2, sender)) {
            NotificationServiceKt.getNotificationService().notifyInstantEmail(recipient2, sender, project, subject, body);
        }
    }

    static /* synthetic */ void sendMail$default(XdUser xdUser, String string, String string2, Entity entity, boolean bl, XdProject xdProject, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            xdProject = null;
        }
        ExtensionsKt.sendMail(xdUser, string, string2, entity, bl, xdProject);
    }

    private static final boolean shouldNotify(XdUser to, XdUser from) {
        return to.getBanned() ? false : (Intrinsics.areEqual((Object)to, (Object)from) ? jetbrains.charisma.service.BeansKt.getUserProfileService().getNotificationsProfile(to).isNotifyOnOwnChanges() : true);
    }

    static /* synthetic */ boolean shouldNotify$default(XdUser xdUser, XdUser xdUser2, int n, Object object) {
        if ((n & 2) != 0) {
            xdUser2 = null;
        }
        return ExtensionsKt.shouldNotify(xdUser, xdUser2);
    }
}

