/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.sending;

import jetbrains.charisma.persistent.BeansKt;
import jetbrains.charisma.user.NotificationsUserProfile;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.api.notifications.NotificationCase;
import jetbrains.youtrack.api.notifications.NotificationData;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.notifications.main.NotificationPropertiesKt;
import jetbrains.youtrack.notifications.persistence.XdNotification;
import jetbrains.youtrack.notifications.persistence.XdOpenNotification;
import jetbrains.youtrack.notifications.persistence.XdUserNotification;
import jetbrains.youtrack.notifications.sending.EmailDataSendNotificationJob;
import jetbrains.youtrack.notifications.sending.EmailSendNotificationJob;
import jetbrains.youtrack.notifications.sending.EmailTextSendNotificationJob;
import jetbrains.youtrack.notifications.sending.NotificationChannel;
import jetbrains.youtrack.notifications.sending.NotificationJob;
import jetbrains.youtrack.notifications.sending.OpenEmailNotificationJob;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006\u000e"}, d2={"Ljetbrains/youtrack/notifications/sending/EmailChannel;", "Ljetbrains/youtrack/notifications/sending/NotificationChannel;", "()V", "isEnabled", "", "()Z", "createNotificationJob", "Ljetbrains/youtrack/notifications/sending/NotificationJob;", "notification", "Ljetbrains/youtrack/notifications/persistence/XdNotification;", "data", "Ljetbrains/youtrack/api/notifications/NotificationData;", "recipient", "Ljetbrains/exodus/entitystore/Entity;", "youtrack-notifications"})
public final class EmailChannel
implements NotificationChannel {
    @Override
    public boolean isEnabled() {
        return BeansKt.getXdNotificationsConfig().getEnableSmtp();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isEnabled(@NotNull Entity recipient2) {
        Intrinsics.checkParameterIsNotNull((Object)recipient2, (String)"recipient");
        XdUser xdUser = (XdUser)XdExtensionsKt.toXd((Entity)recipient2);
        NotificationsUserProfile recipientProfile = jetbrains.charisma.service.BeansKt.getUserProfileService().getNotificationsProfile(xdUser);
        if (!recipientProfile.isEmailNotificationsEnabled()) return false;
        CharSequence charSequence = xdUser.getEmail();
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null) return false;
        if (charSequence.length() != 0) return true;
        return false;
    }

    @Override
    @Nullable
    public NotificationJob createNotificationJob(@NotNull XdNotification notification, @NotNull NotificationData data) {
        NotificationJob notificationJob;
        Intrinsics.checkParameterIsNotNull((Object)((Object)notification), (String)"notification");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        XdNotification xdNotification = notification;
        if (xdNotification instanceof XdUserNotification) {
            NotificationCase notificationCase = ((XdUserNotification)notification).getCase();
            boolean isDataPersistable = notificationCase != null ? notificationCase.isDataPersistable() : false;
            notificationJob = isDataPersistable ? (EmailSendNotificationJob)new EmailDataSendNotificationJob((XdUserNotification)notification, data) : (data.get(NotificationPropertiesKt.getSubjectNotificationProperty()) != null ? (EmailSendNotificationJob)new EmailTextSendNotificationJob((XdUserNotification)notification, data) : null);
        } else if (xdNotification instanceof XdOpenNotification) {
            notificationJob = new OpenEmailNotificationJob((XdOpenNotification)notification, data);
        } else {
            throw (Throwable)new IllegalStateException("Can't create job based on " + (Object)((Object)notification));
        }
        return notificationJob;
    }
}

