/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.sending;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.annotation.PostConstruct;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import jetbrains.youtrack.api.notifications.MailSendListenerAdapter;
import jetbrains.youtrack.api.notifications.MailingService;
import jetbrains.youtrack.api.notifications.MessageSendListener;
import jetbrains.youtrack.api.webr.LocalScoped;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.notifications.sending.MailingServiceImpl;
import jetbrains.youtrack.service.ConnectionToRemoteHostNotAllowedException;
import jetbrains.youtrack.service.OutboundConnectionManager;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.mail.MailException;
import org.springframework.mail.MailMessage;
import org.springframework.mail.MailPreparationException;
import org.springframework.mail.MailSendException;
import org.springframework.mail.MailSender;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMailMessage;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;

@Service(value="mailingService")
@LocalScoped
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0007J&\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u001f2\u0014\u0010$\u001a\u0010\u0012\u0004\u0012\u00020&\u0012\u0006\u0012\u0004\u0018\u00010&0%H\u0016J0\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u001f2\u0014\u0010$\u001a\u0010\u0012\u0004\u0012\u00020&\u0012\u0006\u0012\u0004\u0018\u00010&0%2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00108\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u00020\u00168\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006)"}, d2={"Ljetbrains/youtrack/notifications/sending/MailingServiceImpl;", "Ljetbrains/youtrack/api/notifications/MailingService;", "()V", "mailSender", "Lorg/springframework/mail/javamail/JavaMailSenderImpl;", "getMailSender", "()Lorg/springframework/mail/javamail/JavaMailSenderImpl;", "setMailSender", "(Lorg/springframework/mail/javamail/JavaMailSenderImpl;)V", "outboundConnectionManager", "Ljetbrains/youtrack/service/OutboundConnectionManager;", "getOutboundConnectionManager", "()Ljetbrains/youtrack/service/OutboundConnectionManager;", "setOutboundConnectionManager", "(Ljetbrains/youtrack/service/OutboundConnectionManager;)V", "taskExecutor", "Lorg/springframework/core/task/TaskExecutor;", "getTaskExecutor", "()Lorg/springframework/core/task/TaskExecutor;", "setTaskExecutor", "(Lorg/springframework/core/task/TaskExecutor;)V", "templateMessage", "Lorg/springframework/mail/SimpleMailMessage;", "getTemplateMessage", "()Lorg/springframework/mail/SimpleMailMessage;", "setTemplateMessage", "(Lorg/springframework/mail/SimpleMailMessage;)V", "createCustomService", "sender", "Lorg/springframework/mail/MailSender;", "createMimeMessageHelper", "Lorg/springframework/mail/javamail/MimeMessageHelper;", "init", "", "send", "mailMessage", "customHeaders", "", "", "listener", "Ljetbrains/youtrack/api/notifications/MessageSendListener;", "youtrack-notifications"})
public final class MailingServiceImpl
implements MailingService {
    @Autowired
    @Qualifier(value="notificationsTaskExecutor")
    @NotNull
    public TaskExecutor taskExecutor;
    @Autowired
    @NotNull
    public JavaMailSenderImpl mailSender;
    @Autowired
    @NotNull
    public SimpleMailMessage templateMessage;
    @Autowired
    @NotNull
    public OutboundConnectionManager outboundConnectionManager;

    @NotNull
    public final TaskExecutor getTaskExecutor() {
        TaskExecutor taskExecutor = this.taskExecutor;
        if (taskExecutor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"taskExecutor");
        }
        return taskExecutor;
    }

    public final void setTaskExecutor(@NotNull TaskExecutor taskExecutor) {
        Intrinsics.checkParameterIsNotNull((Object)taskExecutor, (String)"<set-?>");
        this.taskExecutor = taskExecutor;
    }

    @NotNull
    public final JavaMailSenderImpl getMailSender() {
        JavaMailSenderImpl javaMailSenderImpl = this.mailSender;
        if (javaMailSenderImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mailSender");
        }
        return javaMailSenderImpl;
    }

    public final void setMailSender(@NotNull JavaMailSenderImpl javaMailSenderImpl) {
        Intrinsics.checkParameterIsNotNull((Object)javaMailSenderImpl, (String)"<set-?>");
        this.mailSender = javaMailSenderImpl;
    }

    @NotNull
    public final SimpleMailMessage getTemplateMessage() {
        SimpleMailMessage simpleMailMessage = this.templateMessage;
        if (simpleMailMessage == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"templateMessage");
        }
        return simpleMailMessage;
    }

    public final void setTemplateMessage(@NotNull SimpleMailMessage simpleMailMessage) {
        Intrinsics.checkParameterIsNotNull((Object)simpleMailMessage, (String)"<set-?>");
        this.templateMessage = simpleMailMessage;
    }

    @NotNull
    public final OutboundConnectionManager getOutboundConnectionManager() {
        OutboundConnectionManager outboundConnectionManager = this.outboundConnectionManager;
        if (outboundConnectionManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outboundConnectionManager");
        }
        return outboundConnectionManager;
    }

    public final void setOutboundConnectionManager(@NotNull OutboundConnectionManager outboundConnectionManager) {
        Intrinsics.checkParameterIsNotNull((Object)outboundConnectionManager, (String)"<set-?>");
        this.outboundConnectionManager = outboundConnectionManager;
    }

    @PostConstruct
    public final void init() {
        CommandMap commandMap = CommandMap.getDefaultCommandMap();
        if (commandMap == null) {
            throw new TypeCastException("null cannot be cast to non-null type javax.activation.MailcapCommandMap");
        }
        MailcapCommandMap mc = (MailcapCommandMap)commandMap;
        mc.addMailcap("text/html;; x-java-content-handler=com.sun.mail.handlers.text_html");
        mc.addMailcap("text/xml;; x-java-content-handler=com.sun.mail.handlers.text_xml");
        mc.addMailcap("text/plain;; x-java-content-handler=com.sun.mail.handlers.text_plain");
        mc.addMailcap("multipart/*;; x-java-content-handler=com.sun.mail.handlers.multipart_mixed");
        mc.addMailcap("message/rfc822;; x-java-content-handler=com.sun.mail.handlers.message_rfc822");
        CommandMap.setDefaultCommandMap((CommandMap)((CommandMap)mc));
        JavaMailSenderImpl javaMailSenderImpl = this.mailSender;
        if (javaMailSenderImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mailSender");
        }
        javaMailSenderImpl.setDefaultEncoding(StandardCharsets.UTF_8.name());
    }

    @NotNull
    public MailingService createCustomService(@NotNull MailSender sender) {
        Intrinsics.checkParameterIsNotNull((Object)sender, (String)"sender");
        MailingServiceImpl mailingServiceImpl = new MailingServiceImpl();
        boolean bl = false;
        boolean bl2 = false;
        MailingServiceImpl it = mailingServiceImpl;
        boolean bl3 = false;
        it.mailSender = (JavaMailSenderImpl)sender;
        it.templateMessage = new SimpleMailMessage();
        TaskExecutor taskExecutor = this.taskExecutor;
        if (taskExecutor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"taskExecutor");
        }
        it.taskExecutor = taskExecutor;
        OutboundConnectionManager outboundConnectionManager = this.outboundConnectionManager;
        if (outboundConnectionManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outboundConnectionManager");
        }
        it.outboundConnectionManager = outboundConnectionManager;
        return mailingServiceImpl;
    }

    @NotNull
    public MimeMessageHelper createMimeMessageHelper() {
        JavaMailSenderImpl javaMailSenderImpl = this.mailSender;
        if (javaMailSenderImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mailSender");
        }
        MimeMessageHelper helper = new MimeMessageHelper(javaMailSenderImpl.createMimeMessage(), true, "UTF-8");
        MimeMailMessage mimeMailMessage = new MimeMailMessage(helper);
        SimpleMailMessage simpleMailMessage = this.templateMessage;
        if (simpleMailMessage == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"templateMessage");
        }
        simpleMailMessage.copyTo((MailMessage)mimeMailMessage);
        return helper;
    }

    public void send(@NotNull MimeMessageHelper mailMessage, @NotNull Map<String, String> customHeaders) {
        Intrinsics.checkParameterIsNotNull((Object)mailMessage, (String)"mailMessage");
        Intrinsics.checkParameterIsNotNull(customHeaders, (String)"customHeaders");
        this.send(mailMessage, customHeaders, (MessageSendListener)new MailSendListenerAdapter());
    }

    public void send(@NotNull MimeMessageHelper mailMessage, @NotNull Map<String, String> customHeaders, @Nullable MessageSendListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)mailMessage, (String)"mailMessage");
        Intrinsics.checkParameterIsNotNull(customHeaders, (String)"customHeaders");
        boolean isDefaultConfig2 = (Boolean)LegacySupportKt.transactional((Function1)send.isDefaultConfig.1.INSTANCE);
        TaskExecutor taskExecutor = this.taskExecutor;
        if (taskExecutor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"taskExecutor");
        }
        taskExecutor.execute(new Runnable(this, isDefaultConfig2, mailMessage, customHeaders, listener2){
            final /* synthetic */ MailingServiceImpl this$0;
            final /* synthetic */ boolean $isDefaultConfig;
            final /* synthetic */ MimeMessageHelper $mailMessage;
            final /* synthetic */ Map $customHeaders;
            final /* synthetic */ MessageSendListener $listener;

            public void run() {
                block9: {
                    try {
                        Address[] addressArray;
                        MimeMessage mimeMessage;
                        if (this.this$0.getMailSender().getHost() != null) {
                            OutboundConnectionManager outboundConnectionManager = this.this$0.getOutboundConnectionManager();
                            String string = this.this$0.getMailSender().getHost();
                            if (string == null) {
                                Intrinsics.throwNpe();
                            }
                            if (!outboundConnectionManager.isConnectionAllowed(string) && !this.$isDefaultConfig) {
                                throw (Throwable)new MailPreparationException((Throwable)new ConnectionToRemoteHostNotAllowedException("Connection to host " + this.this$0.getMailSender().getHost() + " is not allowed"));
                            }
                        }
                        MimeMessage mimeMessage2 = mimeMessage = this.$mailMessage.getMimeMessage();
                        Intrinsics.checkExpressionValueIsNotNull((Object)mimeMessage2, (String)"mimeMessage");
                        this.removeDuplicateAddresses(mimeMessage2);
                        this.addCustomHeaders(mimeMessage, this.$customHeaders);
                        Address[] allRecipients = null;
                        try {
                            addressArray = mimeMessage.getAllRecipients();
                        }
                        catch (MessagingException e) {
                            throw (Throwable)new MailSendException("Can't get all recipients");
                        }
                        allRecipients = addressArray;
                        if (allRecipients != null) {
                            addressArray = allRecipients;
                            boolean bl = false;
                            Address[] addressArray2 = addressArray;
                            boolean bl2 = false;
                            if (!(addressArray2.length == 0)) {
                                this.this$0.getMailSender().send(mimeMessage);
                                MessageSendListener messageSendListener = this.$listener;
                                if (messageSendListener == null) break block9;
                                String[] stringArray = this.convert(allRecipients);
                                String string = mimeMessage.getMessageID();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mimeMessage.messageID");
                                messageSendListener.ok(stringArray, string);
                                break block9;
                            }
                        }
                        throw (Throwable)new MailSendException("Mail not sent. No recipients found.");
                    }
                    catch (MailException e) {
                        MessageSendListener messageSendListener = this.$listener;
                        if (messageSendListener == null) break block9;
                        messageSendListener.error((Exception)((Object)e));
                    }
                }
            }

            /*
             * WARNING - void declaration
             */
            private final void addCustomHeaders(MimeMessage mimeMessage, Map<String, String> customHeaders) {
                try {
                    Map<String, String> $this$forEach$iv = customHeaders;
                    boolean $i$f$forEach = false;
                    Map<String, String> map2 = $this$forEach$iv;
                    boolean bl = false;
                    Iterator<Map.Entry<String, String>> iterator = map2.entrySet().iterator();
                    while (iterator.hasNext()) {
                        void key;
                        Map.Entry<String, String> element$iv;
                        Map.Entry<String, String> $dstr$key$value = element$iv = iterator.next();
                        boolean bl2 = false;
                        Map.Entry<String, String> entry = $dstr$key$value;
                        boolean bl3 = false;
                        String string = entry.getKey();
                        entry = $dstr$key$value;
                        bl3 = false;
                        String value2 = entry.getValue();
                        mimeMessage.addHeader((String)key, value2);
                    }
                }
                catch (MessagingException e) {
                    throw (Throwable)new MailSendException("Can't add custom headers");
                }
            }

            private final void removeDuplicateAddresses(MimeMessage mimeMessage) {
                try {
                    Message.RecipientType recipientType = Message.RecipientType.TO;
                    Intrinsics.checkExpressionValueIsNotNull((Object)recipientType, (String)"Message.RecipientType.TO");
                    Set<Address> toAddresses = this.getRecipients(mimeMessage, recipientType);
                    Message.RecipientType recipientType2 = Message.RecipientType.CC;
                    Intrinsics.checkExpressionValueIsNotNull((Object)recipientType2, (String)"Message.RecipientType.CC");
                    Set<Address> ccAddresses = this.getRecipients(mimeMessage, recipientType2);
                    Message.RecipientType recipientType3 = Message.RecipientType.BCC;
                    Intrinsics.checkExpressionValueIsNotNull((Object)recipientType3, (String)"Message.RecipientType.BCC");
                    Set<Address> bccAddresses = this.getRecipients(mimeMessage, recipientType3);
                    Message.RecipientType recipientType4 = Message.RecipientType.TO;
                    Intrinsics.checkExpressionValueIsNotNull((Object)recipientType4, (String)"Message.RecipientType.TO");
                    this.setRecipients(mimeMessage, recipientType4, (Collection<? extends Address>)toAddresses);
                    Message.RecipientType recipientType5 = Message.RecipientType.CC;
                    Intrinsics.checkExpressionValueIsNotNull((Object)recipientType5, (String)"Message.RecipientType.CC");
                    this.setRecipients(mimeMessage, recipientType5, SetsKt.minus(ccAddresses, (Iterable)toAddresses));
                    Message.RecipientType recipientType6 = Message.RecipientType.BCC;
                    Intrinsics.checkExpressionValueIsNotNull((Object)recipientType6, (String)"Message.RecipientType.BCC");
                    this.setRecipients(mimeMessage, recipientType6, SetsKt.minus((Set)SetsKt.minus(bccAddresses, (Iterable)ccAddresses), (Iterable)toAddresses));
                }
                catch (MessagingException e) {
                    throw (Throwable)new MailSendException("Can't remove duplicate addresses", (Throwable)e);
                }
            }

            /*
             * WARNING - void declaration
             */
            private final String[] convert(Address[] addresses) {
                void $this$mapTo$iv$iv;
                Address[] $this$map$iv = addresses;
                boolean $i$f$map = false;
                Address[] addressArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                boolean $i$f$mapTo = false;
                void var7_7 = $this$mapTo$iv$iv;
                int n = ((void)var7_7).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var11_11 = item$iv$iv = var7_7[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string = it.toString();
                    collection.add(string);
                }
                Collection $this$toTypedArray$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                return stringArray;
            }

            private final Set<Address> getRecipients(MimeMessage mimeMessage, Message.RecipientType type) {
                Set set;
                Object object = mimeMessage.getRecipients(type);
                if (object != null && (object = ArraysKt.toHashSet((Object[])object)) != null) {
                    set = (Set)object;
                } else {
                    boolean bl = false;
                    set = SetsKt.emptySet();
                }
                return set;
            }

            private final void setRecipients(MimeMessage mimeMessage, Message.RecipientType type, Collection<? extends Address> addresses) {
                Address[] addressArray = null;
                if (!addresses.isEmpty()) {
                    Collection<? extends Address> $this$toTypedArray$iv = addresses;
                    boolean $i$f$toTypedArray = false;
                    Collection<? extends Address> thisCollection$iv = $this$toTypedArray$iv;
                    Address[] addressArray2 = thisCollection$iv.toArray(new Address[0]);
                    if (addressArray2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    addressArray = addressArray2;
                }
                mimeMessage.setRecipients(type, addressArray);
            }
            {
                this.this$0 = $outer;
                this.$isDefaultConfig = $captured_local_variable$1;
                this.$mailMessage = $captured_local_variable$2;
                this.$customHeaders = $captured_local_variable$3;
                this.$listener = $captured_local_variable$4;
            }
        });
    }
}

