/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.sending;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.youtrack.api.notifications.NotificationData;
import jetbrains.youtrack.notifications.data.NotificationsDataMapperKt;
import jetbrains.youtrack.notifications.persistence.XdNotification;
import jetbrains.youtrack.notifications.persistence.XdUserNotification;
import jetbrains.youtrack.notifications.sending.NotificationChannel;
import jetbrains.youtrack.notifications.sending.NotificationChannelService;
import jetbrains.youtrack.notifications.sending.NotificationJob;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="notificationChannelService")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\f\u001a\u00020\u000b*\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ljetbrains/youtrack/notifications/sending/NotificationChannelServiceImpl;", "Ljetbrains/youtrack/notifications/sending/NotificationChannelService;", "()V", "channels", "", "Ljetbrains/youtrack/notifications/sending/NotificationChannel;", "createNotificationJobs", "Ljetbrains/youtrack/notifications/sending/NotificationJob;", "notification", "Ljetbrains/youtrack/notifications/persistence/XdNotification;", "hasEnabledChannels", "", "isEnabledFor", "youtrack-notifications"})
public final class NotificationChannelServiceImpl
implements NotificationChannelService {
    @Autowired
    private List<? extends NotificationChannel> channels;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<NotificationJob> createNotificationJobs(@NotNull XdNotification notification) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)notification), (String)"notification");
        List<? extends NotificationChannel> list = this.channels;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"channels");
        }
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            NotificationJob notificationJob;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            NotificationChannel channel = (NotificationChannel)element$iv$iv;
            boolean bl2 = false;
            if (channel.isEnabled() && this.isEnabledFor(channel, notification)) {
                NotificationData data = NotificationsDataMapperKt.getNotificationsDataMapper().read(notification);
                notificationJob = channel.createNotificationJob(notification, data);
            } else {
                notificationJob = null;
            }
            if (notificationJob == null) continue;
            NotificationJob notificationJob2 = notificationJob;
            boolean bl3 = false;
            boolean bl4 = false;
            NotificationJob it$iv$iv = notificationJob2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isEnabledFor(@NotNull NotificationChannel $this$isEnabledFor, XdNotification notification) {
        return !(notification instanceof XdUserNotification) || $this$isEnabledFor.isEnabled(((XdUserNotification)notification).getRecipient().getEntity());
    }

    @Override
    public boolean hasEnabledChannels() {
        boolean bl;
        block4: {
            List<? extends NotificationChannel> list = this.channels;
            if (list == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"channels");
            }
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    NotificationChannel it = (NotificationChannel)element$iv;
                    boolean bl2 = false;
                    if (!it.isEnabled()) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }
}

