/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.sending;

import java.util.List;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.webr.userManagement.runtime.PrincipalManager;
import jetbrains.youtrack.api.notifications.NotificationCase;
import jetbrains.youtrack.api.notifications.NotificationData;
import jetbrains.youtrack.api.notifications.NotificationPropertiesKt;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.security.BeansKt;
import jetbrains.youtrack.notifications.NotificationService;
import jetbrains.youtrack.notifications.cluster.ClusterNotificationData;
import jetbrains.youtrack.notifications.cluster.DigestClusterNotificationCaseKt;
import jetbrains.youtrack.notifications.data.IssueEntitySnapshotAdapter;
import jetbrains.youtrack.notifications.main.DigestNotificationData;
import jetbrains.youtrack.notifications.persist.NotificationPersistJob;
import jetbrains.youtrack.notifications.persist.NotificationPersistService;
import jetbrains.youtrack.notifications.persist.NotificationPersistServiceKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service(value="notificationService")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J=\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0019\u0010\r\u001a\u0015\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n\u0018\u00010\u000e\u00a2\u0006\u0002\b\u000fH\u0016J4\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0018\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0015H\u0016\u00a8\u0006\u0019"}, d2={"Ljetbrains/youtrack/notifications/sending/NotificationServiceImpl;", "Ljetbrains/youtrack/notifications/NotificationService;", "()V", "createData", "Ljetbrains/youtrack/api/notifications/NotificationData;", "case", "Ljetbrains/youtrack/api/notifications/NotificationCase;", "ctxIssue", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "notifyCase", "", "recipient", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "updateData", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "notifyInstantEmail", "sender", "project", "Ljetbrains/youtrack/core/persistent/issue/XdProject;", "subject", "", "email", "notifyInstantJabber", "message", "youtrack-notifications"})
public final class NotificationServiceImpl
implements NotificationService {
    public void notifyInstantEmail(@NotNull XdUser recipient2, @Nullable XdUser sender, @Nullable XdProject project, @NotNull String subject, @NotNull String email) {
        Intrinsics.checkParameterIsNotNull((Object)recipient2, (String)"recipient");
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull((Object)email, (String)"email");
        NotificationPersistServiceKt.getNotificationPersistService().createEmailPersistJob(recipient2, sender, project, subject, email).persist();
    }

    public void notifyInstantJabber(@NotNull XdUser recipient2, @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)recipient2, (String)"recipient");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        NotificationPersistServiceKt.getNotificationPersistService().createJabberPersistJob(recipient2, message).persist();
    }

    public void notifyCase(@NotNull NotificationCase notificationCase, @NotNull XdUser recipient2, @Nullable XdIssue ctxIssue, @Nullable Function1<? super NotificationData, Unit> updateData) {
        Intrinsics.checkParameterIsNotNull((Object)notificationCase, (String)"case");
        Intrinsics.checkParameterIsNotNull((Object)recipient2, (String)"recipient");
        List jobs2 = NotificationPersistService.DefaultImpls.createNotificationPersistJobs$default(NotificationPersistServiceKt.getNotificationPersistService(), notificationCase, null, recipient2, (XdEntity)ctxIssue, null, null, (Function1)new Function1<NotificationData, Unit>(ctxIssue, recipient2, notificationCase, updateData){
            final /* synthetic */ XdIssue $ctxIssue;
            final /* synthetic */ XdUser $recipient;
            final /* synthetic */ NotificationCase $case;
            final /* synthetic */ Function1 $updateData;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull NotificationData $this$createNotificationPersistJobs) {
                block5: {
                    Intrinsics.checkParameterIsNotNull((Object)$this$createNotificationPersistJobs, (String)"$receiver");
                    XdIssue xdIssue = this.$ctxIssue;
                    if (xdIssue != null) {
                        IssueEntitySnapshotAdapter issueEntitySnapshotAdapter;
                        XdIssue xdIssue2 = xdIssue;
                        boolean bl = false;
                        boolean bl2 = false;
                        XdIssue it = xdIssue2;
                        boolean bl3 = false;
                        XdUser user$iv = this.$recipient;
                        boolean $i$f$runAs = false;
                        Entity user$iv$iv = user$iv.getEntity();
                        boolean $i$f$runAs2 = false;
                        PrincipalManager _principalManager$iv$iv = BeansKt.getPrincipalManager();
                        try {
                            _principalManager$iv$iv.setTemporaryServerPrincipal((Object)user$iv$iv);
                            boolean bl4 = false;
                            issueEntitySnapshotAdapter = new IssueEntitySnapshotAdapter(it);
                        }
                        finally {
                            _principalManager$iv$iv.unsetTemporaryServerPrincipal();
                        }
                        IssueEntitySnapshotAdapter snapshot = issueEntitySnapshotAdapter;
                        $this$createNotificationPersistJobs.set(NotificationPropertiesKt.getIssueNotificationProperty(), (Object)snapshot);
                    }
                    $this$createNotificationPersistJobs.set(NotificationPropertiesKt.getHeaderNotificationProperty(), (Object)this.$case.getHeader().getValue());
                    Function1 function1 = this.$updateData;
                    if (function1 == null) break block5;
                    Unit cfr_ignored_0 = (Unit)function1.invoke((Object)$this$createNotificationPersistJobs);
                }
            }
            {
                this.$ctxIssue = xdIssue;
                this.$recipient = xdUser;
                this.$case = notificationCase;
                this.$updateData = function1;
                super(1);
            }
        }, 48, null);
        Iterable $this$forEach$iv = jobs2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NotificationPersistJob it = (NotificationPersistJob)element$iv;
            boolean bl = false;
            it.persist();
        }
    }

    @NotNull
    public NotificationData createData(@Nullable NotificationCase notificationCase, @Nullable XdIssue ctxIssue) {
        NotificationData notificationData;
        NotificationCase notificationCase2 = notificationCase;
        if (Intrinsics.areEqual((Object)notificationCase2, (Object)DigestClusterNotificationCaseKt.getDigestClusterNotificationCase())) {
            XdIssue xdIssue = ctxIssue;
            notificationData = new ClusterNotificationData((Entity)(xdIssue != null ? xdIssue.getEntity() : null));
        } else {
            XdIssue xdIssue = ctxIssue;
            notificationData = new DigestNotificationData((Entity)(xdIssue != null ? xdIssue.getEntity() : null));
        }
        return notificationData;
    }
}

