/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.slack;

import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import jetbrains.charisma.main.ConfigurationUtil;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.charisma.persistent.security.PrincipalsKt;
import jetbrains.gap.resource.Resource;
import jetbrains.jetpass.api.Service;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.l10n.YouTrackLocalizer;
import jetbrains.youtrack.api.ring.RingServiceDiscovery;
import jetbrains.youtrack.api.slack.SlackApplicationService;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.notifications.slack.SlackUrl;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="admin/slack")
@Produces(value={"application/json"})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0002H\u0007J\b\u0010\u0015\u001a\u00020\u0002H\u0007R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\r8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\u000f8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ljetbrains/youtrack/notifications/slack/SlackIntegrationResource;", "Ljetbrains/gap/resource/Resource;", "Ljetbrains/youtrack/notifications/slack/SlackUrl;", "()V", "httpClient", "Ljavax/ws/rs/client/WebTarget;", "getHttpClient", "()Ljavax/ws/rs/client/WebTarget;", "localizer", "Ljetbrains/youtrack/api/l10n/YouTrackLocalizer;", "getLocalizer", "()Ljetbrains/youtrack/api/l10n/YouTrackLocalizer;", "ringServiceDiscovery", "Ljetbrains/youtrack/api/ring/RingServiceDiscovery;", "slackApplicationService", "Ljetbrains/youtrack/api/slack/SlackApplicationService;", "assertCanAccess", "", "updateAppPermission", "", "bind", "getConfig", "Companion", "youtrack-notifications"})
public final class SlackIntegrationResource
implements Resource<SlackUrl> {
    @Autowired
    private RingServiceDiscovery ringServiceDiscovery;
    @Autowired
    private SlackApplicationService slackApplicationService;
    public static final Companion Companion = new Companion(null);

    private final YouTrackLocalizer getLocalizer() {
        String name$iv = "localizer";
        boolean $i$f$getBean = false;
        Object object = ServiceLocator.getBean((String)name$iv);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.api.l10n.YouTrackLocalizer");
        }
        return (YouTrackLocalizer)object;
    }

    private final WebTarget getHttpClient() {
        Client config = ((ClientBuilder)((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().property("jersey.config.client.connectTimeout", (Object)((int)TimeUnit.MINUTES.toMillis(1L)))).property("jersey.config.client.readTimeout", (Object)((int)TimeUnit.MINUTES.toMillis(1L)))).property("jersey.config.client.followRedirects", (Object)false)).build();
        StringBuilder stringBuilder = new StringBuilder();
        SlackApplicationService slackApplicationService = this.slackApplicationService;
        if (slackApplicationService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"slackApplicationService");
        }
        String string = slackApplicationService.getUrl();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        WebTarget webTarget = config.target(stringBuilder.append(StringsKt.trimEnd((String)string, (char[])new char[]{'/'})).append("/youtrack/authorize").toString());
        Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"config.target(slackAppli\u2026 + \"/youtrack/authorize\")");
        return webTarget;
    }

    @GET
    @NotNull
    public final SlackUrl getConfig() {
        this.assertCanAccess(false);
        SlackApplicationService slackApplicationService = this.slackApplicationService;
        if (slackApplicationService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"slackApplicationService");
        }
        return new SlackUrl(slackApplicationService.getUrl());
    }

    @POST
    @NotNull
    public final SlackUrl bind() {
        SlackIntegrationResource.assertCanAccess$default(this, false, 1, null);
        SlackApplicationService slackApplicationService = this.slackApplicationService;
        if (slackApplicationService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"slackApplicationService");
        }
        CharSequence charSequence = slackApplicationService.getUrl();
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            Response response;
            Service konnectorService;
            RingServiceDiscovery ringServiceDiscovery = this.ringServiceDiscovery;
            if (ringServiceDiscovery == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"ringServiceDiscovery");
            }
            if ((konnectorService = ringServiceDiscovery.firstByType("YouTrack Slack Integration")) == null) {
                String string = this.getLocalizer().localizedMsg("Slack.Cant_find_slack_service_in_hub", new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"\u2026nd_slack_service_in_hub\")");
                String msg = string;
                Companion.getLogger().error(msg);
                throw (Throwable)new BadRequestException(msg);
            }
            MultivaluedHashMap multivaluedHashMap = new MultivaluedHashMap();
            boolean bl3 = false;
            boolean bl4 = false;
            MultivaluedHashMap $this$apply = multivaluedHashMap;
            boolean bl5 = false;
            $this$apply.add((Object)"baseUrl", (Object)BeansKt.getXdNotificationsConfig().getBaseUrl());
            $this$apply.add((Object)"service.id", (Object)konnectorService.getId());
            $this$apply.add((Object)"service.secret", (Object)konnectorService.getSecret());
            MultivaluedHashMap formData = multivaluedHashMap;
            Response response2 = response = this.getHttpClient().request().post(Entity.form((MultivaluedMap)((MultivaluedMap)formData)));
            Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
            Response.StatusType statusType = response2.getStatusInfo();
            Intrinsics.checkExpressionValueIsNotNull((Object)statusType, (String)"response.statusInfo");
            if (statusType.getFamily() != Response.Status.Family.REDIRECTION) {
                Response.StatusType statusType2 = response.getStatusInfo();
                Intrinsics.checkExpressionValueIsNotNull((Object)statusType2, (String)"response.statusInfo");
                if (statusType2.getFamily() != Response.Status.Family.SUCCESSFUL) {
                    String string = this.getLocalizer().localizedMsg("Slack.Unsupported_status_code_for_further_binding", new Object[]{response.getStatus(), response.getStatus()});
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"\u2026.status, response.status)");
                    String msg = string;
                    Companion.getLogger().error(msg);
                    throw (Throwable)new BadRequestException(ConfigurationUtil.isYoutrackHosted() ? msg : msg + ' ' + this.getLocalizer().localizedMsg("Slack.Make_sure_youtrack_can_be_reached_from_the_internet", new Object[0]));
                }
            }
            List list = (List)response.getHeaders().get((Object)"Location");
            String location = (String)(list != null ? CollectionsKt.first((List)list) : null);
            if (location == null) {
                YouTrackLocalizer youTrackLocalizer = this.getLocalizer();
                Object[] objectArray = new Object[1];
                SlackApplicationService slackApplicationService2 = this.slackApplicationService;
                if (slackApplicationService2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"slackApplicationService");
                }
                objectArray[0] = slackApplicationService2.getUrl();
                String string = youTrackLocalizer.localizedMsg("Slack.Cant_determine_redirect_location_from_Slack", objectArray);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"\u2026ckApplicationService.url)");
                String msg = string;
                Companion.getLogger().error(msg);
                throw (Throwable)new BadRequestException(msg);
            }
            return new SlackUrl(location);
        }
        String string = this.getLocalizer().localizedMsg("Slack.Application_url_is_empty", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"\u2026pplication_url_is_empty\")");
        String msg = string;
        Companion.getLogger().error(msg);
        throw (Throwable)new BadRequestException(msg);
    }

    private final void assertCanAccess(boolean updateAppPermission) {
        Permission requiredPermission;
        Permission permission = requiredPermission = updateAppPermission ? Permission.ADMIN_UPDATE_APP : Permission.ADMIN_READ_APP;
        if (!PrincipalsKt.hasPermission((jetbrains.exodus.entitystore.Entity)((jetbrains.exodus.entitystore.Entity)BeansKt.getLoggedInUser()), (Permission)requiredPermission)) {
            throw (Throwable)new ForbiddenException();
        }
    }

    static /* synthetic */ void assertCanAccess$default(SlackIntegrationResource slackIntegrationResource, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        slackIntegrationResource.assertCanAccess(bl);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/notifications/slack/SlackIntegrationResource$Companion;", "Lmu/KLogging;", "()V", "youtrack-notifications"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

