/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.util;

import java.io.StringWriter;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import jetbrains.youtrack.notifications.main.TemplateRenderTimedOutException;
import jetbrains.youtrack.notifications.util.TimeAndSizeLimitedStringWriter;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\"\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\"\u0010\u000b\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ljetbrains/youtrack/notifications/util/TimeAndSizeLimitedStringWriter;", "Ljava/io/StringWriter;", "()V", "creationTime", "", "size", "Ljava/util/concurrent/atomic/AtomicInteger;", "assertSizeAndTimeout", "", "delta", "", "write", "cbuf", "", "off", "len", "c", "str", "", "Companion", "youtrack-notifications"})
public class TimeAndSizeLimitedStringWriter
extends StringWriter {
    private final AtomicInteger size = new AtomicInteger(0);
    private final long creationTime = System.currentTimeMillis();
    private static final int MAX_RENDERED_NOTIFICATION_SIZE;
    private static final int MAX_NOTIFICATION_RENDER_TIME;
    public static final Companion Companion;

    @Override
    public void write(int c) {
        this.assertSizeAndTimeout(1);
        super.write(c);
    }

    @Override
    public void write(@Nullable char[] cbuf, int off, int len) {
        this.assertSizeAndTimeout(len);
        super.write(cbuf, off, len);
    }

    @Override
    public void write(@NotNull String str) {
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        this.assertSizeAndTimeout(str.length());
        super.write(str);
    }

    @Override
    public void write(@Nullable String str, int off, int len) {
        this.assertSizeAndTimeout(len);
        super.write(str, off, len);
    }

    private final void assertSizeAndTimeout(int delta) {
        if (MAX_RENDERED_NOTIFICATION_SIZE != 0 && this.size.addAndGet(delta) > MAX_RENDERED_NOTIFICATION_SIZE) {
            TemplateRenderTimedOutException error2 = new TemplateRenderTimedOutException("Maximum notification size limit exceeded. Check your notification templates for loops and recursive inclusion");
            Companion.getLogger().error((Throwable)error2, (Function0)assertSizeAndTimeout.1.INSTANCE);
            throw (Throwable)error2;
        }
        if (MAX_NOTIFICATION_RENDER_TIME != 0 && System.currentTimeMillis() - this.creationTime > (long)MAX_NOTIFICATION_RENDER_TIME) {
            TemplateRenderTimedOutException error3 = new TemplateRenderTimedOutException("Maximum notification render time limit exceeded. Check your notification templates for loops and recursive inclusion");
            Companion.getLogger().error((Throwable)error3, (Function0)assertSizeAndTimeout.2.INSTANCE);
            throw (Throwable)error3;
        }
    }

    static {
        Companion = new Companion(null);
        Integer n = Integer.getInteger("jetbrains.youtrack.notification.max_notification_size", 0x100000);
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"Integer.getInteger(\"jetb\u2026ification_size\", 1048576)");
        MAX_RENDERED_NOTIFICATION_SIZE = n;
        Integer n2 = Integer.getInteger("jetbrains.youtrack.notification.max_notification_render_time", (int)TimeUnit.MINUTES.toMillis(1L));
        Intrinsics.checkExpressionValueIsNotNull((Object)n2, (String)"Integer.getInteger(\"jetb\u2026UTES.toMillis(1).toInt())");
        MAX_NOTIFICATION_RENDER_TIME = n2;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/notifications/util/TimeAndSizeLimitedStringWriter$Companion;", "Lmu/KLogging;", "()V", "MAX_NOTIFICATION_RENDER_TIME", "", "getMAX_NOTIFICATION_RENDER_TIME", "()I", "MAX_RENDERED_NOTIFICATION_SIZE", "getMAX_RENDERED_NOTIFICATION_SIZE", "youtrack-notifications"})
    public static final class Companion
    extends KLogging {
        public final int getMAX_RENDERED_NOTIFICATION_SIZE() {
            return MAX_RENDERED_NOTIFICATION_SIZE;
        }

        public final int getMAX_NOTIFICATION_RENDER_TIME() {
            return MAX_NOTIFICATION_RENDER_TIME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

