/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.rest.customfields;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import jetbrains.charisma.customfields.persistence.XdCustomFieldPrototype;
import jetbrains.charisma.customfields.persistence.XdProjectCustomField;
import jetbrains.charisma.customfields.persistence.XdProjectCustomFieldKt;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.mps.webr.runtime.uri.QueryParameter;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.rest.ResponseUtilKt;
import jetbrains.youtrack.rest.customfields.OldRestBundleServiceImplKt;
import jetbrains.youtrack.rest.customfields.OldRestProjectCustomFieldsResource;
import jetbrains.youtrack.rest.customfields.ProjectCustomFieldBean;
import jetbrains.youtrack.rest.customfields.ProjectCustomFieldRef;
import jetbrains.youtrack.rest.security.IsLoggedInSecurityConstraint;
import jetbrains.youtrack.rest.user.UserRestUtilKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.query.XdSearchingNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import webr.framework.url.UrlUtil;

@Path(value="/admin/project/{project}/customfield")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@Transactional
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u0006H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\"\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u001c\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u0006H\u0007J2\u0010\u0017\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u00062\n\b\u0001\u0010\u0018\u001a\u0004\u0018\u00010\u00062\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0007J4\u0010\u001b\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u00062\n\b\u0001\u0010\u0018\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0007\u00a8\u0006\u001d"}, d2={"Ljetbrains/youtrack/rest/customfields/OldRestProjectCustomFieldsResource;", "Ljetbrains/mps/webr/rpc/rest/runtime/Resource;", "()V", "deleteCustomFieldName", "Ljavax/ws/rs/core/Response;", "project", "", "customFieldName", "findExistedPrototype", "Ljetbrains/charisma/customfields/persistence/XdCustomFieldPrototype;", "name", "findField", "Ljetbrains/charisma/customfields/persistence/XdProjectCustomField;", "Ljetbrains/youtrack/core/persistent/issue/XdProject;", "fieldName", "shouldExist", "", "findProject", "get", "", "Ljetbrains/youtrack/rest/customfields/ProjectCustomFieldRef;", "getCustomFieldName", "Ljetbrains/youtrack/rest/customfields/ProjectCustomFieldBean;", "postCustomFieldName", "emptyFieldText", "uriInfo", "Ljavax/ws/rs/core/UriInfo;", "putCustomFieldName", "Companion", "youtrack-old-rest"})
public final class OldRestProjectCustomFieldsResource
implements Resource {
    public static final Companion Companion = new Companion(null);

    @GET
    @NotNull
    public final List<ProjectCustomFieldRef> get(@PathParam(value="project") @NotNull String project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        IsLoggedInSecurityConstraint.INSTANCE.check();
        XdProject xdProject = this.findProject(project);
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)XdQueryKt.asSequence((XdQuery)XdProjectCustomFieldKt.getSortedFields((XdProject)xdProject)), (Function1)get.1.INSTANCE), (Function1)get.2.INSTANCE));
    }

    @GET
    @Path(value="/{customFieldName}")
    @NotNull
    public final ProjectCustomFieldBean getCustomFieldName(@PathParam(value="project") @NotNull String project, @PathParam(value="customFieldName") @NotNull String customFieldName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)customFieldName, (String)"customFieldName");
        IsLoggedInSecurityConstraint.INSTANCE.check();
        OldRestBundleServiceImplKt.assertHasReadPermissionToProjectField(project, customFieldName);
        XdProjectCustomField xdProjectCustomField = this.findField(this.findProject(project), customFieldName, true);
        if (xdProjectCustomField == null) {
            Intrinsics.throwNpe();
        }
        return new ProjectCustomFieldBean(xdProjectCustomField);
    }

    /*
     * WARNING - void declaration
     */
    @PUT
    @Path(value="/{customFieldName}")
    @NotNull
    public final Response putCustomFieldName(@PathParam(value="project") @NotNull String project, @PathParam(value="customFieldName") @NotNull String customFieldName, @QueryParam(value="emptyFieldText") @Nullable String emptyFieldText, @Context @Nullable UriInfo uriInfo) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)customFieldName, (String)"customFieldName");
        IsLoggedInSecurityConstraint.INSTANCE.check();
        XdProject xdProject = this.findProject(project);
        UserRestUtilKt.assertHasPermission(Permission.UPDATE_PROJECT, xdProject);
        this.findField(xdProject, customFieldName, false);
        XdCustomFieldPrototype prototype = this.findExistedPrototype(customFieldName);
        XdProjectCustomField field2 = prototype.getType().getProjectCustomField(xdProject, prototype);
        if (emptyFieldText != null) {
            field2.setNullValueText(emptyFieldText);
        }
        if (uriInfo != null) {
            Map map;
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            MultivaluedMap multivaluedMap = uriInfo.getQueryParameters();
            Intrinsics.checkExpressionValueIsNotNull((Object)multivaluedMap, (String)"uriInfo.queryParameters");
            Map map2 = (Map)multivaluedMap;
            XdProjectCustomField xdProjectCustomField = field2;
            boolean $i$f$mapValues = false;
            void var10_11 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl = false;
                Object k = it$iv$iv.getKey();
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k2 = k;
                map = map3;
                boolean bl2 = false;
                Object v = it.getValue();
                Intrinsics.checkExpressionValueIsNotNull(v, (String)"it.value");
                String string = (String)CollectionsKt.first((List)((List)v));
                map.put(k2, string);
            }
            map = destination$iv$iv;
            OldRestBundleServiceImplKt.setAdditionalParams(xdProjectCustomField, map);
        }
        ResponseUtilKt.waitForPermissionCacheRecalculation();
        UrlUtil.Url url = Companion.urlOf(xdProject, customFieldName);
        Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"urlOf(xdProject, customFieldName)");
        return ResponseUtilKt.created(url);
    }

    /*
     * WARNING - void declaration
     */
    @POST
    @Path(value="/{customFieldName}")
    @NotNull
    public final Response postCustomFieldName(@PathParam(value="project") @NotNull String project, @PathParam(value="customFieldName") @NotNull String customFieldName, @QueryParam(value="emptyFieldText") @Nullable String emptyFieldText, @Context @NotNull UriInfo uriInfo) {
        Map map;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)customFieldName, (String)"customFieldName");
        Intrinsics.checkParameterIsNotNull((Object)uriInfo, (String)"uriInfo");
        IsLoggedInSecurityConstraint.INSTANCE.check();
        XdProject xdProject = this.findProject(project);
        UserRestUtilKt.assertHasPermission(Permission.UPDATE_PROJECT, xdProject);
        XdProjectCustomField xdProjectCustomField = this.findField(xdProject, customFieldName, true);
        if (xdProjectCustomField == null) {
            Intrinsics.throwNpe();
        }
        XdProjectCustomField field2 = xdProjectCustomField;
        if (emptyFieldText != null) {
            field2.setNullValueText(emptyFieldText);
        }
        MultivaluedMap multivaluedMap = uriInfo.getQueryParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)multivaluedMap, (String)"uriInfo.queryParameters");
        Map map2 = (Map)multivaluedMap;
        XdProjectCustomField xdProjectCustomField2 = field2;
        boolean $i$f$mapValues = false;
        void var9_10 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            map = map3;
            boolean bl2 = false;
            Object v = it.getValue();
            Intrinsics.checkExpressionValueIsNotNull(v, (String)"it.value");
            String string = (String)CollectionsKt.first((List)((List)v));
            map.put(k2, string);
        }
        map = destination$iv$iv;
        OldRestBundleServiceImplKt.setAdditionalParams(xdProjectCustomField2, map);
        ResponseUtilKt.waitForPermissionCacheRecalculation();
        UrlUtil.Url url = Companion.urlOf(xdProject, customFieldName);
        Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"urlOf(xdProject, customFieldName)");
        return ResponseUtilKt.updated(url, customFieldName, customFieldName);
    }

    @DELETE
    @Path(value="/{customFieldName}")
    @NotNull
    public final Response deleteCustomFieldName(@PathParam(value="project") @NotNull String project, @PathParam(value="customFieldName") @NotNull String customFieldName) {
        Response response;
        XdProjectCustomField field2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)customFieldName, (String)"customFieldName");
        IsLoggedInSecurityConstraint.INSTANCE.check();
        XdProject xdProject = this.findProject(project);
        UserRestUtilKt.assertHasPermission(Permission.UPDATE_PROJECT, xdProject);
        XdProjectCustomField xdProjectCustomField = this.findField(xdProject, customFieldName, true);
        if (xdProjectCustomField == null) {
            Intrinsics.throwNpe();
        }
        if (XdQueryKt.size((XdQuery)(field2 = xdProjectCustomField).getIssuesWithValues()) > 0) {
            Response response2 = Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).tag("Custom field has usages. Can't delete it").build();
            response = response2;
            Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"Response.status(Response\u2026Can't delete it\").build()");
        } else {
            response = ResponseUtilKt.deleted((XdEntity)field2, true);
        }
        return response;
    }

    private final XdCustomFieldPrototype findExistedPrototype(String name) {
        XdCustomFieldPrototype prototype = XdCustomFieldPrototype.Companion.findPrototype(name);
        if (prototype == null) {
            ResponseUtilKt.assertExist("Custom field prototype", null, name, true);
        }
        XdCustomFieldPrototype xdCustomFieldPrototype = prototype;
        if (xdCustomFieldPrototype == null) {
            Intrinsics.throwNpe();
        }
        return xdCustomFieldPrototype;
    }

    private final XdProject findProject(String project) {
        XdEntity xdEntity = XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdProject.Companion), (Function2)((Function2)new Function2<FilteringContext, XdProject, XdSearchingNode>(project){
            final /* synthetic */ String $project;

            @NotNull
            public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdProject it) {
                Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return $this$filter.eq((Comparable)((Object)it.getShortName()), (Comparable)((Object)this.$project));
            }
            {
                this.$project = string;
                super(2);
            }
        })));
        boolean bl = false;
        boolean bl2 = false;
        XdProject it = (XdProject)xdEntity;
        boolean bl3 = false;
        if (it == null) {
            ResponseUtilKt.assertExist("Project", null, project, true);
        }
        XdEntity xdEntity2 = xdEntity;
        if (xdEntity2 == null) {
            Intrinsics.throwNpe();
        }
        return (XdProject)xdEntity2;
    }

    private final XdProjectCustomField findField(XdProject project, String fieldName, boolean shouldExist) {
        XdProjectCustomField field2 = (XdProjectCustomField)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdQuery)((XdQuery)XdProjectCustomFieldKt.getFields((XdProject)project)), (Function2)((Function2)new Function2<FilteringContext, XdProjectCustomField, XdSearchingNode>(fieldName){
            final /* synthetic */ String $fieldName;

            @NotNull
            public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdProjectCustomField it) {
                Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return $this$filter.eq((Comparable)((Object)it.getPrototype().getName()), (Comparable)((Object)this.$fieldName));
            }
            {
                this.$fieldName = string;
                super(2);
            }
        })));
        ResponseUtilKt.assertExist("Project custom field", field2, fieldName, shouldExist);
        return field2;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Ljetbrains/youtrack/rest/customfields/OldRestProjectCustomFieldsResource$Companion;", "", "()V", "urlOf", "Lwebr/framework/url/UrlUtil$Url;", "kotlin.jvm.PlatformType", "project", "Ljetbrains/youtrack/core/persistent/issue/XdProject;", "name", "", "youtrack-old-rest"})
    public static final class Companion {
        public final UrlUtil.Url urlOf(@NotNull XdProject project, @NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            return UrlUtil.getRestPathUri((String[])new String[]{"admin", "project", project.getShortName(), "customfield"}).addPathElements(new String[]{name}).addQueryParameters(new QueryParameter[0]);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

