/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.rest.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.mps.webr.rpc.rest.runtime.Transformer;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.event.persistent.EventQueryKt;
import jetbrains.youtrack.event.persistent.XdAbstractEvent;
import jetbrains.youtrack.rest.event.DebugEventVO;
import jetbrains.youtrack.rest.event.EventVO;
import jetbrains.youtrack.rest.event.EventsRest;
import jetbrains.youtrack.rest.event.IssueEventVO;
import jetbrains.youtrack.rest.issue.AccessRestUtilKt;
import jetbrains.youtrack.rest.security.HasAdminReadSecurityConstraint;
import jetbrains.youtrack.rest.security.IsLoggedInSecurityConstraint;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@Path(value="/event")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@Transactional
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\b\b\u0001\u0010\u0006\u001a\u00020\u0007H\u0007J7\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0001\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00042\b\b\u0001\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\u0013"}, d2={"Ljetbrains/youtrack/rest/event/EventsResource;", "Ljetbrains/mps/webr/rpc/rest/runtime/Resource;", "()V", "debugIssue", "", "Ljetbrains/youtrack/rest/event/DebugEventVO;", "issue", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "get", "Ljetbrains/youtrack/rest/event/EventVO;", "from", "", "maxResults", "", "compact", "", "(Ljava/lang/Long;Ljava/lang/Integer;Ljava/lang/Boolean;)Ljava/util/List;", "issueEvents", "Ljetbrains/youtrack/rest/event/IssueEventVO;", "youtrack-old-rest"})
public final class EventsResource
implements Resource {
    @GET
    @Path(value="/issueEvents/{issue}")
    @Produces(value={"application/json"})
    @NotNull
    public final List<IssueEventVO> issueEvents(@Transformer(value="xdIssueById") @PathParam(value="issue") @NotNull XdIssue issue2) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        IsLoggedInSecurityConstraint.INSTANCE.check();
        AccessRestUtilKt.checkAccess(issue2, Operation.PRIVATE_READ);
        return EventsRest.INSTANCE.eventsFor(issue2);
    }

    @GET
    @Produces(value={"application/json"})
    @NotNull
    public final List<EventVO> get(@QueryParam(value="from") @Nullable Long from, @QueryParam(value="maxResults") @Nullable Integer maxResults, @QueryParam(value="compact") @Nullable Boolean compact) {
        IsLoggedInSecurityConstraint.INSTANCE.check();
        HasAdminReadSecurityConstraint.Companion.check();
        return EventsRest.INSTANCE.findEvents(from, maxResults, compact);
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Path(value="/debug/{issue}")
    @Produces(value={"application/json"})
    @Nullable
    public final List<DebugEventVO> debugIssue(@Transformer(value="xdIssueById") @PathParam(value="issue") @NotNull XdIssue issue2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        IsLoggedInSecurityConstraint.INSTANCE.check();
        HasAdminReadSecurityConstraint.Companion.check();
        Iterable $this$map$iv = XdQueryKt.asIterable((XdQuery)EventQueryKt.getRealEventsDirect((XdEntity)((XdEntity)issue2), null));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            XdAbstractEvent xdAbstractEvent = (XdAbstractEvent)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            DebugEventVO debugEventVO = new DebugEventVO((XdAbstractEvent)it);
            collection.add(debugEventVO);
        }
        return (List)destination$iv$iv;
    }
}

