/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.rest.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.mps.webr.rpc.rest.runtime.Transformer;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.event.persistent.EventQueryKt;
import jetbrains.youtrack.event.persistent.XdAbstractEvent;
import jetbrains.youtrack.event.rollback.RollbackMethodsKt;
import jetbrains.youtrack.eventSource.BeansKt;
import jetbrains.youtrack.rest.event.IssueChangesVO;
import jetbrains.youtrack.rest.event.IssueEventsResource;
import jetbrains.youtrack.rest.issue.AccessRestUtilKt;
import jetbrains.youtrack.rest.issue.beans.Issue;
import jetbrains.youtrack.rest.security.IsLoggedInSecurityConstraint;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@Path(value="/issue")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@Transactional
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\"\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fH\u0002J9\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\b\u0001\u0010\u0005\u001a\u00020\u00062\n\b\u0001\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u000e\b\u0001\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fH\u0007\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Ljetbrains/youtrack/rest/event/IssueEventsResource;", "Ljetbrains/mps/webr/rpc/rest/runtime/Resource;", "()V", "getIssueChanges", "Ljetbrains/youtrack/rest/event/IssueChangesVO;", "issue", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "getShouldInclude", "Lkotlin/Function1;", "", "", "with", "", "issueHistory", "", "Ljetbrains/youtrack/rest/issue/beans/Issue;", "max", "", "(Ljetbrains/youtrack/core/persistent/issue/XdIssue;Ljava/lang/Integer;Ljava/util/Set;)Ljava/util/List;", "youtrack-old-rest"})
public final class IssueEventsResource
implements Resource {
    @GET
    @Path(value="/{issue}/changes")
    @NotNull
    public final IssueChangesVO getIssueChanges(@Transformer(value="xdIssueById") @PathParam(value="issue") @NotNull XdIssue issue2) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        IsLoggedInSecurityConstraint.INSTANCE.check();
        AccessRestUtilKt.checkAccess(issue2, Operation.READ);
        return new IssueChangesVO(issue2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{issue}/history")
    @NotNull
    public final List<Issue> issueHistory(@Transformer(value="xdIssueById") @PathParam(value="issue") @NotNull XdIssue issue2, @QueryParam(value="max") @Nullable Integer max, @QueryParam(value="with") @NotNull Set<String> with) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        Intrinsics.checkParameterIsNotNull(with, (String)"with");
        IsLoggedInSecurityConstraint.INSTANCE.check();
        AccessRestUtilKt.checkAccess(issue2, Operation.READ);
        boolean bl = false;
        ArrayList<Issue> result2 = new ArrayList<Issue>();
        long idle = BeansKt.getEventMergeProvider().getMergeIdleTime();
        try {
            XdIssue issueAfterEvent = issue2;
            XdUser previousAuthor = null;
            long previousTimestamp = Long.MAX_VALUE;
            Iterator iterator = XdQueryKt.iterator((XdQuery)EventQueryKt.getEventsReversed$default((XdEntity)((XdEntity)issue2), null, (int)1, null));
            while (iterator.hasNext()) {
                XdAbstractEvent ape = (XdAbstractEvent)iterator.next();
                XdUser author = ape.getAuthor();
                long timestamp = ape.getTimestamp();
                if (Intrinsics.areEqual((Object)author, (Object)previousAuthor) ^ true || previousTimestamp - timestamp > idle) {
                    XdIssue xdIssue = issueAfterEvent;
                    if (xdIssue != null) {
                        xdIssue.setUpdated(timestamp);
                    }
                    XdIssue xdIssue2 = issueAfterEvent;
                    if (xdIssue2 != null) {
                        xdIssue2.setUpdatedBy(author);
                    }
                    if (issueAfterEvent != null) {
                        result2.add(new Issue(issueAfterEvent, false, false, this.getShouldInclude(with)));
                    }
                    if (max != null && result2.size() == max.intValue()) {
                        break;
                    }
                }
                XdIssue xdIssue = issueAfterEvent;
                issueAfterEvent = xdIssue != null ? (XdIssue)RollbackMethodsKt.rollback((XdEntity)((XdEntity)xdIssue), (XdAbstractEvent)ape) : null;
                previousAuthor = author;
                previousTimestamp = timestamp;
            }
        }
        finally {
            LegacySupportKt.revert();
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final Function1<String, Boolean> getShouldInclude(Set<String> with) {
        Collection collection = with;
        boolean bl = false;
        if (!collection.isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = with;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string;
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl2 = false;
                void var12_13 = it;
                boolean bl3 = false;
                void v0 = var12_13;
                if (v0 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)v0.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
                collection2.add(string);
            }
            List lowerCased = (List)destination$iv$iv;
            return (Function1)new Function1<String, Boolean>(lowerCased){
                final /* synthetic */ List $lowerCased;

                public final boolean invoke(@NotNull String name) {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    String string = name;
                    List list = this.$lowerCased;
                    boolean bl = false;
                    String string2 = string.toLowerCase();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
                    String string3 = string2;
                    return list.contains(string3);
                }
                {
                    this.$lowerCased = list;
                    super(1);
                }
            };
        }
        return getShouldInclude.2.INSTANCE;
    }
}

