/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.rest.login;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import jetbrains.charisma.authentication.LoginContext;
import jetbrains.charisma.main.BeansKt;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.provider.exception.ForbiddenException;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.youtrack.core.KSecurityLogging;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.rest.ResponseUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdExtensionsKt;
import mu.KLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@Path(value="/user/login")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@Transactional
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\n\b\u0001\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\b\u0001\u0010\u0006\u001a\u00020\u00042\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\n"}, d2={"Ljetbrains/youtrack/rest/login/UserLoginResource;", "Ljetbrains/mps/webr/rpc/rest/runtime/Resource;", "()V", "post", "", "login", "password", "request", "Ljavax/servlet/http/HttpServletRequest;", "Companion", "youtrack-old-rest"})
public final class UserLoginResource
implements Resource {
    @NotNull
    private static final KLogger legacyAuthLogger;
    public static final Companion Companion;

    @POST
    @NotNull
    public final String post(@QueryParam(value="login") @Nullable String login, @QueryParam(value="password") @NotNull String password, @Context @NotNull HttpServletRequest request) {
        XdUser current;
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        ResponseUtilKt.isRequired("login", login);
        ResponseUtilKt.isRequired("password", password);
        Entity entity = jetbrains.youtrack.core.security.BeansKt.getLoggedInUserOrNull();
        Object object = current = entity != null ? (XdUser)XdExtensionsKt.toXd((Entity)entity) : null;
        if (current != null && Intrinsics.areEqual((Object)current.getLogin(), (Object)login)) {
            BeansKt.getSecurityNavigator().login((Object)current.getEntity(), true);
        } else {
            Entity user2 = jetbrains.charisma.persistent.BeansKt.getAuthenticationManager().authorize(new LoginContext(login, password));
            if (login != null && user2 != null) {
                String string;
                String ip;
                String string2 = request.getRemoteAddr();
                if (string2 == null) {
                    string2 = ip = "<unknown>";
                }
                if ((string = request.getHeader("User-Agent")) == null) {
                    string = "<unknown>";
                }
                String agent = string;
                legacyAuthLogger.debug('[' + login + '@' + ip + "] Authenticated user agent " + agent + " with a legacy /rest/user/login endpoint");
                BeansKt.getSecurityNavigator().login((Object)user2, true);
            } else {
                Companion.getLogger().warn("Failed REST API login as '" + login + "'. Remote IP is " + request.getRemoteAddr() + '.');
                throw (Throwable)new ForbiddenException("Incorrect login or password.");
            }
        }
        return "<login>ok</login>";
    }

    static {
        Companion = new Companion(null);
        legacyAuthLogger = Companion.logger("jetbrains.youtrack.auth.legacy");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/youtrack/rest/login/UserLoginResource$Companion;", "Ljetbrains/youtrack/core/KSecurityLogging;", "()V", "legacyAuthLogger", "Lmu/KLogger;", "getLegacyAuthLogger", "()Lmu/KLogger;", "youtrack-old-rest"})
    public static final class Companion
    extends KSecurityLogging {
        @NotNull
        public final KLogger getLegacyAuthLogger() {
            return legacyAuthLogger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

