/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.rest.role;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.youtrack.gaprest.db.util.HelpersKt;
import jetbrains.youtrack.persistent.security.XdRole;
import jetbrains.youtrack.rest.ResponseUtilKt;
import jetbrains.youtrack.rest.role.Permission;
import jetbrains.youtrack.rest.role.Role;
import jetbrains.youtrack.rest.role.RoleRef;
import jetbrains.youtrack.rest.role.RolesRestUtilKt;
import jetbrains.youtrack.rest.security.IsLoggedInSecurityConstraint;
import jetbrains.youtrack.rest.user.UserRestUtilKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.query.XdQuery;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@Path(value="/admin/role")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@Transactional
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u0006H\u0007J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0007J\u0012\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t2\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J*\u0010\u000f\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\n\b\u0001\u0010\u0010\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u0010\u0011\u001a\u0004\u0018\u00010\u0006H\u0007J\u001c\u0010\u0012\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u0006H\u0007J\u001c\u0010\u0013\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0011\u001a\u00020\u0006H\u0007\u00a8\u0006\u0014"}, d2={"Ljetbrains/youtrack/rest/role/AdminRoleResource;", "Ljetbrains/mps/webr/rpc/rest/runtime/Resource;", "()V", "deleteRolePermissionPermission", "Ljavax/ws/rs/core/Response;", "role", "", "permission", "get", "", "Ljetbrains/youtrack/rest/role/RoleRef;", "getRole", "Ljetbrains/youtrack/rest/role/Role;", "getRolePermission", "Ljetbrains/youtrack/rest/role/Permission;", "postRole", "newName", "description", "postRolePermissionPermission", "putRole", "youtrack-old-rest"})
public final class AdminRoleResource
implements Resource {
    /*
     * WARNING - void declaration
     */
    @GET
    @NotNull
    public final List<RoleRef> get() {
        void $this$mapTo$iv$iv;
        IsLoggedInSecurityConstraint.INSTANCE.check();
        UserRestUtilKt.assertHasPermission$default(jetbrains.youtrack.core.security.Permission.READ_ROLE, null, 2, null);
        Iterable $this$sortedBy$iv = HelpersKt.asIterable((XdQuery)XdRole.Companion.all());
        boolean $i$f$sortedBy = false;
        Iterable iterable = $this$sortedBy$iv;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                XdRole it = (XdRole)a;
                boolean bl2 = false;
                String string = it.getName();
                boolean bl3 = false;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                it = (XdRole)b;
                Comparable comparable = (Comparable)((Object)string3);
                bl2 = false;
                string = it.getName();
                bl3 = false;
                String string4 = string;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
                String string6 = string5;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string6)));
            }
        };
        Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
        boolean $i$f$map = false;
        iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            XdRole xdRole = (XdRole)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            RoleRef roleRef = new RoleRef(it.getName());
            collection.add(roleRef);
        }
        return (List)destination$iv$iv;
    }

    @GET
    @Path(value="/{role}")
    @NotNull
    public final Role getRole(@PathParam(value="role") @NotNull String role2) {
        Intrinsics.checkParameterIsNotNull((Object)role2, (String)"role");
        IsLoggedInSecurityConstraint.INSTANCE.check();
        UserRestUtilKt.assertHasPermission$default(jetbrains.youtrack.core.security.Permission.READ_ROLE, null, 2, null);
        XdRole r = RolesRestUtilKt.getRoleByName(role2);
        return new Role(r.getName(), r.getDescription());
    }

    @PUT
    @Path(value="/{role}")
    @NotNull
    public final Response putRole(@PathParam(value="role") @NotNull String role2, @QueryParam(value="description") @NotNull String description) {
        Intrinsics.checkParameterIsNotNull((Object)role2, (String)"role");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        IsLoggedInSecurityConstraint.INSTANCE.check();
        UserRestUtilKt.assertHasPermission$default(jetbrains.youtrack.core.security.Permission.CREATE_ROLE, null, 2, null);
        RolesRestUtilKt.checkRoleDoesntExist(role2);
        XdRole.Companion.new((Function1)new Function1<XdRole, Unit>(role2, description){
            final /* synthetic */ String $role;
            final /* synthetic */ String $description;

            public final void invoke(@NotNull XdRole $this$new) {
                Intrinsics.checkParameterIsNotNull((Object)$this$new, (String)"$receiver");
                $this$new.setName(this.$role);
                $this$new.setDescription(this.$description);
            }
            {
                this.$role = string;
                this.$description = string2;
                super(1);
            }
        });
        return ResponseUtilKt.created(RolesRestUtilKt.getRoleUrl(role2));
    }

    @POST
    @Path(value="/{role}")
    @NotNull
    public final Response postRole(@PathParam(value="role") @NotNull String role2, @QueryParam(value="newName") @Nullable String newName, @QueryParam(value="description") @Nullable String description) {
        Intrinsics.checkParameterIsNotNull((Object)role2, (String)"role");
        IsLoggedInSecurityConstraint.INSTANCE.check();
        UserRestUtilKt.assertHasPermission$default(jetbrains.youtrack.core.security.Permission.UPDATE_ROLE, null, 2, null);
        XdRole r = RolesRestUtilKt.getRoleByName(role2);
        if (description != null) {
            r.setDescription(description);
        }
        String oldName = r.getName();
        if (newName != null) {
            CharSequence charSequence = newName;
            boolean bl = false;
            if (charSequence.length() > 0 && Intrinsics.areEqual((Object)newName, (Object)oldName) ^ true) {
                RolesRestUtilKt.checkRoleDoesntExist(newName);
                r.setName(newName);
            }
        }
        return ResponseUtilKt.updated(RolesRestUtilKt.getRoleUrl(role2), oldName, newName);
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Path(value="/{role}/permission")
    @NotNull
    public final List<Permission> getRolePermission(@PathParam(value="role") @NotNull String role2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)role2, (String)"role");
        IsLoggedInSecurityConstraint.INSTANCE.check();
        UserRestUtilKt.assertHasPermission$default(jetbrains.youtrack.core.security.Permission.READ_ROLE, null, 2, null);
        Iterable $this$map$iv = RolesRestUtilKt.getRoleByName(role2).getPermissions();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            jetbrains.youtrack.core.security.Permission permission = (jetbrains.youtrack.core.security.Permission)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.name();
            String string2 = it.getHumanizedName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.humanizedName");
            Permission permission2 = new Permission(string, string2);
            collection.add(permission2);
        }
        return (List)destination$iv$iv;
    }

    @POST
    @Path(value="/{role}/permission/{permission}")
    @NotNull
    public final Response postRolePermissionPermission(@PathParam(value="role") @NotNull String role2, @PathParam(value="permission") @NotNull String permission) {
        Intrinsics.checkParameterIsNotNull((Object)role2, (String)"role");
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        IsLoggedInSecurityConstraint.INSTANCE.check();
        UserRestUtilKt.assertHasPermission$default(jetbrains.youtrack.core.security.Permission.UPDATE_ROLE, null, 2, null);
        XdRole r = RolesRestUtilKt.getRoleByName(role2);
        jetbrains.youtrack.core.security.Permission p = RolesRestUtilKt.getPermission(permission);
        r.addPermission(p);
        ResponseUtilKt.waitForPermissionCacheRecalculation();
        Response response = Response.ok().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok().build()");
        return response;
    }

    @DELETE
    @Path(value="/{role}/permission/{permission}")
    @NotNull
    public final Response deleteRolePermissionPermission(@PathParam(value="role") @NotNull String role2, @PathParam(value="permission") @NotNull String permission) {
        Intrinsics.checkParameterIsNotNull((Object)role2, (String)"role");
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        IsLoggedInSecurityConstraint.INSTANCE.check();
        UserRestUtilKt.assertHasPermission$default(jetbrains.youtrack.core.security.Permission.UPDATE_ROLE, null, 2, null);
        XdRole r = RolesRestUtilKt.getRoleByName(role2);
        jetbrains.youtrack.core.security.Permission p = RolesRestUtilKt.getPermission(permission);
        r.removePermission(p);
        ResponseUtilKt.waitForPermissionCacheRecalculation();
        Response response = Response.ok().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok().build()");
        return response;
    }
}

