/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.rest.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.youtrack.api.context.IContext;
import jetbrains.youtrack.context.Context;
import jetbrains.youtrack.core.persistent.issue.XdIssueFolder;
import jetbrains.youtrack.parser.base.SuggestItem;
import jetbrains.youtrack.persistent.IssueFolders;
import jetbrains.youtrack.rest.search.JaxbStyledUnderline;
import jetbrains.youtrack.rest.search.JaxbStyledUnderlineAndSuggest;
import jetbrains.youtrack.rest.security.IsLoggedInSecurityConstraint;
import jetbrains.youtrack.restInternal.JaxbSuggest;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@Path(value="/search")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@Transactional
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H\u0002JA\u0010\t\u001a\u00020\n2\u000e\b\u0001\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\b\u0001\u0010\f\u001a\u0004\u0018\u00010\b2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0001\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0007\u00a2\u0006\u0002\u0010\u0010J9\u0010\u0011\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0002\u0010\u0013J?\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00042\b\u0010\f\u001a\u0004\u0018\u00010\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0002\u0010\u0017J \u0010\u0018\u001a\u00020\u00192\b\u0010\f\u001a\u0004\u0018\u00010\b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J$\u0010\u0018\u001a\u00020\u00192\u000e\b\u0001\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\b\u0001\u0010\f\u001a\u0004\u0018\u00010\bH\u0007JA\u0010\u001a\u001a\u00020\u001b2\u000e\b\u0001\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\b\u0001\u0010\f\u001a\u0004\u0018\u00010\b2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0001\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0007\u00a2\u0006\u0002\u0010\u001cJ\u001f\u0010\u001d\u001a\u00020\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001e\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u001f\u00a8\u0006 "}, d2={"Ljetbrains/youtrack/rest/search/SearchResource;", "Ljetbrains/mps/webr/rpc/rest/runtime/Resource;", "()V", "getFolders", "", "Ljetbrains/youtrack/core/persistent/issue/XdIssueFolder;", "ids", "", "", "getSuggest", "Ljetbrains/youtrack/restInternal/JaxbSuggest;", "wfId", "query", "caret", "", "optionsLimit", "(Ljava/util/Set;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)Ljetbrains/youtrack/restInternal/JaxbSuggest;", "getSuggests", "folder", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Iterable;)Ljetbrains/youtrack/restInternal/JaxbSuggest;", "getSuggestsItems", "Ljetbrains/youtrack/parser/base/SuggestItem;", "folders", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Iterable;)Ljava/lang/Iterable;", "getUnderline", "Ljetbrains/youtrack/rest/search/JaxbStyledUnderline;", "getUnderlineAndSuggest", "Ljetbrains/youtrack/rest/search/JaxbStyledUnderlineAndSuggest;", "(Ljava/util/Set;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)Ljetbrains/youtrack/rest/search/JaxbStyledUnderlineAndSuggest;", "normalizeCaret", "actual", "(Ljava/lang/Integer;Ljava/lang/String;)I", "youtrack-old-rest"})
public final class SearchResource
implements Resource {
    @GET
    @Path(value="/suggest")
    @Produces(value={"application/x-javascript;charset=UTF-8", "application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
    @NotNull
    public final JaxbSuggest getSuggest(@QueryParam(value="wfId") @NotNull Set<String> wfId, @QueryParam(value="query") @Nullable String query, @QueryParam(value="caret") @Nullable Integer caret, @QueryParam(value="optionsLimit") @Nullable Integer optionsLimit) {
        Intrinsics.checkParameterIsNotNull(wfId, (String)"wfId");
        IsLoggedInSecurityConstraint.INSTANCE.check();
        Iterable<XdIssueFolder> folders = this.getFolders(wfId);
        return this.getSuggests(query, caret, optionsLimit, folders);
    }

    @GET
    @Path(value="/underline")
    @Produces(value={"application/x-javascript;charset=UTF-8", "application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
    @NotNull
    public final JaxbStyledUnderline getUnderline(@QueryParam(value="wfId") @NotNull Set<String> wfId, @QueryParam(value="query") @Nullable String query) {
        Intrinsics.checkParameterIsNotNull(wfId, (String)"wfId");
        IsLoggedInSecurityConstraint.INSTANCE.check();
        Iterable<XdIssueFolder> folders = this.getFolders(wfId);
        return this.getUnderline(query, folders);
    }

    @GET
    @Path(value="/underlineAndSuggest")
    @Produces(value={"application/x-javascript;charset=UTF-8", "application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
    @NotNull
    public final JaxbStyledUnderlineAndSuggest getUnderlineAndSuggest(@QueryParam(value="wfId") @NotNull Set<String> wfId, @QueryParam(value="query") @Nullable String query, @QueryParam(value="caret") @Nullable Integer caret, @QueryParam(value="optionsLimit") @Nullable Integer optionsLimit) {
        Intrinsics.checkParameterIsNotNull(wfId, (String)"wfId");
        IsLoggedInSecurityConstraint.INSTANCE.check();
        Iterable<XdIssueFolder> folders = this.getFolders(wfId);
        return new JaxbStyledUnderlineAndSuggest(this.getUnderline(query, folders), this.getSuggests(query, caret, optionsLimit, folders));
    }

    private final JaxbSuggest getSuggests(String query, Integer caret, Integer optionsLimit, Iterable<? extends XdIssueFolder> folder) {
        String string = query;
        if (string == null) {
            string = "";
        }
        String actualQuery = string;
        int actualCaret = this.normalizeCaret(caret, actualQuery);
        return new JaxbSuggest(actualQuery, actualCaret, this.getSuggestsItems(actualQuery, actualCaret, optionsLimit, folder));
    }

    private final int normalizeCaret(Integer caret, String actual) {
        return caret == null || caret < 0 || caret > actual.length() ? actual.length() : caret.intValue();
    }

    private final Iterable<SuggestItem> getSuggestsItems(String query, Integer caret, Integer optionsLimit, Iterable<? extends XdIssueFolder> folders) {
        String string = query;
        if (string == null) {
            string = "";
        }
        String actualQuery = string;
        int actualCaret = this.normalizeCaret(caret, actualQuery);
        int actualLimit = optionsLimit == null || optionsLimit < 1 ? 15 : optionsLimit;
        Iterable recentSuggestionsItems = jetbrains.charisma.service.BeansKt.getRecentSearchesContainer().suggestRecentQueries(BeansKt.getXdLoggedInUser(), actualQuery, actualCaret);
        return CollectionsKt.plus((Iterable)BeansKt.getParser().suggest(folders, actualQuery, (IContext)new Context(), actualCaret, actualLimit), (Iterable)recentSuggestionsItems);
    }

    private final JaxbStyledUnderline getUnderline(String query, Iterable<? extends XdIssueFolder> folders) {
        String string = query;
        if (string == null) {
            string = "";
        }
        String actualQuery = string;
        Iterable ranges = BeansKt.getParser().getStyleRanges(folders, actualQuery, (IContext)new Context());
        return new JaxbStyledUnderline(actualQuery, ranges);
    }

    /*
     * WARNING - void declaration
     */
    private final Iterable<XdIssueFolder> getFolders(Set<String> ids) {
        Iterable iterable;
        Set<String> set = ids;
        if (set != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = set;
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                XdIssueFolder xdIssueFolder;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (IssueFolders.INSTANCE.findById(it) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                XdIssueFolder it$iv$iv = xdIssueFolder;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            iterable = (List)destination$iv$iv;
        } else {
            iterable = CollectionsKt.emptyList();
        }
        return iterable;
    }
}

