/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.rest.timetracking;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.mps.webr.rpc.rest.runtime.Transformer;
import jetbrains.mps.webr.runtime.uri.QueryParameter;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.rest.security.HasAdminReadSecurityConstraint;
import jetbrains.youtrack.rest.security.HasAdminWriteSecurityConstraint;
import jetbrains.youtrack.rest.timetracking.AdminWorkTimeSettingsResource;
import jetbrains.youtrack.rest.timetracking.pojo.WorkItemType;
import jetbrains.youtrack.rest.timetracking.pojo.WorkTimeSettings;
import jetbrains.youtrack.timetracking.BeansKt;
import jetbrains.youtrack.timetracking.persistence.XdWorkItemType;
import jetbrains.youtrack.timetracking.plugin.WeekDays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;
import webr.framework.url.UrlUtil;

@Transactional
@Produces(value={"application/json;charset=UTF-8", "application/xml;charset=UTF-8"})
@Path(value="/admin/timetracking")
@Component(value="old.timetracking.rest.AdminWorkTimeSettingsResource")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\u0007\u001a\u00020\bH\u0007J\u0012\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0007J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\nH\u0007J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\bH\u0007J\u001a\u0010\u0010\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\nH\u0007\u00a8\u0006\u0012"}, d2={"Ljetbrains/youtrack/rest/timetracking/AdminWorkTimeSettingsResource;", "Ljetbrains/mps/webr/rpc/rest/runtime/Resource;", "()V", "deleteWorkType", "Ljavax/ws/rs/core/Response;", "type", "Ljetbrains/youtrack/timetracking/persistence/XdWorkItemType;", "get", "Ljetbrains/youtrack/rest/timetracking/pojo/WorkTimeSettings;", "getWorkType", "Ljetbrains/youtrack/rest/timetracking/pojo/WorkItemType;", "getWorkTypes", "", "newWorkType", "update", "settings", "updateWorkType", "newType", "youtrack-old-rest"})
public final class AdminWorkTimeSettingsResource
implements Resource {
    @GET
    @NotNull
    public final WorkTimeSettings get() {
        HasAdminReadSecurityConstraint.Companion.check();
        return new WorkTimeSettings(BeansKt.getWorkTimeSettings());
    }

    @PUT
    @NotNull
    public final Response update(@NotNull WorkTimeSettings settings) {
        int it;
        boolean bl;
        boolean bl2;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        HasAdminWriteSecurityConstraint.Companion.check();
        Integer n = settings.getHoursADay();
        if (n != null) {
            object = n;
            bl2 = false;
            bl = false;
            it = ((Number)object).intValue();
            boolean bl3 = false;
            BeansKt.getWorkTimeSettings().setMinutesADay(it * 60);
        }
        Integer n2 = settings.getDaysAWeek();
        if (n2 != null) {
            object = n2;
            bl2 = false;
            bl = false;
            it = ((Number)object).intValue();
            boolean bl4 = false;
            BeansKt.getWorkTimeSettings().setDaysAWeek(it);
        }
        List<Integer> list = settings.getWorkDay();
        if (list != null) {
            object = list;
            bl2 = false;
            bl = false;
            Object it2 = object;
            boolean bl5 = false;
            boolean bl6 = false;
            ArrayList<WeekDays> workWeekDays = new ArrayList<WeekDays>();
            Iterable $this$forEach$iv = (Iterable)it2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int it3 = ((Number)element$iv).intValue();
                boolean bl7 = false;
                WeekDays day = WeekDays.values()[it3];
                if (workWeekDays.indexOf(day) != -1) continue;
                workWeekDays.add(day);
            }
            BeansKt.getWorkTimeSettings().setWorksDaysOfWeek((List)workWeekDays);
        }
        LegacySupportKt.flush();
        Response response = Response.ok().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok().build()");
        return response;
    }

    @GET
    @Path(value="/worktype")
    @NotNull
    public final List<WorkItemType> getWorkTypes() {
        HasAdminReadSecurityConstraint.Companion.check();
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)XdQueryKt.asSequence((XdQuery)XdWorkItemType.Companion.all()), (Function1)getWorkTypes.1.INSTANCE));
    }

    @GET
    @Path(value="/worktype/{type}")
    @NotNull
    public final WorkItemType getWorkType(@Transformer(value="workTypeById") @PathParam(value="type") @NotNull XdWorkItemType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        HasAdminReadSecurityConstraint.Companion.check();
        return new WorkItemType(type);
    }

    @PUT
    @Path(value="/worktype/{type}")
    @NotNull
    public final Response updateWorkType(@Transformer(value="workTypeById") @PathParam(value="type") @NotNull XdWorkItemType type, @NotNull WorkItemType newType) {
        boolean bl;
        boolean bl2;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)newType, (String)"newType");
        HasAdminWriteSecurityConstraint.Companion.check();
        String string = newType.getName();
        if (string != null) {
            object = string;
            bl2 = false;
            bl = false;
            String it = object;
            boolean bl3 = false;
            type.setName(it);
        }
        Boolean bl4 = newType.getAutoAttached();
        if (bl4 != null) {
            object = bl4;
            bl2 = false;
            bl = false;
            boolean it = (Boolean)object;
            boolean bl5 = false;
            type.setAutoAttached(it);
        }
        LegacySupportKt.flush();
        Response response = Response.ok().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok().build()");
        return response;
    }

    @POST
    @Path(value="/worktype")
    @NotNull
    public final Response newWorkType(@NotNull WorkItemType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        HasAdminWriteSecurityConstraint.Companion.check();
        XdWorkItemType result2 = (XdWorkItemType)XdWorkItemType.Companion.new((Function1)new Function1<XdWorkItemType, Unit>(type){
            final /* synthetic */ WorkItemType $type;

            public final void invoke(@NotNull XdWorkItemType $this$new) {
                Intrinsics.checkParameterIsNotNull((Object)$this$new, (String)"$receiver");
                String string = this.$type.getName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                $this$new.setName(string);
            }
            {
                this.$type = workItemType;
                super(1);
            }
        });
        LegacySupportKt.flush();
        Response response = Response.created((URI)UrlUtil.getRestPathUri((String[])new String[]{"admin", "timetracking"}).addPathElements(new String[]{"worktype", result2.getEntity().toIdString()}).addQueryParameters(new QueryParameter[0]).toURI()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.created(\n      \u2026toURI()\n        ).build()");
        return response;
    }

    @DELETE
    @Path(value="/worktype/{type}")
    @NotNull
    public final Response deleteWorkType(@Transformer(value="workTypeById") @PathParam(value="type") @NotNull XdWorkItemType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        HasAdminWriteSecurityConstraint.Companion.check();
        type.delete();
        LegacySupportKt.flush();
        Response response = Response.ok().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok().build()");
        return response;
    }
}

