/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.rest.timetracking;

import java.net.URI;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.charisma.persistent.security.PrincipalsKt;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.provider.exception.BadRequestException;
import jetbrains.mps.webr.rpc.rest.provider.exception.ForbiddenException;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.mps.webr.rpc.rest.runtime.Transformer;
import jetbrains.mps.webr.userManagement.runtime.PrincipalManager;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.persistent.PersitenceExtensionsKt;
import jetbrains.youtrack.persistent.security.BasicSecurityCache;
import jetbrains.youtrack.persistent.security.BasicSecurityCacheKt;
import jetbrains.youtrack.rest.ResponseUtilKt;
import jetbrains.youtrack.rest.security.HasPermissionSecurityConstraint;
import jetbrains.youtrack.rest.timetracking.IssueWorkItemResource;
import jetbrains.youtrack.rest.timetracking.TimeTrackingResourcesKt;
import jetbrains.youtrack.rest.timetracking.pojo.WorkItem;
import jetbrains.youtrack.rest.timetracking.pojo.WorkItemType;
import jetbrains.youtrack.rest.user.beans.UserRef;
import jetbrains.youtrack.timetracking.persistence.XdIssueWorkItem;
import jetbrains.youtrack.timetracking.persistence.XdTimeTrackingSettingsKt;
import jetbrains.youtrack.timetracking.persistence.XdWorkItemKt;
import jetbrains.youtrack.timetracking.persistence.XdWorkItemType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.query.XdSearchingNode;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Produces(value={"application/json;charset=UTF-8", "application/xml;charset=UTF-8"})
@Transactional
@Path(value="/issue/{issue}/timetracking/workitem")
@Component(value="old.timetracking.rest.IssueWorkItemResource")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u0011\u001a\u00020\u000b2\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0007J\u001a\u0010\u000e\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000bH\u0007J$\u0010\u0012\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0007\u00a8\u0006\u0013"}, d2={"Ljetbrains/youtrack/rest/timetracking/IssueWorkItemResource;", "Ljetbrains/mps/webr/rpc/rest/runtime/Resource;", "()V", "deleteWorkItem", "Ljavax/ws/rs/core/Response;", "issue", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "workItem", "Ljetbrains/youtrack/timetracking/persistence/XdIssueWorkItem;", "get", "", "Ljetbrains/youtrack/rest/timetracking/pojo/WorkItem;", "getType", "Ljetbrains/youtrack/timetracking/persistence/XdWorkItemType;", "newWorkItem", "project", "Ljetbrains/youtrack/core/persistent/issue/XdProject;", "getWorkItem", "updateWorkItem", "youtrack-old-rest"})
public final class IssueWorkItemResource
implements Resource {
    @GET
    @NotNull
    public final List<WorkItem> get(@Transformer(value="xdIssueById") @PathParam(value="issue") @NotNull XdIssue issue2) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        XdProject project = issue2.getProject();
        TimeTrackingResourcesKt.assertTimeTrackingEnabled(project);
        HasPermissionSecurityConstraint.Companion.check(Permission.READ_WORK_ITEM, project.getEntity());
        BasicSecurityCache securityCache = BasicSecurityCacheKt.getBasicSecurityCache();
        XdUser user2 = BeansKt.getXdLoggedInUser();
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)XdQueryKt.asSequence((XdQuery)XdWorkItemKt.getWorkItems((XdIssue)issue2)), (Function1)((Function1)new Function1<XdIssueWorkItem, Boolean>(securityCache, user2){
            final /* synthetic */ BasicSecurityCache $securityCache;
            final /* synthetic */ XdUser $user;

            public final boolean invoke(@NotNull XdIssueWorkItem it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.$securityCache.isAccessible((XdEntity)it, Operation.READ, this.$user);
            }
            {
                this.$securityCache = basicSecurityCache;
                this.$user = xdUser;
                super(1);
            }
        })), (Function1)get.2.INSTANCE));
    }

    @GET
    @Path(value="/{workItem}")
    @NotNull
    public final WorkItem getWorkItem(@Transformer(value="xdIssueById") @PathParam(value="issue") @NotNull XdIssue issue2, @Transformer(value="workItemById") @PathParam(value="workItem") @NotNull XdIssueWorkItem workItem2) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)workItem2, (String)"workItem");
        TimeTrackingResourcesKt.assertTimeTrackingEnabled(issue2.getProject());
        HasPermissionSecurityConstraint.Companion.check(Permission.READ_WORK_ITEM, issue2.getProject().getEntity());
        return new WorkItem(workItem2);
    }

    @PUT
    @Path(value="/{workItem}")
    @NotNull
    public final Response updateWorkItem(@Transformer(value="xdIssueById") @PathParam(value="issue") @NotNull XdIssue issue2, @Transformer(value="workItemById") @PathParam(value="workItem") @NotNull XdIssueWorkItem workItem2, @NotNull WorkItem newWorkItem) {
        boolean bl;
        boolean bl2;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)workItem2, (String)"workItem");
        Intrinsics.checkParameterIsNotNull((Object)newWorkItem, (String)"newWorkItem");
        TimeTrackingResourcesKt.assertTimeTrackingEnabled(issue2.getProject());
        TimeTrackingResourcesKt.assertUpdatable(workItem2);
        Long l = newWorkItem.getDate();
        if (l != null) {
            object = l;
            bl2 = false;
            bl = false;
            long it = ((Number)object).longValue();
            boolean bl3 = false;
            workItem2.setDate(it);
        }
        Integer n = newWorkItem.getDuration();
        if (n != null) {
            object = n;
            bl2 = false;
            bl = false;
            int it = ((Number)object).intValue();
            boolean bl4 = false;
            workItem2.setDuration(it);
        }
        String string = newWorkItem.getDescription();
        if (string != null) {
            object = string;
            bl2 = false;
            bl = false;
            Object it = object;
            boolean bl5 = false;
            workItem2.setDescription((String)it);
        }
        WorkItemType workItemType = newWorkItem.getWorktype();
        if (workItemType != null) {
            object = workItemType;
            bl2 = false;
            bl = false;
            Object it = object;
            boolean bl6 = false;
            workItem2.setType(this.getType(newWorkItem, issue2.getProject()));
        }
        Response response = Response.ok().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok().build()");
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @POST
    @NotNull
    public final Response newWorkItem(@Transformer(value="xdIssueById") @PathParam(value="issue") @NotNull XdIssue issue2, @NotNull WorkItem workItem2) {
        void author;
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)workItem2, (String)"workItem");
        TimeTrackingResourcesKt.assertTimeTrackingEnabled(issue2.getProject());
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = BeansKt.getXdLoggedInUser();
        UserRef requestAuthor = workItem2.getAuthor();
        if (requestAuthor != null) {
            boolean canCreateNotOwn = PrincipalsKt.hasPermissionInProject((Entity)((Entity)BeansKt.getLoggedInUser()), (Permission)Permission.CREATE_NOT_OWN_WORK_ITEM, (Entity)issue2.getProject().getEntity());
            if (!canCreateNotOwn) {
                throw (Throwable)new ForbiddenException("You can't set work item author as you are not project admin.");
            }
            String authorLogin = requestAuthor.getLogin();
            XdUser xdUser = XdUser.Companion.findUser(authorLogin);
            if (xdUser == null) {
                throw (Throwable)new BadRequestException("There is no user with login " + authorLogin);
            }
            author.element = xdUser;
        } else {
            boolean canCreate;
            boolean bl = canCreate = PrincipalsKt.hasPermissionInProject((Entity)((Entity)BeansKt.getLoggedInUser()), (Permission)Permission.CREATE_WORK_ITEM, (Entity)issue2.getProject().getEntity()) || PrincipalsKt.hasPermissionInProject((Entity)((Entity)BeansKt.getLoggedInUser()), (Permission)Permission.CREATE_NOT_OWN_WORK_ITEM, (Entity)issue2.getProject().getEntity());
            if (!canCreate) {
                throw (Throwable)new ForbiddenException("You can't create work item as you have no permissions for that.");
            }
        }
        Long l = workItem2.getDate();
        if (l == null) {
            throw (Throwable)new BadRequestException("Work item date is required");
        }
        long date = l;
        XdUser user$iv = (XdUser)author.element;
        boolean $i$f$runAs = false;
        Entity user$iv$iv = user$iv.getEntity();
        boolean $i$f$runAs2 = false;
        PrincipalManager _principalManager$iv$iv = jetbrains.youtrack.core.security.BeansKt.getPrincipalManager();
        try {
            _principalManager$iv$iv.setTemporaryServerPrincipal((Object)user$iv$iv);
            boolean bl = false;
            XdIssueWorkItem newWorkItem = XdIssueWorkItem.Companion.new(issue2, (XdUser)author.element, date, (Function1)new Function1<XdIssueWorkItem, Unit>(this, issue2, (Ref.ObjectRef)author, date, workItem2){
                final /* synthetic */ IssueWorkItemResource this$0;
                final /* synthetic */ XdIssue $issue$inlined;
                final /* synthetic */ Ref.ObjectRef $author$inlined;
                final /* synthetic */ long $date$inlined;
                final /* synthetic */ WorkItem $workItem$inlined;
                {
                    this.this$0 = issueWorkItemResource;
                    this.$issue$inlined = xdIssue;
                    this.$author$inlined = objectRef;
                    this.$date$inlined = l;
                    this.$workItem$inlined = workItem2;
                    super(1);
                }

                public final void invoke(@NotNull XdIssueWorkItem $this$new) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$new, (String)"$receiver");
                    Integer n = this.$workItem$inlined.getDuration();
                    if (n == null) {
                        throw (Throwable)new BadRequestException("Work item duration is required");
                    }
                    $this$new.setDuration(n.intValue());
                    $this$new.setDescription(this.$workItem$inlined.getDescription());
                    $this$new.setType(IssueWorkItemResource.access$getType(this.this$0, this.$workItem$inlined, this.$issue$inlined.getProject()));
                }
            });
            LegacySupportKt.flush();
            Response response = Response.created((URI)TimeTrackingResourcesKt.getOldRestURL(newWorkItem)).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.created(newWorkItem.oldRestURL).build()");
            Response response2 = response;
            return response2;
        }
        finally {
            _principalManager$iv$iv.unsetTemporaryServerPrincipal();
        }
    }

    @DELETE
    @Path(value="/{workItem}")
    @NotNull
    public final Response deleteWorkItem(@Transformer(value="xdIssueById") @PathParam(value="issue") @NotNull XdIssue issue2, @Transformer(value="workItemById") @PathParam(value="workItem") @NotNull XdIssueWorkItem workItem2) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)workItem2, (String)"workItem");
        TimeTrackingResourcesKt.assertTimeTrackingEnabled(issue2.getProject());
        TimeTrackingResourcesKt.assertUpdatable(workItem2);
        return ResponseUtilKt.deleted$default((XdEntity)workItem2, false, 2, null);
    }

    private final XdWorkItemType getType(WorkItem newWorkItem, XdProject project) throws BadRequestException {
        XdWorkItemType type = null;
        WorkItemType workItemType = newWorkItem.getWorktype();
        if (workItemType == null) {
            return null;
        }
        WorkItemType worktype = workItemType;
        if (worktype.getId() != null) {
            XdEntityType xdEntityType = (XdEntityType)XdWorkItemType.Companion;
            String string = worktype.getId();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if ((type = (XdWorkItemType)PersitenceExtensionsKt.tryFindById((XdEntityType)xdEntityType, (String)string)) == null) {
                throw (Throwable)new BadRequestException("Unknown worktype id");
            }
        } else if (worktype.getName() != null && (type = (XdWorkItemType)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdWorkItemType.Companion), (Function2)((Function2)new Function2<FilteringContext, XdWorkItemType, XdSearchingNode>(worktype){
            final /* synthetic */ WorkItemType $worktype;

            @NotNull
            public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdWorkItemType it) {
                Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return $this$filter.eq((Comparable)((Object)it.getName()), (Comparable)((Object)this.$worktype.getName()));
            }
            {
                this.$worktype = workItemType;
                super(2);
            }
        })))) == null) {
            throw (Throwable)new BadRequestException("Unknown worktype name");
        }
        if (type != null && !XdQueryKt.contains((XdQuery)((XdQuery)XdTimeTrackingSettingsKt.getTimeTrackingSettings((XdProject)project).getWorkItemTypes()), (XdEntity)((XdEntity)type))) {
            throw (Throwable)new BadRequestException("Worktype [" + type.getName() + "] is not attached to project.");
        }
        return type;
    }

    public static final /* synthetic */ XdWorkItemType access$getType(IssueWorkItemResource $this, WorkItem newWorkItem, XdProject project) {
        return $this.getType(newWorkItem, project);
    }
}

