/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.restImport;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.jetpass.pojo.api.authority.profile.LoginUtils;
import jetbrains.mps.baseLanguage.dates.runtime.CompareType;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.youtrack.admin.IssueAttachmentStub;
import jetbrains.youtrack.core.persistent.UserGroupImpl;
import jetbrains.youtrack.core.persistent.UserImpl;
import jetbrains.youtrack.rest.OldImportUtil;
import jetbrains.youtrack.restImport.ItemReport;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.joda.time.DateTimeFieldType;

public class AttachmentBean
implements IssueAttachmentStub {
    private Long created;
    private Entity permittedGroup;
    private Entity author;
    private DiskFileItem file;
    private Entity issue;
    private ItemReport itemReport = new ItemReport();

    public void parse(String issue2, String authorLogin, String group, Long created, DiskFileItem file) {
        if (issue2 == null || issue2.length() == 0) {
            this.itemReport.requireField("issue");
        } else {
            this.issue = OldImportUtil.getIssueFromId(issue2);
            if (EntityOperations.equals((Entity)this.issue, null)) {
                this.itemReport.unknownValue("issue", issue2);
            }
        }
        if (authorLogin == null || authorLogin.length() == 0) {
            this.itemReport.requireField("authorLogin");
        } else {
            this.author = LoginUtils.isValidLogin((String)authorLogin) ? UserImpl.findUser((String)authorLogin) : UserImpl.findUser((String)LoginUtils.fix((String)authorLogin));
            if (this.author == null) {
                this.author = UserImpl.findRoot();
            }
        }
        if (group != null && group.length() > 0) {
            this.permittedGroup = UserGroupImpl.findUserGroup((String)group);
            if (group == null) {
                this.itemReport.unknownValue("group", group);
            }
        }
        this.created = created;
        if (DateTimeOperations.compare((Long)created, (CompareType)CompareType.EQ, null, (DateTimeFieldType)DateTimeFieldType.millisOfSecond())) {
            this.created = System.currentTimeMillis();
        }
        this.file = file;
        if (file == null) {
            this.itemReport.requireField("MIME attachment");
        } else if (AttachmentBean.isEmpty_vmiymh_a0a0a01a0(file.getName())) {
            this.itemReport.requireField("MIME attachment.filename");
        }
    }

    @Override
    public Long getCreated() {
        return this.created;
    }

    @Override
    public Entity getPermittedGroup() {
        return this.permittedGroup;
    }

    @Override
    public Entity getAuthor() {
        return this.author;
    }

    @Override
    public DiskFileItem getFile() {
        return this.file;
    }

    @Override
    public Entity getIssue() {
        return this.issue;
    }

    public ItemReport getItemReport() {
        return this.itemReport;
    }

    public static boolean isEmpty_vmiymh_a0a0a01a0(String str) {
        return str == null || str.length() == 0;
    }
}

