/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.restImport;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import jetbrains.charisma.links.IssueLinksUtilKt;
import jetbrains.charisma.links.persistent.LinkSourceTarget;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.mps.webr.rpc.rest.runtime.Transformer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.core.security.Permissions;
import jetbrains.youtrack.rest.security.HasAdminReadSecurityConstraint;
import jetbrains.youtrack.restImport.IssuesList;
import jetbrains.youtrack.restImport.LinksList;
import kotlinx.dnq.query.XdQuery;

@Path(value="/export")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@Transactional
public class ExportResource
implements Resource {
    @GET
    @Path(value="/{project}/issues")
    public IssuesList get_ProjectIssues(@Transformer(value="projectById") @PathParam(value="project") Entity project, @QueryParam(value="after") Integer after, @QueryParam(value="max") Integer max) {
        HasAdminReadSecurityConstraint.check();
        Iterable result2 = ((Permissions)ServiceLocator.getBean((String)"permissions")).excludeDraftsAndDeleted(AssociationSemantics.getToMany((Entity)project, (String)"issues"));
        if (after != null && after > 0) {
            result2 = QueryOperations.skip((Iterable)result2, (int)after);
        }
        max = Math.min(max == null ? 10 : Math.max(1, max), (Integer)PrimitiveAssociationSemantics.get((Entity)((Entity)ServiceLocator.getBean((String)"applicationMetaData")), (String)"maxExportItems", Integer.class, null));
        result2 = QueryOperations.take((Iterable)result2, (int)max);
        return new IssuesList(result2);
    }

    @GET
    @Path(value="/links")
    public LinksList get_Links(@QueryParam(value="after") Integer after, @QueryParam(value="max") Integer max) {
        HasAdminReadSecurityConstraint.check();
        Iterable result2 = IssueLinksUtilKt.selectLinks((XdQuery)XdIssue.Companion.all());
        if (after != null && after > 0) {
            result2 = Sequence.fromIterable((Iterable)result2).skip(after.intValue());
        }
        return new LinksList((Iterable<LinkSourceTarget>)Sequence.fromIterable((Iterable)result2).take(this.getMaxElementsToImport(max)));
    }

    private int getMaxElementsToImport(Integer max) {
        return Math.min(max == null ? 10 : Math.max(1, max), (Integer)PrimitiveAssociationSemantics.get((Entity)((Entity)ServiceLocator.getBean((String)"applicationMetaData")), (String)"maxExportItems", Integer.class, null));
    }
}

