/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.restImport;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.UndirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.Set;
import jetbrains.charisma.customfields.persistence.XdCustomFieldPrototype;
import jetbrains.charisma.customfields.persistence.fields.XdUsersBundle;
import jetbrains.charisma.customfields.predefined.SuppliedField;
import jetbrains.charisma.event.IEventIssueListener;
import jetbrains.charisma.persistence.security.InternalPermissionManager;
import jetbrains.charisma.service.UserFields;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.baseLanguage.dates.runtime.CompareType;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ITranslator2;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.admin.IssueCommentStub;
import jetbrains.youtrack.admin.IssueStub;
import jetbrains.youtrack.api.application.RuleEngine;
import jetbrains.youtrack.api.events.EventImporter;
import jetbrains.youtrack.core.persistent.IssueFolderImpl;
import jetbrains.youtrack.core.persistent.ProjectImpl;
import jetbrains.youtrack.core.persistent.UserGroupImpl;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.core.security.DefaultRole;
import jetbrains.youtrack.core.security.Security;
import jetbrains.youtrack.rest.OldImportUtil;
import jetbrains.youtrack.rest.issue.IssueResource;
import jetbrains.youtrack.textindex.TextIndexOperationsCompat;
import org.joda.time.DateTimeFieldType;

public class ImportIssuesUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importIssues(Entity project, String assigneeGroupName, Iterable<IssueStub> issues) {
        boolean shouldSuspendIndex;
        boolean bl = shouldSuspendIndex = !TextIndexOperationsCompat.getTextIndexManager().isSuspended();
        if (shouldSuspendIndex) {
            TextIndexOperationsCompat.getTextIndexManager().suspendIndexing();
        }
        try {
            ((RuleEngine)ServiceLocator.getBean((String)"ruleEngine")).addIgnoreThread();
            ((IEventIssueListener)ServiceLocator.getBean((String)"eventIssueListener")).addIgnoreThread();
            try {
                final Entity assigneeField = OldImportUtil.getProjectField((SuppliedField)ServiceLocator.getBean((String)"issueAssignee"), project);
                if (!EntityOperations.equals((Entity)assigneeField, null)) {
                    Iterable subsystemOwners;
                    Entity bundle2;
                    final Iterable projectAssignees = ((UserFields)ServiceLocator.getBean((String)"userFields")).getAssignees(project);
                    Object newAssignees = Sequence.fromIterable(issues).translate((_FunctionTypes._return_P1_E0)new ITranslator2<IssueStub, Object>(){

                        public Iterable<Object> translate(IssueStub it) {
                            return (Iterable)MapSequence.fromMap(it.getCustomFields()).get((Object)assigneeField);
                        }
                    }).select((_FunctionTypes._return_P1_E0)new ISelector<Object, Entity>(){

                        public Entity select(Object it) {
                            return DnqUtils.cast((Object)it, (String)"User");
                        }
                    });
                    Entity subsystem = OldImportUtil.getProjectField((SuppliedField)ServiceLocator.getBean((String)"issueSubsystem"), project);
                    if (!EntityOperations.equals((Entity)subsystem, null) && (bundle2 = subsystem.getLink("bundle")) != null && !QueryOperations.isEmpty((Iterable)(subsystemOwners = QueryOperations.selectManyDistinct((Iterable)bundle2.getLinks("children"), (String)"owner")))) {
                        newAssignees = QueryOperations.union((Iterable)newAssignees, (Iterable)subsystemOwners);
                    }
                    if (!QueryOperations.isEmpty((Iterable)(newAssignees = Sequence.fromIterable((Iterable)newAssignees).distinct().where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

                        public boolean accept(Entity it) {
                            return !QueryOperations.contains((Iterable)projectAssignees, (Entity)it);
                        }
                    })))) {
                        final Entity assigneeGroup = this.getAssigneeGroup(project, assigneeGroupName);
                        Sequence.fromIterable((Iterable)newAssignees).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

                            public void visit(Entity it) {
                                if (it != null) {
                                    ((Security)ServiceLocator.getBean((String)"security")).addUserToUserGroup(it, assigneeGroup);
                                }
                            }
                        });
                        Entity bundle3 = DnqUtils.as((Object)assigneeField.getLink("bundle"), (String)"UsersBundle");
                        new XdUsersBundle(bundle3).denormalizeUsers();
                    }
                }
                for (IssueStub issueStub : Sequence.fromIterable(issues)) {
                    final Entity newIssue = IssueResource.createIssue(issueStub.getReporter(), project);
                    PrimitiveAssociationSemantics.set((Entity)newIssue, (String)"numberInProject", (Comparable)Long.valueOf(issueStub.getNumberInProject()), Long.class);
                    if (issueStub.getNumberInProject() > ((ProjectImpl)DnqUtils.getPersistentClassInstance((Entity)project, (String)"Project")).getNextIssueNumber(project)) {
                        ((ProjectImpl)DnqUtils.getPersistentClassInstance((Entity)project, (String)"Project")).setNextIssueNumber(issueStub.getNumberInProject(), project);
                    }
                    PrimitiveAssociationSemantics.set((Entity)newIssue, (String)"summary", (Comparable)((Object)issueStub.getSummary()), String.class);
                    PrimitiveAssociationSemantics.setBlobWithFixedNewlines((Entity)newIssue, (String)"description", (String)issueStub.getDescription());
                    PrimitiveAssociationSemantics.set((Entity)newIssue, (String)"usesMarkdown", (Comparable)issueStub.isMarkdown(), Boolean.class);
                    PrimitiveAssociationSemantics.set((Entity)newIssue, (String)"created", (Comparable)issueStub.getCreated());
                    PrimitiveAssociationSemantics.set((Entity)newIssue, (String)"updated", (Comparable)(DateTimeOperations.compare((Long)issueStub.getUpdated(), (CompareType)CompareType.NE, (Long)DateTimeOperations.never(), (DateTimeFieldType)DateTimeFieldType.millisOfSecond()) ? issueStub.getUpdated() : issueStub.getCreated()));
                    DirectedAssociationSemantics.setToOne((Entity)newIssue, (String)"updatedBy", (Entity)(!EntityOperations.equals((Entity)issueStub.getUpdater(), null) ? issueStub.getUpdater() : issueStub.getReporter()));
                    PrimitiveAssociationSemantics.set((Entity)newIssue, (String)"resolved", (Comparable)issueStub.getResolved());
                    Sequence.fromIterable(issueStub.getVoters()).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

                        public void visit(Entity __addallit__) {
                            UndirectedAssociationSemantics.createManyToMany((Entity)newIssue, (String)"voters", (String)"votedIssues", (Entity)__addallit__);
                        }
                    });
                    PrimitiveAssociationSemantics.set((Entity)newIssue, (String)"votes", (Comparable)Integer.valueOf(issueStub.getVotes()), Integer.class);
                    for (Entity user2 : Sequence.fromIterable(issueStub.getWatchers())) {
                        OldImportUtil.watchIssue(newIssue, user2);
                    }
                    OldImportUtil.setPermittedGroup(newIssue, issueStub.getPermittedGroup());
                    ((EventImporter)ServiceLocator.getBean((String)"eventImporter")).importAddEvent(newIssue, newIssue, AssociationSemantics.getToOne((Entity)newIssue, (String)"reporter"), ((Long)PrimitiveAssociationSemantics.get((Entity)newIssue, (String)"created", null)).longValue());
                    for (IssueCommentStub commentStub : Sequence.fromIterable(issueStub.getComments())) {
                        Entity comment = OldImportUtil.createComment(commentStub.getText(), commentStub.getAuthor(), newIssue);
                        PrimitiveAssociationSemantics.set((Entity)comment, (String)"created", (Comparable)commentStub.getCreated());
                        PrimitiveAssociationSemantics.set((Entity)comment, (String)"usesMarkdown", (Comparable)commentStub.isMarkdown(), Boolean.class);
                        OldImportUtil.setPermittedGroup(comment, commentStub.getPermittedGroup());
                        ((EventImporter)ServiceLocator.getBean((String)"eventImporter")).importAddEvent(newIssue, comment, AssociationSemantics.getToOne((Entity)comment, (String)"author"), ((Long)PrimitiveAssociationSemantics.get((Entity)comment, (String)"created", null)).longValue());
                    }
                    for (Entity customField : SetSequence.fromSet((Set)MapSequence.fromMap(issueStub.getCustomFields()).keySet())) {
                        Iterable values = (Iterable)MapSequence.fromMap(issueStub.getCustomFields()).get((Object)customField);
                        ((XdCustomFieldPrototype)XdCustomFieldPrototype.Companion.wrap(customField.getLink("prototype"))).setValues((XdIssue)XdIssue.Companion.wrap(newIssue), values);
                    }
                }
                DnqUtils.getCurrentTransientSession().flush();
            }
            finally {
                ((IEventIssueListener)ServiceLocator.getBean((String)"eventIssueListener")).removeIgnoreThread();
                ((RuleEngine)ServiceLocator.getBean((String)"ruleEngine")).removeIgnoreThread();
            }
        }
        finally {
            if (shouldSuspendIndex) {
                TextIndexOperationsCompat.getTextIndexManager().resumeIndexing();
            }
        }
    }

    private Entity getAssigneeGroup(Entity project, String assigneeGroupName) {
        Entity bundle2;
        Entity userGroup2;
        if (assigneeGroupName == null || assigneeGroupName.length() == 0) {
            assigneeGroupName = ((String)PrimitiveAssociationSemantics.get((Entity)project, (String)"name", String.class, (Object)IssueFolderImpl.getNullName())).toLowerCase() + "-developers";
        }
        if (EntityOperations.equals((Entity)(userGroup2 = QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"UserGroup", (NodeBase)new PropertyEqual("name", (Comparable)((Object)assigneeGroupName))))), null)) {
            userGroup2 = UserGroupImpl.constructor((String)assigneeGroupName);
            PrimitiveAssociationSemantics.set((Entity)userGroup2, (String)"description", (Comparable)((Object)((String)PrimitiveAssociationSemantics.get((Entity)project, (String)"name", String.class, (Object)IssueFolderImpl.getNullName()) + " assignees")), String.class);
            DefaultRole role2 = DefaultRole.DEVELOPER;
            ((InternalPermissionManager)ServiceLocator.getBean((String)"internalPermissionsManager")).grantPermissionsToGroup(role2.getName(), userGroup2, role2.getPermissions(), QueryOperations.singleton((Entity)project));
        }
        if (DnqUtils._instanceOf((Object)(bundle2 = OldImportUtil.getProjectField((SuppliedField)ServiceLocator.getBean((String)"issueAssignee"), project).getLink("bundle")), (String)"UsersBundle")) {
            DirectedAssociationSemantics.createToMany((Entity)DnqUtils.cast((Object)bundle2, (String)"UsersBundle"), (String)"groups", (Entity)userGroup2);
        }
        return userGroup2;
    }
}

