/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.restImport;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.youtrack.restImport.ImportResource;
import jetbrains.youtrack.restImport.ItemReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="importReport")
public class ImportReport {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportResource.class);
    @XmlElements(value={@XmlElement(name="item")})
    private List<ItemReport> items;
    private boolean failed = false;
    @XmlAttribute
    private String generalError;

    public void add(ItemReport errors) {
        if (this.items == null) {
            this.items = ListSequence.fromList(new ArrayList());
        }
        ListSequence.fromList(this.items).addElement((Object)errors);
        if (!errors.isEmpty()) {
            this.failed = true;
        }
    }

    public boolean isNotEmpty() {
        return ListSequence.fromList(this.items).isNotEmpty();
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setGeneralError(String generalError) {
        this.generalError = generalError;
        this.failed = generalError != null && generalError.length() > 0;
    }

    public void logErrors() {
        try {
            if (this.failed) {
                StringWriter writer = new StringWriter();
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ImportReport.class});
                Marshaller m = context.createMarshaller();
                m.marshal((Object)this, (Writer)writer);
                LOGGER.warn(writer.toString());
            }
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

